/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.commands;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.toast.ToastHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CmdIncrementSkill
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "incrementskill";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "reskillable.command.incrementskill.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        int maxLevel;
        ResourceLocation skillName;
        if (args.length == 0) {
            throw new CommandException("reskillable.command.invalid.missing.playerskill", new Object[0]);
        }
        if (args.length == 1) {
            throw new CommandException("reskillable.command.invalid.missing.skill", new Object[0]);
        }
        EntityPlayerMP player = CmdIncrementSkill.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        args[1] = args[1].replaceAll(":", ".");
        String[] parts = args[1].split("\\.");
        ResourceLocation resourceLocation = skillName = parts.length > 1 ? new ResourceLocation(parts[0], args[1].substring(parts[0].length() + 1)) : new ResourceLocation(args[1]);
        if (!ReskillableRegistries.SKILLS.containsKey(skillName)) {
            throw new CommandException("reskillable.command.invalid.skill", new Object[]{skillName});
        }
        int levels = 1;
        if (args.length > 2) {
            try {
                levels = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("reskillable.command.invalid.missing.level", new Object[]{args[2]});
            }
            if (levels < 1) {
                throw new CommandException("reskillable.command.invalid.belowmin", new Object[]{levels});
            }
        }
        Skill skill = (Skill)ReskillableRegistries.SKILLS.getValue(skillName);
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo skillInfo = data.getSkillInfo(skill);
        int oldLevel = skillInfo.getLevel();
        if (oldLevel + levels > (maxLevel = skill.getCap()) && (levels = maxLevel - oldLevel) <= 0) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.fail.skillup", new Object[]{skillName, player.func_145748_c_()}));
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Pre((EntityPlayer)player, skill, oldLevel + levels, oldLevel))) {
            skillInfo.setLevel(oldLevel + levels);
            data.saveAndSync();
            MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((EntityPlayer)player, skill, skillInfo.getLevel(), oldLevel));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.success.skillup", new Object[]{skillName, player.func_145748_c_()}));
            ToastHelper.sendSkillToast(player, skill, skillInfo.getLevel());
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.fail.skillup", new Object[]{skillName, player.func_145748_c_()}));
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 0) {
            return Arrays.asList(server.func_184103_al().func_72369_d());
        }
        if (args.length == 1) {
            String partialName = args[0];
            return Arrays.stream(server.func_184103_al().func_72369_d()).filter(name -> name.startsWith(partialName)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String partial = args[1].replaceAll(":", ".");
            return ReskillableRegistries.SKILLS.getValuesCollection().stream().map(Skill::getKey).filter(skillName -> skillName.startsWith(partial)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public int func_82362_a() {
        return 2;
    }
}

