/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.dorkbox.tweenEngine;

import java.util.HashMap;
import java.util.Map;
import net.aeronica.dorkbox.tweenEngine.TweenAccessor;
import net.aeronica.dorkbox.tweenEngine.TweenEngine;

public class EngineBuilder {
    private boolean threadSafe = true;
    private Map<Class<?>, TweenAccessor<?>> registeredAccessors = new HashMap();
    private int combinedAttrsLimit = 3;
    private int waypointsLimit = 0;

    EngineBuilder() {
    }

    public TweenEngine build() {
        if (this.threadSafe) {
            return new TweenEngine(this.threadSafe, this.combinedAttrsLimit, this.waypointsLimit, this.registeredAccessors);
        }
        return new TweenEngine(this.threadSafe, this.combinedAttrsLimit, this.waypointsLimit, this.registeredAccessors){

            @Override
            long flushRead() {
                return 0L;
            }

            @Override
            void flushWrite() {
            }
        };
    }

    public EngineBuilder unsafe() {
        this.threadSafe = false;
        return this;
    }

    public EngineBuilder setCombinedAttributesLimit(int limit) {
        this.combinedAttrsLimit = limit;
        return this;
    }

    public EngineBuilder setWaypointsLimit(int limit) {
        this.waypointsLimit = limit;
        return this;
    }

    public EngineBuilder registerAccessor(Class<?> someClass, TweenAccessor<?> defaultAccessor) {
        this.registeredAccessors.put(someClass, defaultAccessor);
        return this;
    }

    public int getCombinedAttrsLimit() {
        return this.combinedAttrsLimit;
    }

    public int getWaypointsLimit() {
        return this.waypointsLimit;
    }
}

