/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.client.KeyHelper;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.server.ModConfig;
import net.aeronica.mods.bard_mania.server.ModLogger;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.aeronica.mods.bard_mania.server.network.server.ActiveReceiverMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum MidiHelper implements Receiver
{
    INSTANCE;

    private static List<MidiDevice> openDevices;
    static boolean inUse;
    private static String soundName;

    public void setKeyboardNoteReceiver(String soundNameIn) {
        if (ModConfig.client.input_mode == ModConfig.Client.INPUT_MODE.KEYBOARD) {
            soundName = soundNameIn;
            EntityPlayer playerIn = BardMania.proxy.getClientPlayer();
            playerIn.openGui((Object)BardMania.instance(), 0, playerIn.func_130014_f_(), 0, 0, 0);
            inUse = true;
        }
    }

    public void setMidiNoteReceiver(String soundNameIn) {
        if (ModConfig.client.input_mode == ModConfig.Client.INPUT_MODE.MIDI && !inUse) {
            soundName = soundNameIn;
            MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                try {
                    MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                    if (device.isOpen()) {
                        device.close();
                    }
                    ModLogger.info("%s, %d", infos[i], device.getMaxTransmitters());
                    if (device.getMaxTransmitters() == 0 || device instanceof Sequencer) continue;
                    device.getTransmitter().setReceiver(this.getReceiver());
                    device.open();
                    openDevices.add(device);
                    ModLogger.info("%s was opened", device.getDeviceInfo());
                    inUse = true;
                    continue;
                }
                catch (MidiUnavailableException e) {
                    ModLogger.error(e);
                }
            }
        }
    }

    public static List<String> getOpenDeviceNames() {
        return openDevices.stream().map(d -> d.getDeviceInfo().getName()).collect(Collectors.toList());
    }

    private Receiver getReceiver() {
        return INSTANCE;
    }

    @Override
    public void send(MidiMessage msg, long timeStamp) {
        boolean noteOffFlag;
        byte[] message = msg.getMessage();
        int command = msg.getStatus() & 0xF0;
        int channel = msg.getStatus() & 0xF;
        boolean allChannels = ModConfig.client.midi_options.allChannels;
        boolean sendNoteOff = SoundHelper.shouldSendNoteOff(soundName);
        switch (command) {
            case 128: {
                message[2] = 0;
                break;
            }
            case 144: {
                break;
            }
            default: {
                return;
            }
        }
        boolean channelFlag = allChannels || channel == ModConfig.client.midi_options.channel - 1;
        boolean bl = noteOffFlag = sendNoteOff || message[2] != 0;
        if (channelFlag && noteOffFlag) {
            Minecraft.func_71410_x().func_152344_a(() -> MidiHelper.send(message[1], message[2], 5L));
        }
    }

    public static void send(byte note, byte volume, long timeStamp) {
        EntityPlayer player = BardMania.proxy.getClientPlayer();
        if (player != null && KeyHelper.isMidiNoteInRange(note)) {
            ActiveReceiverMessage packet = new ActiveReceiverMessage(player.func_180425_c(), player.func_145782_y(), note, volume, timeStamp);
            PacketDispatcher.sendToServer(packet);
            BardMania.proxy.playSound(player, note, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MidiHelper midiHelper = INSTANCE;
        synchronized (midiHelper) {
            for (MidiDevice device : openDevices) {
                if (!device.isOpen()) continue;
                try {
                    device.getTransmitter().close();
                    device.close();
                }
                catch (NullPointerException | MidiUnavailableException e) {
                    ModLogger.error(e);
                }
            }
            openDevices.clear();
        }
    }

    public void notifyRemoved(String message) {
        this.invalidate(message);
    }

    public void notifyRemoved(ItemStack stackIn) {
        if (!stackIn.func_190926_b()) {
            this.invalidate(stackIn.func_82833_r());
        } else {
            this.invalidate("EMPTY STACK");
        }
    }

    private void invalidate(String message) {
        ModLogger.info("ActiveNoteReceiver Removed: %s", message);
        inUse = false;
        this.close();
    }

    static {
        openDevices = new CopyOnWriteArrayList<MidiDevice>();
        inUse = false;
    }
}

