/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.actions.base;

import it.unimi.dsi.fastutil.objects.Object2ReferenceArrayMap;
import java.util.Map;
import net.aeronica.dorkbox.tweenEngine.Timeline;
import net.aeronica.dorkbox.tweenEngine.TweenEngine;
import net.aeronica.dorkbox.tweenEngine.TweenEquations;
import net.aeronica.mods.bard_mania.client.actions.BanjoTimeLines;
import net.aeronica.mods.bard_mania.client.actions.FluteTimeLines;
import net.aeronica.mods.bard_mania.client.actions.LyreTimeLines;
import net.aeronica.mods.bard_mania.client.actions.MarchingDrumsTimeLines;
import net.aeronica.mods.bard_mania.client.actions.RecorderTimeLines;
import net.aeronica.mods.bard_mania.client.actions.XylophoneTimeLines;
import net.aeronica.mods.bard_mania.client.actions.base.IFunctionTimeLine;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.minecraft.entity.player.EntityPlayer;

public class ActionDispatcher {
    private static final Map<String, IFunctionTimeLine> instActions = new Object2ReferenceArrayMap();

    public static Timeline select(String id, String action, EntityPlayer playerIn, TweenEngine tweenEngine, Timeline timeline, ModelDummy modelDummy, int normalizedNote) {
        StringBuilder key = new StringBuilder(id).append("_").append(action);
        if (instActions.containsKey(key.toString())) {
            return instActions.get(key.toString()).invoke(playerIn, tweenEngine, timeline, modelDummy, normalizedNote);
        }
        return ActionDispatcher.fallback(action, timeline, tweenEngine, modelDummy, normalizedNote);
    }

    private static Timeline fallback(String action, Timeline timeline, TweenEngine tweenEngine, ModelDummy modelDummy, int normalizedNote) {
        switch (action) {
            case "apply": {
                modelDummy.setPartValue(49, 1.0f);
                break;
            }
            case "play": {
                timeline.beginParallel().push(tweenEngine.to(modelDummy, 0, 0.15f).target(-0.1f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 1, 0.15f).target(ActionDispatcher.lookNotePosition(normalizedNote)).ease(TweenEquations.Sine_InOut)).end().beginParallel().push(tweenEngine.to(modelDummy, 0, 0.15f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 1, 0.15f).target(0.0f).ease(TweenEquations.Sine_InOut)).end();
                break;
            }
            case "equip": {
                timeline.beginParallel().push(tweenEngine.to(modelDummy, 49, 0.5f).target(1.0f).ease(TweenEquations.Bounce_InOut)).end();
                break;
            }
            case "remove": {
                timeline.beginParallel().push(tweenEngine.to(modelDummy, 49, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).end();
                break;
            }
        }
        return timeline;
    }

    private static float lookNotePosition(int normalizedNote) {
        return -((float)normalizedNote * 1.2f) / 24.0f + 0.6f;
    }

    static {
        instActions.put("lyre_play", LyreTimeLines::play);
        instActions.put("lyre_equip", LyreTimeLines::equip);
        instActions.put("lyre_remove", LyreTimeLines::remove);
        instActions.put("lyre_apply", LyreTimeLines::apply);
        instActions.put("banjo_play", BanjoTimeLines::play);
        instActions.put("banjo_equip", BanjoTimeLines::equip);
        instActions.put("banjo_remove", BanjoTimeLines::remove);
        instActions.put("banjo_apply", BanjoTimeLines::apply);
        instActions.put("flute_play", FluteTimeLines::play);
        instActions.put("flute_equip", FluteTimeLines::equip);
        instActions.put("flute_remove", FluteTimeLines::remove);
        instActions.put("flute_apply", FluteTimeLines::apply);
        instActions.put("recorder_play", RecorderTimeLines::play);
        instActions.put("recorder_equip", RecorderTimeLines::equip);
        instActions.put("recorder_remove", RecorderTimeLines::remove);
        instActions.put("recorder_apply", RecorderTimeLines::apply);
        instActions.put("xylophone_play", XylophoneTimeLines::play);
        instActions.put("xylophone_equip", XylophoneTimeLines::equip);
        instActions.put("xylophone_remove", XylophoneTimeLines::remove);
        instActions.put("xylophone_apply", XylophoneTimeLines::apply);
        instActions.put("marching_drums_play", MarchingDrumsTimeLines::play);
        instActions.put("marching_drums_equip", MarchingDrumsTimeLines::equip);
        instActions.put("marching_drums_remove", MarchingDrumsTimeLines::remove);
        instActions.put("marching_drums_apply", MarchingDrumsTimeLines::apply);
    }
}

