/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.actions.base;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.aeronica.mods.bard_mania.Reference;
import net.aeronica.mods.bard_mania.client.actions.base.ActionBase;
import net.aeronica.mods.bard_mania.client.actions.base.ApplyPose;
import net.aeronica.mods.bard_mania.client.actions.base.EquipAction;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.aeronica.mods.bard_mania.client.actions.base.PlayAction;
import net.aeronica.mods.bard_mania.client.actions.base.RemoveAction;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="bard_mania")
public class ActionManager {
    private static final ActionManager instance = new ActionManager();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final ModelDummy modelDummy = new ModelDummy();
    private static List<ActionBase> actions = new CopyOnWriteArrayList<ActionBase>();
    private static float deltaTime = 0.0f;
    private static double total = 0.0;
    private static float partialTicks = 0.0f;
    private static boolean isGamePaused = true;

    private ActionManager() {
    }

    public static void applyPose(EntityPlayer playerIn) {
        ModelDummy modelDummy = BardActionHelper.getModelDummy(playerIn);
        actions.add(new ApplyPose(playerIn, modelDummy));
    }

    public static void playAction(EntityPlayer playerIn, int noteIn) {
        ModelDummy modelDummy = BardActionHelper.getModelDummy(playerIn);
        actions.add(new PlayAction(playerIn, modelDummy, noteIn));
    }

    public static void equipAction(EntityPlayer playerIn) {
        ModelDummy modelDummy = BardActionHelper.getModelDummy(playerIn);
        actions.add(new EquipAction(playerIn, modelDummy));
    }

    public static void removeAction(EntityPlayer playerIn) {
        ModelDummy modelDummy = BardActionHelper.getModelDummy(playerIn);
        actions.add(new RemoveAction(playerIn, modelDummy));
    }

    public static int getActionsCount() {
        return actions != null ? actions.size() : 0;
    }

    private int getActionsCount(EntityPlayer entityPlayer) {
        int count = 0;
        ModelDummy modelPlayerDummy = BardActionHelper.getModelDummy(entityPlayer);
        for (ActionBase action : actions) {
            if (modelPlayerDummy != action.getModelDummy()) continue;
            ++count;
        }
        return count;
    }

    public static int getTweenCount(EntityPlayer entityPlayer) {
        return instance.getActionsCount(entityPlayer);
    }

    public static boolean hasTweens(EntityPlayer entityPlayer) {
        return instance.getActionsCount(entityPlayer) > 0;
    }

    public static ModelDummy getModelDummy(EntityPlayer playerIn) {
        return playerIn.hasCapability(Reference.BARD_ACTION_CAP, null) ? BardActionHelper.getModelDummy(playerIn) : modelDummy;
    }

    private static void update(float deltaTimeIn) {
        if (ActionManager.mc.field_71441_e != null && !isGamePaused) {
            actions.forEach(triggerAction -> triggerAction.update(deltaTimeIn));
        }
    }

    private static void cleanup() {
        if (ActionManager.mc.field_71441_e != null && !isGamePaused) {
            actions.stream().filter(ActionBase::isDone).forEach(action -> actions.remove(action));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            isGamePaused = mc.func_147113_T();
            partialTicks = event.renderTickTime;
            ActionManager.cleanup();
            return;
        }
        ActionManager.calcDelta();
        ActionManager.update(deltaTime);
    }

    private static void calcDelta() {
        if (ActionManager.mc.field_71441_e != null && !isGamePaused) {
            double oldTotal = total;
            total = ActionManager.getElapsedWorldTime(partialTicks);
            deltaTime = (float)(total - oldTotal);
        }
    }

    public static double getElapsedWorldTime(float partialTicks) {
        WorldClient world = ActionManager.mc.field_71441_e;
        long time = world != null ? world.func_82737_E() : (long)total;
        return ((float)time + partialTicks) / 20.0f;
    }
}

