/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.aeronica.mods.bard_mania.client.gui.ISelectorAction;
import net.aeronica.mods.bard_mania.client.gui.MidiFilter;

public class MidiChooser
extends JFrame {
    private static Preferences preferences = Preferences.userNodeForPackage(MidiChooser.class);

    MidiChooser(ISelectorAction action) {
        super("");
        this.setDefaultCloseOperation(2);
        JFileChooser chooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.setLocationByPlatform(true);
                dialog.setAlwaysOnTop(true);
                return dialog;
            }
        };
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new MidiFilter());
        chooser.setCurrentDirectory(this.loadPreferences(chooser));
        chooser.setFileSelectionMode(2);
        this.setAlwaysOnTop(true);
        Action details = chooser.getActionMap().get("viewTypeDetails");
        details.actionPerformed(null);
        if (chooser.showOpenDialog(this) == 0) {
            this.savePreferences(chooser);
            action.select(chooser.getSelectedFile());
            this.dispose();
        }
    }

    private void savePreferences(JFileChooser chooser) {
        preferences.put("path", chooser.getSelectedFile().getParent());
    }

    private File loadPreferences(JFileChooser chooser) {
        return new File(preferences.get("path", chooser.getCurrentDirectory().getParent()));
    }
}

