/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.render;

import com.mrcrayfish.obfuscate.client.event.ModelPlayerEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import java.lang.reflect.Field;
import net.aeronica.mods.bard_mania.client.actions.base.ActionManager;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.client.render.RenderHelper;
import net.aeronica.mods.bard_mania.client.render.RenderUtil;
import net.aeronica.mods.bard_mania.server.IPlaceableBounding;
import net.aeronica.mods.bard_mania.server.LocationArea;
import net.aeronica.mods.bard_mania.server.ModConfig;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.aeronica.mods.bard_mania.server.init.ModInstruments;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderEvents {
    public static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("bard_mania", "textures/gui/gui_player_background.png");
    public static final int HOT_BAR_CLEARANCE = 40;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static float motionIncDec = 0.05f;
    private static float motionSimple = 0.0f;
    public static final ItemStack DRUM_STICK = new ItemStack(ModInstruments.DRUM_STICK);
    public static final ItemStack MALLET = new ItemStack(ModInstruments.MALLET);
    public static Field inPortal = ReflectionHelper.findField(Entity.class, (String[])new String[]{"inPortal", "field_71087_bX"});
    private static RenderLivingBase<?> renderLivingBase;

    public static RenderLivingBase<?> getRenderLivingBase() {
        return renderLivingBase;
    }

    private static ItemStack getHeldSelector() {
        for (ItemStack held : RenderEvents.mc.field_71439_g.func_184214_aD()) {
            if (held.func_190926_b() || !(held.func_77973_b() instanceof IPlaceableBounding)) continue;
            return held;
        }
        return ItemStack.field_190927_a;
    }

    private static void renderBox(BlockPos pos, double partialTicks) {
        RenderEvents.renderBox(new AxisAlignedBB(pos).func_186662_g(-0.00625), partialTicks);
    }

    private static void renderBox(BlockPos pos1, BlockPos pos2, double partialTicks) {
        RenderEvents.renderBox(new AxisAlignedBB(pos1, pos2).func_186662_g(-0.00625), partialTicks);
    }

    private static void renderBox(AxisAlignedBB box, double partialTicks) {
        EntityPlayerSP player = RenderEvents.mc.field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        RenderGlobal.func_189696_b((AxisAlignedBB)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void renderSelection(RenderWorldLastEvent event) {
        BlockPos pos;
        ItemStack heldItem = RenderEvents.getHeldSelector();
        if (heldItem.func_190926_b()) {
            return;
        }
        IPlaceableBounding blockPlacer = (IPlaceableBounding)heldItem.func_77973_b();
        EntityPlayerSP player = RenderEvents.mc.field_71439_g;
        World world = player.func_130014_f_();
        RayTraceResult rayTraceResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)5.0);
        if (rayTraceResult != null && rayTraceResult.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK) && rayTraceResult.field_178784_b.equals((Object)EnumFacing.UP) && blockPlacer.canPlaceHere((EntityPlayer)player, world, heldItem, pos = rayTraceResult.func_178782_a(), rayTraceResult.field_178784_b)) {
            LocationArea boundingBox = blockPlacer.getBoundingBox((EntityPlayer)player, world, pos);
            RenderEvents.renderBox(boundingBox.getStartingPoint(), boundingBox.getStartPointPlusSize(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (RenderEvents.mc.field_71474_y.field_74330_P || RenderEvents.mc.field_71474_y.field_74320_O > 0 || !RenderEvents.mc.field_71415_G || ModConfig.client.input_mode != ModConfig.Client.INPUT_MODE.MIDI) {
            return;
        }
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && RenderEvents.mc.field_71439_g.func_184614_ca().func_77973_b() instanceof ItemInstrument && RenderHelper.canRenderEquippedInstrument((EntityPlayer)RenderEvents.mc.field_71439_g)) {
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b() - 40;
            RenderEvents.drawGuiPlayerBackgroundLayer(mc.func_184121_ak(), width, height);
        }
    }

    public static void drawCenteredString(String text, int x, int y, int color) {
        RenderEvents.mc.field_71466_p.func_175063_a(text, (float)(x - RenderEvents.mc.field_71466_p.func_78256_a(text) / 2), (float)y, color);
    }

    public static void drawString(String text, int x, int y, int color) {
        RenderEvents.mc.field_71466_p.func_175063_a(text, (float)x, (float)y, color);
    }

    private static void drawGuiPlayerBackgroundLayer(float partialTicks, int scaledWidth, int scaledHeight) {
        mc.func_110434_K().func_110577_a(GUI_BACKGROUND);
        int xPos = (scaledWidth - 50) / scaledWidth;
        int yPos = (scaledHeight - 60) / scaledHeight;
        int entityXPos = xPos + 25 + 2;
        int entityYPos = yPos + 60 - 5;
        Gui.func_146110_a((int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)50, (int)60, (float)128.0f, (float)128.0f);
        GuiInventory.func_147046_a((int)entityXPos, (int)entityYPos, (int)25, (float)10.0f, (float)-10.0f, (EntityLivingBase)RenderEvents.mc.field_71439_g);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderSpecificHandEvent event) {
        ItemStack heldItem = event.getItemStack();
        if (event.getHand().equals((Object)EnumHand.OFF_HAND) && BardActionHelper.isInstrumentEquipped((EntityPlayer)RenderEvents.mc.field_71439_g)) {
            event.setCanceled(true);
        }
        if (!(heldItem.func_77973_b() instanceof ItemInstrument)) {
            return;
        }
        Instrument instrument = ((ItemInstrument)heldItem.func_77973_b()).getInstrument();
        if (event.getHand() == EnumHand.MAIN_HAND && BardActionHelper.isInstrumentEquipped((EntityPlayer)RenderEvents.mc.field_71439_g) && instrument.general.wearable) {
            event.setCanceled(true);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.5625, (double)-0.5625);
            GlStateManager.func_179109_b((float)instrument.display.equipped_first_person.translation[0], (float)instrument.display.equipped_first_person.translation[1], (float)instrument.display.equipped_first_person.translation[2]);
            GlStateManager.func_179114_b((float)instrument.display.equipped_first_person.rotation[0], (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)instrument.display.equipped_first_person.rotation[1], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)instrument.display.equipped_first_person.rotation[2], (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)instrument.display.equipped_first_person.scale[0], (float)instrument.display.equipped_first_person.scale[1], (float)instrument.display.equipped_first_person.scale[2]);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(event.getItemStack(), ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if ((motionSimple += motionIncDec) > 1.0f) {
                motionIncDec = -0.025f;
            }
            if (motionSimple < -1.0f) {
                motionIncDec = 0.025f;
            }
            RenderHelper.decrementPlayTimers();
            SoundHelper.updateBackgroundMusicPausing();
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Pre event) {
        renderLivingBase = event.getRenderer();
        RenderHelper.renderPartyingWhilePlaying();
    }

    @SubscribeEvent
    public static void onRenderHeldItem(RenderItemEvent.Held.Pre event) {
        Instrument instrument;
        if (!(event.getEntity() instanceof EntityPlayer && event.getEntity().func_184614_ca().func_77973_b() instanceof ItemInstrument || !RenderHelper.canRenderEquippedInstrument((EntityPlayer)event.getEntity()))) {
            event.setCanceled(false);
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ItemStack itemMain = player.func_184614_ca();
        boolean isMainHandHeld = !itemMain.func_190926_b() && itemMain.func_77973_b() instanceof ItemInstrument;
        boolean renderLeft = event.getHandSide().equals((Object)EnumHandSide.LEFT);
        boolean canRenderEquippedInstrument = RenderHelper.canRenderEquippedInstrument(player);
        if (player.func_184591_cq() != event.getHandSide() && isMainHandHeld && canRenderEquippedInstrument) {
            event.setCanceled(true);
            return;
        }
        ItemStack heldItem = event.getItem();
        if (heldItem.func_77973_b() instanceof ItemInstrument && event.getHandSide().equals((Object)player.func_184591_cq()) && canRenderEquippedInstrument) {
            event.setCanceled(true);
            instrument = ((ItemInstrument)heldItem.func_77973_b()).getInstrument();
            if (instrument.general.wearable) {
                return;
            }
            RenderEvents.applyRightHandHeldItemTransforms(ActionManager.getModelDummy(player), motionSimple);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a((EntityLivingBase)player, heldItem, renderLeft ? ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, renderLeft);
        }
        if (heldItem.func_77973_b() instanceof ItemInstrument && !event.getHandSide().equals((Object)player.func_184591_cq()) && canRenderEquippedInstrument) {
            event.setCanceled(true);
            instrument = ((ItemInstrument)heldItem.func_77973_b()).getInstrument();
            if (instrument.general.wearable) {
                return;
            }
            RenderEvents.applyLeftHandHeldItemTransforms(ActionManager.getModelDummy(player), motionSimple);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a((EntityLivingBase)player, heldItem, renderLeft ? ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, renderLeft);
        }
    }

    @SubscribeEvent
    public static void onSetupAngles(ModelPlayerEvent.SetupAngles.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemInstrument && RenderHelper.canRenderEquippedInstrument(player)) {
            ModelPlayer model = event.getModelPlayer();
            RenderEvents.applyPlayerModelRotation(model, ActionManager.getModelDummy(player), motionSimple, player.func_184591_cq().equals((Object)EnumHandSide.LEFT));
            RenderEvents.copyModelAngles(model.field_178723_h, model.field_178732_b);
            RenderEvents.copyModelAngles(model.field_178724_i, model.field_178734_a);
            RenderEvents.copyModelAngles(model.field_178721_j, model.field_178731_d);
            RenderEvents.copyModelAngles(model.field_178722_k, model.field_178733_c);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemInstrument) {
            RenderEvents.applyPlayerPreRender(player, ActionManager.getModelDummy(player), motionSimple, player.func_184591_cq().equals((Object)EnumHandSide.LEFT));
        }
    }

    @SubscribeEvent
    public static void onRenderEntityItem(RenderItemEvent.Entity.Pre event) {
        event.setCanceled(RenderEvents.renderInstrument(event.getItem(), event.getTransformType()));
    }

    @SubscribeEvent
    public static void onRenderEntityItem(RenderItemEvent.Gui.Pre event) {
        event.setCanceled(RenderEvents.renderInstrument(event.getItem(), event.getTransformType()));
    }

    private static boolean renderInstrument(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        if (stack.func_77973_b() instanceof ItemInstrument) {
            GlStateManager.func_179094_E();
            RenderUtil.applyTransformType(stack, transformType);
            RenderUtil.renderModel(stack);
            GlStateManager.func_179121_F();
            return true;
        }
        return false;
    }

    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    private static void applyPlayerModelRotation(ModelPlayer model, ModelDummy actions, float motion, boolean leftHand) {
        model.field_78116_c.field_78795_f = actions.getPartValue(18) - actions.getPartValue(0);
        model.field_78116_c.field_78796_g += actions.getPartValue(19) - actions.getPartValue(1);
        model.field_78116_c.field_78808_h += actions.getPartValue(20) - actions.getPartValue(2);
        model.field_78115_e.field_78795_f += actions.getPartValue(21) - actions.getPartValue(3);
        model.field_78115_e.field_78795_f += actions.getPartValue(22) - actions.getPartValue(4);
        model.field_78115_e.field_78795_f += actions.getPartValue(23) - actions.getPartValue(5);
        model.field_178723_h.field_78795_f = actions.getPartValue(24) - actions.getPartValue(6) + motion / 30.0f;
        model.field_178723_h.field_78796_g = actions.getPartValue(25) - actions.getPartValue(7) - motion / 30.0f;
        model.field_178723_h.field_78808_h = actions.getPartValue(26) - actions.getPartValue(8);
        model.field_178724_i.field_78795_f = actions.getPartValue(27) - actions.getPartValue(9) - motion / 30.0f;
        model.field_178724_i.field_78796_g = actions.getPartValue(28) - actions.getPartValue(10) + motion / 30.0f;
        model.field_178724_i.field_78808_h = actions.getPartValue(29) - actions.getPartValue(11);
        model.field_178721_j.field_78795_f += actions.getPartValue(30) - actions.getPartValue(12);
        model.field_178721_j.field_78796_g += actions.getPartValue(31) - actions.getPartValue(13);
        model.field_178721_j.field_78808_h += actions.getPartValue(32) - actions.getPartValue(14);
        model.field_178722_k.field_78795_f += actions.getPartValue(33) - actions.getPartValue(15);
        model.field_178722_k.field_78796_g += actions.getPartValue(34) - actions.getPartValue(16);
        model.field_178722_k.field_78808_h += actions.getPartValue(35) - actions.getPartValue(17);
    }

    private static void applyPlayerPreRender(EntityPlayer player, ModelDummy actions, float motion, boolean leftHand) {
        player.field_70760_ar = player.field_70126_B + actions.getPartValue(36);
        player.field_70761_aq = player.field_70177_z + actions.getPartValue(36);
    }

    public static void applyRightHandHeldItemTransforms(ModelDummy actions, float motion) {
        GlStateManager.func_179109_b((float)actions.getPartValue(37), (float)actions.getPartValue(38), (float)actions.getPartValue(39));
        GlStateManager.func_179114_b((float)actions.getPartValue(42), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)actions.getPartValue(41), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)actions.getPartValue(40), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void applyLeftHandHeldItemTransforms(ModelDummy actions, float motion) {
        GlStateManager.func_179109_b((float)actions.getPartValue(43), (float)actions.getPartValue(44), (float)actions.getPartValue(45));
        GlStateManager.func_179114_b((float)actions.getPartValue(48), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)actions.getPartValue(47), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)actions.getPartValue(46), (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

