/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.render;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RenderUtil {
    public static IBakedModel getModel(ResourceLocation resource, int meta) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(Item.func_111206_d((String)resource.toString()), 1, meta));
    }

    public static void rotateZ(float xOffset, float yOffset, float rotation) {
        GlStateManager.func_179109_b((float)xOffset, (float)yOffset, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)(-xOffset), (float)(-yOffset), (float)0.0f);
    }

    public static void renderModel(ItemStack stack) {
        RenderUtil.renderModel(stack, ItemCameraTransforms.TransformType.NONE);
    }

    public static void renderModel(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        RenderUtil.renderModel(model, transformType);
    }

    public static void renderModel(IBakedModel model) {
        RenderUtil.renderModel(model, ItemCameraTransforms.TransformType.NONE);
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType) {
        RenderUtil.renderModel(model, transformType, null);
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, @Nullable Transform transform) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
        GlStateManager.func_179094_E();
        RenderUtil.renderModel(model, transform);
        GlStateManager.func_179121_F();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179121_F();
    }

    private static void renderModel(IBakedModel model, @Nullable Transform transform) {
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (transform != null) {
            transform.apply();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            RenderUtil.renderQuads(buffer, model.func_188616_a(null, enumfacing, 0L));
        }
        RenderUtil.renderQuads(buffer, model.func_188616_a(null, null, 0L));
        tessellator.func_78381_a();
    }

    private static void renderQuads(BufferBuilder buffer, List<BakedQuad> quads) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quads.get(i), (int)-1);
        }
    }

    public static void applyTransformType(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        ItemTransformVec3f transformVec3f = model.func_177552_f().func_181688_b(transformType);
        GlStateManager.func_179109_b((float)transformVec3f.field_178365_c.getX(), (float)transformVec3f.field_178365_c.getY(), (float)transformVec3f.field_178365_c.getZ());
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.getX(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.getY(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.getZ(), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)transformVec3f.field_178363_d.getX(), (float)transformVec3f.field_178363_d.getY(), (float)transformVec3f.field_178363_d.getZ());
    }

    public static interface Transform {
        public void apply();
    }
}

