/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server;

import net.aeronica.mods.bard_mania.server.ModLogger;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LocationArea {
    public BlockPos pos1;
    public BlockPos pos2;

    public LocationArea(BlockPos position1, BlockPos position2) {
        this.pos1 = new BlockPos((Vec3i)position1);
        this.pos2 = new BlockPos((Vec3i)position2);
    }

    public BlockPos getStartingPoint() {
        int x = Math.min(this.pos1.func_177958_n(), this.pos2.func_177958_n());
        int y = Math.min(this.pos1.func_177956_o(), this.pos2.func_177956_o());
        int z = Math.min(this.pos1.func_177952_p(), this.pos2.func_177952_p());
        return new BlockPos(x, y, z);
    }

    public BlockPos getEndPoint() {
        int x = Math.max(this.pos1.func_177958_n(), this.pos2.func_177958_n());
        int y = Math.max(this.pos1.func_177956_o(), this.pos2.func_177956_o());
        int z = Math.max(this.pos1.func_177952_p(), this.pos2.func_177952_p());
        return new BlockPos(x, y, z);
    }

    public BlockPos getRelativeEndPoint() {
        return this.getEndPoint().func_177973_b((Vec3i)this.getStartingPoint());
    }

    public BlockPos getStartPointPlusSize() {
        return this.getStartingPoint().func_177982_a(1 + this.getSize(EnumFacing.Axis.X), 1 + this.getSize(EnumFacing.Axis.Y), 1 + this.getSize(EnumFacing.Axis.Z));
    }

    public int getSize(EnumFacing.Axis axis) {
        BlockPos minPos = this.getStartingPoint();
        BlockPos maxPos = this.getEndPoint();
        switch (axis) {
            case X: {
                return maxPos.func_177958_n() - minPos.func_177958_n();
            }
            case Y: {
                return maxPos.func_177956_o() - minPos.func_177956_o();
            }
            case Z: {
                return maxPos.func_177952_p() - minPos.func_177952_p();
            }
        }
        ModLogger.error("Unhandled axis!?", new Object[0]);
        return -1;
    }

    public String getSizeString() {
        return this.getSize(EnumFacing.Axis.X) + " x " + this.getSize(EnumFacing.Axis.Y) + " x " + this.getSize(EnumFacing.Axis.Z);
    }

    public boolean isEqual(LocationArea area) {
        return area != null && area.pos1.equals((Object)this.pos1) && area.pos2.equals((Object)this.pos2);
    }
}

