/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config(modid="bard_mania")
@Config.LangKey(value="config.bard_mania.title")
public class ModConfig {
    @Config.LangKey(value="config.bard_mania.client_options.title")
    @Config.Comment(value={"Client Options"})
    public static final Client client = new Client();

    @SideOnly(value=Side.CLIENT)
    public static void toggleInputMode() {
        ModConfig.client.input_mode = ModConfig.client.input_mode.toggle();
        ConfigManager.sync((String)"bard_mania", (Config.Type)Config.Type.INSTANCE);
    }

    public static boolean getAutoConfigureChannels() {
        return ModConfig.client.autoConfigureChannels;
    }

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bard_mania")) {
                ConfigManager.sync((String)"bard_mania", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Client {
        @Config.Name(value="Automatically configure sound channels")
        @Config.LangKey(value="config.bard_mania:autoConfigureChannels")
        public boolean autoConfigureChannels = true;
        @Config.LangKey(value="config.bard_mania.input_mode")
        @Config.Comment(value={"Input Mode: Use MIDI or PC Keyboard. Defaults to PC Keyboard."})
        public INPUT_MODE input_mode = INPUT_MODE.KEYBOARD;
        @Config.LangKey(value="config.bard_mania.player_name_in_window_title")
        @Config.Comment(value={"Player name in window title. Updates on logon and/or changing dimension."})
        public PLAYER_NAME_IN_WINDOW_TITLE player_name_in_window_title = PLAYER_NAME_IN_WINDOW_TITLE.DISABLED;
        @Config.LangKey(value="config.bard_mania.sound_gui_button")
        @Config.Comment(value={"Gui Button Sound"})
        public SOUND_GUI_BUTTON sound_gui_button = SOUND_GUI_BUTTON.ENABLED;
        @Config.LangKey(value="config.bard_mania.midi_options.title")
        @Config.Comment(value={"MIDI Options"})
        public final MIDIOptions midi_options = new MIDIOptions(true, 1);

        public static enum SOUND_GUI_BUTTON {
            DISABLED("config.bard_mania.sound_gui_button.disabled"),
            ENABLED("config.bard_mania.sound_gui_button.enabled");

            private String translateKey;

            private SOUND_GUI_BUTTON(String translateKeyIn) {
                this.translateKey = translateKeyIn;
            }

            public String toString() {
                return this.translateKey;
            }
        }

        public static enum PLAYER_NAME_IN_WINDOW_TITLE {
            DISABLED("config.bard_mania.player_name_in_title.disabled"),
            ENABLED("config.bard_mania.player_name_in_title.enabled");

            private String translateKey;

            private PLAYER_NAME_IN_WINDOW_TITLE(String translateKeyIn) {
                this.translateKey = translateKeyIn;
            }

            public String toString() {
                return this.translateKey;
            }
        }

        public static class MIDIOptions {
            @Config.LangKey(value="config.bard_mania.midi_options.all_channels")
            @Config.Comment(value={"Listen on all channels or specified channel"})
            public boolean allChannels;
            @Config.LangKey(value="config.bard_mania.midi_options.channel")
            @Config.RangeInt(min=1, max=16)
            @Config.Comment(value={"MIDI Channel [1-16]"})
            public int channel;

            MIDIOptions(boolean allChannels, int channel) {
                this.allChannels = allChannels;
                this.channel = channel;
            }
        }

        public static enum INPUT_MODE {
            MIDI("config.bard_mania.input_mode.midi"),
            KEYBOARD("config.bard_mania.input_mode.keyboard");

            private String translateKey;

            private INPUT_MODE(String translateKeyIn) {
                this.translateKey = translateKeyIn;
            }

            @SideOnly(value=Side.CLIENT)
            public INPUT_MODE toggle() {
                return this == KEYBOARD ? MIDI : KEYBOARD;
            }

            public String toString() {
                return this.translateKey;
            }
        }
    }
}

