/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server;

import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.aeronica.mods.bard_mania.server.caps.DimChangeMessage;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="bard_mania")
public class ServerEvents {
    @SubscribeEvent
    public static void onEvent(PlayerContainerEvent event) {
        if (event.getEntity() instanceof EntityPlayer && BardActionHelper.isInstrumentEquipped(event.getEntityPlayer())) {
            BardActionHelper.setInstrumentRemovedByForce(event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerSleepInBedEvent event) {
        if (event.getEntity() instanceof EntityPlayer && BardActionHelper.isInstrumentEquipped(event.getEntityPlayer())) {
            BardActionHelper.setInstrumentRemovedByForce(event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerLoggedInEvent event) {
        event.player.func_130014_f_().field_73010_i.stream().filter(BardActionHelper::isInstrumentEquipped).forEach(player -> BardActionHelper.updateOnJoin(player, (EntityLivingBase)event.player, false));
        BardActionHelper.setInstrumentRemovedByForce(event.player);
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        event.player.func_130014_f_().field_73010_i.stream().filter(BardActionHelper::isInstrumentEquipped).forEach(player -> BardActionHelper.updateOnJoin(player, (EntityLivingBase)event.player, false));
        BardActionHelper.setInstrumentRemovedByForce(event.player);
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        BardMania.proxy.getWorldByDimensionId((int)event.toDim).field_73010_i.stream().filter(BardActionHelper::isInstrumentEquipped).forEach(player -> BardActionHelper.updateOnJoin(player, (EntityLivingBase)event.player, true));
        BardActionHelper.setInstrumentRemovedByForce(event.player);
    }

    @SubscribeEvent
    public static void onEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (DimChangeMessage dimChangeMessage : BardActionHelper.getDimChangeMessages()) {
                dimChangeMessage.update();
                if (!dimChangeMessage.canSend()) continue;
                PacketDispatcher.sendToDimension(dimChangeMessage.getMessage(), dimChangeMessage.getDimension());
                BardActionHelper.getDimChangeMessages().remove(dimChangeMessage);
            }
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerRespawnEvent event) {
        event.player.func_130014_f_().field_73010_i.stream().filter(player -> BardActionHelper.isInstrumentEquipped(player) && player.func_145782_y() != event.player.func_145782_y()).forEach(player -> BardActionHelper.updateOnJoin(player, (EntityLivingBase)event.player, false));
        BardActionHelper.setInstrumentRemovedByForce(event.player);
    }

    @SubscribeEvent
    public static void onEvent(ItemTossEvent event) {
        ItemStack itemStack = event.getEntityItem().func_92059_d();
        if (itemStack.func_77973_b() instanceof ItemInstrument) {
            BardActionHelper.setInstrumentRemovedByForce(event.getPlayer());
            if (event.isCancelable()) {
                event.setCanceled(false);
            }
        }
    }
}

