/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.caps;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.bard_mania.server.Util;
import net.aeronica.mods.bard_mania.server.caps.BardActionImpl;
import net.aeronica.mods.bard_mania.server.caps.IBardAction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BardActionCapability {
    @CapabilityInject(value=IBardAction.class)
    private static final Capability<IBardAction> BARD_ACTION_CAP = (Capability)Util.nonNullInjected();

    public static void register() {
        CapabilityManager.INSTANCE.register(IBardAction.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    @SubscribeEvent
    public static void onEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("bard_mania", "IBardAction"), (ICapabilityProvider)new ICapabilitySerializable<NBTPrimitive>(){
                IBardAction instance = (IBardAction)BardActionCapability.access$200().getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == BARD_ACTION_CAP;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == BARD_ACTION_CAP ? BARD_ACTION_CAP.cast((Object)this.instance) : null);
                }

                public NBTPrimitive serializeNBT() {
                    return (NBTPrimitive)BARD_ACTION_CAP.getStorage().writeNBT(BARD_ACTION_CAP, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTPrimitive nbt) {
                    BARD_ACTION_CAP.getStorage().readNBT(BARD_ACTION_CAP, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.Clone event) {
        IBardAction dead = (IBardAction)event.getOriginal().getCapability(BARD_ACTION_CAP, null);
        IBardAction live = (IBardAction)event.getEntity().getCapability(BARD_ACTION_CAP, null);
        if (!event.isWasDeath()) {
            live.setModelDummy(dead.getModelDummy());
            if (dead.isInstrumentEquipped()) {
                live.setInstrumentEquipped();
            } else {
                live.setInstrumentRemoved();
            }
            if (dead.getTemp()) {
                live.setTempOn();
            } else {
                live.setTempOff();
            }
        }
    }

    private static class Storage
    implements Capability.IStorage<IBardAction> {
        private Storage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IBardAction> capability, IBardAction instance, EnumFacing side) {
            return new NBTTagByte((byte)(instance.getTemp() ? 1 : 0));
        }

        public void readNBT(Capability<IBardAction> capability, IBardAction instance, EnumFacing side, NBTBase nbt) {
            if (((NBTPrimitive)nbt).func_150290_f() == 1) {
                instance.setTempOn();
            } else {
                instance.setTempOff();
            }
        }
    }

    private static class Factory
    implements Callable<IBardAction> {
        private Factory() {
        }

        @Override
        public IBardAction call() throws Exception {
            return new BardActionImpl();
        }
    }
}

