/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.init;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.aeronica.mods.bard_mania.server.init.ModItems;
import net.aeronica.mods.bard_mania.server.item.ItemAccessory;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.item.Item;

public class ModInstruments {
    static final List<ItemInstrument> INSTRUMENTS = new ArrayList<ItemInstrument>();
    public static final Item DRUM_STICK;
    public static final Item MALLET;

    public static void register() {
        for (Item item : INSTRUMENTS) {
            ModInstruments.register(item);
        }
        ModInstruments.register(DRUM_STICK);
        ModInstruments.register(MALLET);
    }

    private static void register(Item item) {
        ModItems.RegistrationHandler.add(item);
    }

    private static <T> boolean validateFields(@Nonnull T t) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            if (field.getDeclaredAnnotation(Instrument.Optional.class) != null) continue;
            if (field.get(t) == null) {
                return false;
            }
            if (field.getType().isPrimitive() || field.getType() == String.class || field.getType().isEnum()) continue;
            return ModInstruments.validateFields(field.get(t));
        }
        return true;
    }

    static {
        InputStreamReader reader = new InputStreamReader(ModInstruments.class.getResourceAsStream("/assets/bard_mania/instruments.json"));
        JsonParser parser = new JsonParser();
        JsonArray elements = parser.parse((Reader)reader).getAsJsonArray();
        try {
            Gson gson = new Gson();
            for (JsonElement element : elements) {
                Instrument instrument = (Instrument)gson.fromJson(element, new TypeToken<Instrument>(){}.getType());
                if (!ModInstruments.validateFields(instrument)) {
                    if (instrument.id != null) {
                        throw new NullPointerException("The instrument '" + instrument.id + "' is missing required attributes");
                    }
                    throw new NullPointerException("Invalid instrument entry");
                }
                INSTRUMENTS.add(new ItemInstrument(instrument));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        DRUM_STICK = new ItemAccessory("drum_stick");
        MALLET = new ItemAccessory("mallet");
    }
}

