/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.network.server;

import java.io.IOException;
import net.aeronica.mods.bard_mania.server.IActiveNoteReceiver;
import net.aeronica.mods.bard_mania.server.network.AbstractMessage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class ActiveReceiverMessage
extends AbstractMessage.AbstractServerMessage<ActiveReceiverMessage> {
    private BlockPos blockPos;
    private int entityId;
    private byte note;
    private byte volume;
    private long timeStamp;

    public ActiveReceiverMessage() {
    }

    public ActiveReceiverMessage(BlockPos pos, int entityId, byte note, byte volume, long timeStamp) {
        this.blockPos = pos;
        this.entityId = entityId;
        this.note = note;
        this.volume = volume;
        this.timeStamp = timeStamp;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.blockPos = buffer.func_179259_c();
        this.entityId = buffer.readInt();
        this.note = buffer.readByte();
        this.volume = buffer.readByte();
        this.timeStamp = buffer.readLong();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.note);
        buffer.writeByte((int)this.volume);
        buffer.writeLong(this.timeStamp);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        World world = player.func_130014_f_();
        if (world.func_175667_e(this.blockPos)) {
            EntityPlayer personPlaying = (EntityPlayer)world.func_73045_a(this.entityId);
            IBlockState state = world.func_180495_p(this.blockPos);
            if (state.func_177230_c() instanceof IActiveNoteReceiver) {
                IActiveNoteReceiver instrument = (IActiveNoteReceiver)state.func_177230_c();
                instrument.noteReceiver(world, this.blockPos, this.entityId, this.note, this.volume, this.timeStamp);
            } else if (this.entityId == player.func_145782_y() && personPlaying != null && !personPlaying.func_184614_ca().func_190926_b() && personPlaying.func_184614_ca().func_77973_b() instanceof IActiveNoteReceiver) {
                IActiveNoteReceiver instrument = (IActiveNoteReceiver)personPlaying.func_184614_ca().func_77973_b();
                instrument.noteReceiver(world, this.blockPos, this.entityId, this.note, this.volume, this.timeStamp);
            }
        }
    }
}

