/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.events;

import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.events.OTGSender;
import com.pg85.otg.bukkit.events.SaplingListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class OTGListener
implements Listener {
    private final OTGPlugin otgPlugin;
    private final OTGSender otgSender;
    private final SaplingListener saplingListener;

    public OTGListener(OTGPlugin plugin) {
        this.otgPlugin = plugin;
        this.otgSender = new OTGSender(plugin);
        this.saplingListener = new SaplingListener();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldInit(WorldInitEvent event) {
        this.otgPlugin.onWorldInit(event.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.otgPlugin.onWorldUnload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onStructureGrow(StructureGrowEvent event) {
        this.saplingListener.onStructureGrow(event);
    }

    @EventHandler
    public void onPlayerRegisterChannel(PlayerRegisterChannelEvent event) {
        if (event.getChannel().equals("OpenTerrainGenerator")) {
            this.otgSender.send(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.getListeningPluginChannels().contains("OpenTerrainGenerator")) {
            this.otgSender.send(player);
        }
    }
}

