/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator.structures;

import com.pg85.otg.bukkit.BukkitBiome;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.network.ConfigProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EntityGuardian;
import net.minecraft.server.v1_12_R1.StructureGenerator;
import net.minecraft.server.v1_12_R1.StructureStart;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldGenMonument;

public class OTGOceanMonumentGen
extends StructureGenerator {
    private final List<BiomeBase> monumentSpawnBiomes;
    private final List<BiomeBase.BiomeMeta> mobList = Arrays.asList(new BiomeBase.BiomeMeta(EntityGuardian.class, 1, 2, 4));
    private int randomOffset;
    private int gridSize;

    public OTGOceanMonumentGen(ConfigProvider settings) {
        this.gridSize = settings.getWorldConfig().oceanMonumentGridSize;
        this.randomOffset = settings.getWorldConfig().oceanMonumentRandomOffset;
        this.monumentSpawnBiomes = new ArrayList<BiomeBase>();
        for (LocalBiome biome : settings.getBiomeArrayByOTGId()) {
            if (biome == null || !biome.getBiomeConfig().oceanMonumentsEnabled) continue;
            this.monumentSpawnBiomes.add(((BukkitBiome)biome).getHandle());
        }
    }

    public BlockPosition getNearestGeneratedFeature(World var1, BlockPosition var2, boolean var3) {
        this.g = var1;
        return OTGOceanMonumentGen.a((World)var1, (StructureGenerator)this, (BlockPosition)var2, (int)this.gridSize, (int)(this.gridSize - this.randomOffset - 1), (int)10387313, (boolean)true, (int)100, (boolean)var3);
    }

    public List<BiomeBase.BiomeMeta> getMobs() {
        return this.mobList;
    }

    public String a() {
        return "Monument";
    }

    protected boolean a(int chunkX, int chunkZ) {
        boolean flag;
        int originalChunkX = chunkX;
        int originalChunkZ = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.gridSize - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.gridSize - 1;
        }
        int structureChunkX = chunkX / this.gridSize;
        int structureChunkZ = chunkZ / this.gridSize;
        Random random = this.g.a(structureChunkX, structureChunkZ, 10387313);
        structureChunkX *= this.gridSize;
        structureChunkZ *= this.gridSize;
        return originalChunkX == (structureChunkX += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2) && originalChunkZ == (structureChunkZ += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2) && (flag = this.g.getWorldChunkManager().a(originalChunkX * 16 + 8, originalChunkZ * 16 + 8, 29, this.monumentSpawnBiomes));
    }

    protected StructureStart b(int i, int j) {
        return new WorldGenMonument.WorldGenMonumentStart(this.g, this.f, i, j);
    }
}

