/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome.settings;

import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class ReplaceBlocks {
    private final String sourceBlock;
    private final String targetBlock;

    private ReplaceBlocks(String sourceBlock, String targetBlock) {
        this.sourceBlock = sourceBlock;
        this.targetBlock = targetBlock;
    }

    public String getSourceBlock() {
        return this.sourceBlock;
    }

    public String getTargetBlock() {
        return this.targetBlock;
    }

    public static List<ReplaceBlocks> fromJson(String originalJson) throws InvalidConfigException {
        String[] groups;
        if (originalJson == null || originalJson.length() == 0) {
            return null;
        }
        ArrayList<ReplaceBlocks> mobGroups = new ArrayList<ReplaceBlocks>();
        String json = originalJson.trim();
        if (json.length() <= 2) {
            return mobGroups;
        }
        json = ReplaceBlocks.removeFirstAndLastChar(json);
        json = json.replace('{', '(');
        json = json.replace('}', ')');
        for (String group : groups = StringHelper.readCommaSeperatedString(json)) {
            mobGroups.add(ReplaceBlocks.readSingleGroup(group));
        }
        return mobGroups;
    }

    private static ReplaceBlocks readSingleGroup(String json) throws InvalidConfigException {
        String group = ReplaceBlocks.removeFirstAndLastChar(json.trim());
        String[] groupParts = StringHelper.readCommaSeperatedString(group);
        String sourceBlock = null;
        String targetBlock = null;
        for (String option : groupParts) {
            String[] optionParts = (option = option.replace(" ", "")).split("\"");
            if (optionParts.length != 4) {
                throw new InvalidConfigException("Invalid JSON structure near " + option);
            }
            sourceBlock = optionParts[1];
            targetBlock = optionParts[3];
        }
        if (sourceBlock == null || targetBlock == null) {
            throw new InvalidConfigException("Invalid JSON: " + json + ". Expected [{\"sourceblock1\":\"targetblock1\"},{\"sourceblock2\":\"targetblock2\"}] etc.");
        }
        return new ReplaceBlocks(sourceBlock, targetBlock);
    }

    public static String toJson(List<ReplaceBlocks> list) {
        StringBuilder json = new StringBuilder("[");
        if (list != null) {
            for (ReplaceBlocks group : list) {
                group.toJson(json);
                json.append(", ");
            }
        } else {
            return "";
        }
        if (json.length() != 1) {
            json.deleteCharAt(json.length() - 1);
            json.deleteCharAt(json.length() - 1);
        }
        json.append(']');
        return json.toString();
    }

    private void toJson(StringBuilder json) {
        json.append("{\"");
        json.append(this.sourceBlock);
        json.append("\":\"");
        json.append(this.targetBlock);
        json.append("\"}");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toJson(builder);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.sourceBlock.hashCode();
        result = prime * result + this.targetBlock.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceBlocks)) {
            return false;
        }
        ReplaceBlocks other = (ReplaceBlocks)obj;
        if (this.sourceBlock != other.sourceBlock || this.targetBlock != other.targetBlock) {
            return false;
        }
        return this.sourceBlock.equals(other.sourceBlock) && this.targetBlock.equals(other.targetBlock);
    }

    private static String removeFirstAndLastChar(String string) {
        return string.substring(1, string.length() - 1);
    }
}

