/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ModDataFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ParticleFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3SpawnerFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ModDataFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ParticleFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4SpawnerFunction;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLine;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLineDiagonal;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class CustomStructureFileManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<ChunkCoordinate, CustomStructure> loadStructuresFile(LocalWorld world) {
        HashMap<ChunkCoordinate, CustomStructure> structuresFile = new HashMap<ChunkCoordinate, CustomStructure>();
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.StructureDataFileName);
        StringBuilder stringbuilder = new StringBuilder();
        if (occupiedChunksFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));){
                String line = reader.readLine();
                while (line != null) {
                    stringbuilder.append(line);
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            return structuresFile;
        }
        String[] structuresString = stringbuilder.toString().substring(1, stringbuilder.length() - 1).split(" ");
        for (int i = 0; i < structuresString.length; ++i) {
            CustomStructure structure;
            String[] structureStringArray = structuresString[i].substring(1, structuresString[i].length() - 1).split("\\]\\[");
            String structureString = structureStringArray[1];
            int minY = 0;
            CustomStructureCoordinate structureStart = null;
            HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
            HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
            HashSet<BO4ModDataFunction> modData = new HashSet<BO4ModDataFunction>();
            HashSet<BO4SpawnerFunction> spawnerData = new HashSet<BO4SpawnerFunction>();
            HashSet<BO4ParticleFunction> particleData = new HashSet<BO4ParticleFunction>();
            String[] chunkCoordString = structureStringArray[0].split(",");
            int chunkX = Integer.parseInt(chunkCoordString[0]);
            int chunkZ = Integer.parseInt(chunkCoordString[1]);
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
            if (!structureString.equals("Null structure")) {
                ChunkCoordinate chunk;
                String[] objectAsString;
                structureStart = world.getConfigs().getWorldConfig().isOTGPlus ? new BO4CustomStructureCoordinate(world, null, null, null, 0, 0, 0, 0, false, false, null) : new BO3CustomStructureCoordinate(world, null, null, null, 0, 0, 0);
                stringbuilder = null;
                String[] structureStartString = structureStringArray[1].split(",");
                String[] objectsToSpawnString = new String[]{};
                if (structureStringArray.length > 2 && !structureStringArray[2].equals("")) {
                    objectsToSpawnString = structureStringArray[2].split(";");
                }
                String[] smoothingAreasToSpawnString = new String[]{};
                if (structureStringArray.length > 3 && !structureStringArray[3].equals("")) {
                    smoothingAreasToSpawnString = structureStringArray[3].split(";");
                }
                String[] modDataString = new String[]{};
                if (structureStringArray.length > 4 && !structureStringArray[4].equals("")) {
                    modDataString = structureStringArray[4].split(":");
                }
                String[] spawnerDataString = new String[]{};
                if (structureStringArray.length > 5 && !structureStringArray[5].equals("")) {
                    spawnerDataString = structureStringArray[5].split(":");
                }
                String[] particleDataString = new String[]{};
                if (structureStringArray.length > 6 && !structureStringArray[6].equals("")) {
                    particleDataString = structureStringArray[6].split(":");
                }
                structureStart.bo3Name = structureStartString[0];
                structureStart.rotation = Rotation.FromString(structureStartString[1]);
                structureStart.x = Integer.parseInt(structureStartString[2]);
                structureStart.y = Short.parseShort(structureStartString[3]);
                structureStart.z = Integer.parseInt(structureStartString[4]);
                for (String objectToSpawn : objectsToSpawnString) {
                    objectAsString = objectToSpawn.split(",");
                    chunk = ChunkCoordinate.fromChunkCoords(Integer.parseInt(objectAsString[0]), Integer.parseInt(objectAsString[1]));
                    Stack<BO4CustomStructureCoordinate> coords = new Stack<BO4CustomStructureCoordinate>();
                    for (int j = 2; j < objectAsString.length; j += 5) {
                        BO4CustomStructureCoordinate coord = new BO4CustomStructureCoordinate(world, null, null, null, 0, 0, 0, 0, false, false, null);
                        coord.bo3Name = objectAsString[j];
                        coord.rotation = Rotation.FromString(objectAsString[j + 1]);
                        coord.x = Integer.parseInt(objectAsString[j + 2]);
                        coord.y = Short.parseShort(objectAsString[j + 3]);
                        coord.z = Integer.parseInt(objectAsString[j + 4]);
                        coords.add(coord);
                    }
                    objectsToSpawn.put(chunk, coords);
                }
                for (String smoothingAreaToSpawn : smoothingAreasToSpawnString) {
                    objectAsString = smoothingAreaToSpawn.split(":");
                    chunk = ChunkCoordinate.fromChunkCoords(Integer.parseInt(objectAsString[0].split(",")[0]), Integer.parseInt(objectAsString[0].split(",")[1]));
                    ArrayList<SmoothingAreaLineDiagonal> coords2 = new ArrayList<SmoothingAreaLineDiagonal>();
                    for (String objectArray : objectAsString) {
                        if (objectArray == objectAsString[0]) continue;
                        String[] params = objectArray.split(",");
                        SmoothingAreaLine object = params.length > 12 ? new SmoothingAreaLineDiagonal() : new SmoothingAreaLine();
                        object.beginPointX = Integer.parseInt(params[0]);
                        object.beginPointY = Short.parseShort(params[1]);
                        object.beginPointZ = Integer.parseInt(params[2]);
                        object.endPointX = Integer.parseInt(params[3]);
                        object.endPointY = Short.parseShort(params[4]);
                        object.endPointZ = Integer.parseInt(params[5]);
                        object.originPointX = Integer.parseInt(params[6]);
                        object.originPointY = Short.parseShort(params[7]);
                        object.originPointZ = Integer.parseInt(params[8]);
                        object.finalDestinationPointX = Integer.parseInt(params[9]);
                        object.finalDestinationPointY = Short.parseShort(params[10]);
                        object.finalDestinationPointZ = Integer.parseInt(params[11]);
                        if (params.length > 12) {
                            object.diagonalLineOriginPointX = Integer.parseInt(params[12]);
                            object.diagonalLineoriginPointY = Short.parseShort(params[13]);
                            object.diagonalLineOriginPointZ = Integer.parseInt(params[14]);
                            object.diagonalLineFinalDestinationPointX = Integer.parseInt(params[15]);
                            object.diagonalLineFinalDestinationPointY = Short.parseShort(params[16]);
                            object.diagonalLineFinalDestinationPointZ = Integer.parseInt(params[17]);
                        }
                        coords2.add((SmoothingAreaLineDiagonal)object);
                    }
                    smoothingAreasToSpawn.put(chunk, coords2);
                }
                for (String modData1 : modDataString) {
                    objectAsString = modData1.split(",");
                    for (int j = 0; j < objectAsString.length; j += 5) {
                        ModDataFunction modDataFunction = world.getConfigs().getWorldConfig().isOTGPlus ? new BO4ModDataFunction() : new BO3ModDataFunction();
                        modDataFunction.x = Integer.parseInt(objectAsString[j]);
                        modDataFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        modDataFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        modDataFunction.modId = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        modDataFunction.modData = objectAsString[j + 4].replace("&#58;", ":").replace("&nbsp;", " ");
                        modData.add((BO4ModDataFunction)modDataFunction);
                    }
                }
                for (String spawnerData1 : spawnerDataString) {
                    objectAsString = spawnerData1.split(",");
                    for (int j = 0; j < objectAsString.length; j += 19) {
                        SpawnerFunction spawnerFunction = world.getConfigs().getWorldConfig().isOTGPlus ? new BO4SpawnerFunction() : new BO3SpawnerFunction();
                        spawnerFunction.x = Integer.parseInt(objectAsString[j]);
                        spawnerFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        spawnerFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        spawnerFunction.mobName = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.originalnbtFileName = objectAsString[j + 4].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.nbtFileName = objectAsString[j + 5].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.groupSize = Integer.parseInt(objectAsString[j + 6]);
                        spawnerFunction.interval = Integer.parseInt(objectAsString[j + 7]);
                        spawnerFunction.spawnChance = Integer.parseInt(objectAsString[j + 8]);
                        spawnerFunction.maxCount = Integer.parseInt(objectAsString[j + 9]);
                        spawnerFunction.despawnTime = Integer.parseInt(objectAsString[j + 10]);
                        spawnerFunction.velocityX = Double.parseDouble(objectAsString[j + 11]);
                        spawnerFunction.velocityY = Double.parseDouble(objectAsString[j + 12]);
                        spawnerFunction.velocityZ = Double.parseDouble(objectAsString[j + 13]);
                        spawnerFunction.velocityXSet = Boolean.parseBoolean(objectAsString[j + 14]);
                        spawnerFunction.velocityYSet = Boolean.parseBoolean(objectAsString[j + 15]);
                        spawnerFunction.velocityZSet = Boolean.parseBoolean(objectAsString[j + 16]);
                        spawnerFunction.yaw = Float.parseFloat(objectAsString[j + 17]);
                        spawnerFunction.pitch = Float.parseFloat(objectAsString[j + 18]);
                        spawnerData.add((BO4SpawnerFunction)spawnerFunction);
                    }
                }
                for (String particleData1 : particleDataString) {
                    objectAsString = particleData1.split(",");
                    for (int j = 0; j < objectAsString.length; j += 11) {
                        ParticleFunction particleFunction = world.getConfigs().getWorldConfig().isOTGPlus ? new BO4ParticleFunction() : new BO3ParticleFunction();
                        particleFunction.x = Integer.parseInt(objectAsString[j]);
                        particleFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        particleFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        particleFunction.particleName = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        particleFunction.interval = Double.parseDouble(objectAsString[j + 4]);
                        particleFunction.velocityX = Double.parseDouble(objectAsString[j + 5]);
                        particleFunction.velocityY = Double.parseDouble(objectAsString[j + 6]);
                        particleFunction.velocityZ = Double.parseDouble(objectAsString[j + 7]);
                        particleFunction.velocityXSet = Boolean.parseBoolean(objectAsString[j + 8]);
                        particleFunction.velocityYSet = Boolean.parseBoolean(objectAsString[j + 9]);
                        particleFunction.velocityZSet = Boolean.parseBoolean(objectAsString[j + 10]);
                        particleData.add((BO4ParticleFunction)particleFunction);
                    }
                }
            }
            if (world.getConfigs().getWorldConfig().isOTGPlus) {
                structure = new BO4CustomStructure(world, (BO4CustomStructureCoordinate)structureStart, objectsToSpawn, smoothingAreasToSpawn, minY);
                ((BO4CustomStructure)structure).startChunkBlockChecksDone = true;
            } else {
                structure = new BO3CustomStructure((BO3CustomStructureCoordinate)structureStart);
            }
            structure.modDataManager.modData = modData;
            structure.spawnerManager.spawnerData = spawnerData;
            structure.particlesManager.particleData = particleData;
            structuresFile.put(chunkCoord, structure);
        }
        return structuresFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveChunksFile(ArrayList<ChunkCoordinate> chunks, String fileName, LocalWorld world) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + fileName);
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        if (chunks.size() > 0) {
            StringBuilder stringbuilder = new StringBuilder();
            for (ChunkCoordinate chunkCoord : chunks) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append("," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ());
                    continue;
                }
                stringbuilder.append(chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ());
            }
            BufferedWriter writer = null;
            try {
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<ChunkCoordinate> loadChunksFile(String fileName, LocalWorld world) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + fileName);
        StringBuilder stringbuilder = new StringBuilder();
        String[] occupiedChunkCoords = new String[]{};
        if (occupiedChunksFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));){
                String line = reader.readLine();
                while (line != null) {
                    stringbuilder.append(line);
                    line = reader.readLine();
                }
                if (stringbuilder.length() > 0) {
                    occupiedChunkCoords = stringbuilder.toString().split(",");
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<ChunkCoordinate> chunks = new ArrayList<ChunkCoordinate>();
        if (occupiedChunkCoords.length > 0) {
            for (int i = 0; i < occupiedChunkCoords.length; i += 2) {
                chunks.add(ChunkCoordinate.fromChunkCoords(Integer.parseInt(occupiedChunkCoords[i]), Integer.parseInt(occupiedChunkCoords[i + 1])));
            }
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChunksMapFile(String fileName, LocalWorld world, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + fileName);
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        if (spawnedStructuresByName.size() > 0) {
            StringBuilder stringbuilder = new StringBuilder();
            for (Map.Entry<String, ArrayList<ChunkCoordinate>> entry : spawnedStructuresByName.entrySet()) {
                if (stringbuilder.length() == 0) {
                    stringbuilder.append(entry.getKey().replace(",", "\\"));
                } else {
                    stringbuilder.append("/" + entry.getKey().replace(",", "\\"));
                }
                for (ChunkCoordinate chunkCoordinate : entry.getValue()) {
                    stringbuilder.append("," + chunkCoordinate.getChunkX() + "," + chunkCoordinate.getChunkZ() + ",");
                }
            }
            stringbuilder.append("|");
            for (Map.Entry<String, Cloneable> entry : spawnedStructuresByGroup.entrySet()) {
                if (stringbuilder.length() == 0) {
                    stringbuilder.append(entry.getKey().replace(",", "\\"));
                } else {
                    stringbuilder.append("/" + entry.getKey().replace(",", "\\"));
                }
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    stringbuilder.append("," + ((ChunkCoordinate)entry2.getKey()).getChunkX() + "," + ((ChunkCoordinate)entry2.getKey()).getChunkZ() + "," + (Integer)entry2.getValue() + ",");
                }
            }
            BufferedWriter writer = null;
            try {
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void loadChunksMapFile(String fileName, LocalWorld world, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + fileName);
        HashMap chunksByName = new HashMap();
        HashMap chunksByGroup = new HashMap();
        StringBuilder stringbuilder = new StringBuilder();
        String[] occupiedChunksByName = new String[]{};
        String[] occupiedChunksByGroup = new String[]{};
        if (occupiedChunksFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));){
                void var12_15;
                String string = reader.readLine();
                while (var12_15 != null) {
                    stringbuilder.append((String)var12_15);
                    String string2 = reader.readLine();
                }
                if (stringbuilder.length() > 0) {
                    String[] allData = stringbuilder.toString().split("|");
                    occupiedChunksByName = allData[0].split("/");
                    if (allData.length > 1) {
                        occupiedChunksByGroup = allData[1].split("/");
                    }
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String[] occupiedChunkByNameCoords = new String[]{};
        for (String entry : occupiedChunksByName) {
            occupiedChunkByNameCoords = entry.split(",");
            String key = occupiedChunkByNameCoords[0].replace("\\", ",");
            ArrayList<ChunkCoordinate> value = new ArrayList<ChunkCoordinate>();
            if (occupiedChunkByNameCoords.length > 0) {
                for (int i = 1; i < occupiedChunkByNameCoords.length; i += 2) {
                    value.add(ChunkCoordinate.fromChunkCoords(Integer.parseInt(occupiedChunkByNameCoords[i]), Integer.parseInt(occupiedChunkByNameCoords[i + 1])));
                }
            }
            chunksByName.put(key, value);
        }
        spawnedStructuresByName.clear();
        spawnedStructuresByName.putAll(chunksByName);
        String[] stringArray = new String[]{};
        for (String entry : occupiedChunksByGroup) {
            String[] stringArray2 = entry.split(",");
            String key = stringArray2[0].replace("\\", ",");
            HashMap<ChunkCoordinate, Integer> value = new HashMap<ChunkCoordinate, Integer>();
            if (stringArray2.length > 0) {
                for (int i = 1; i < stringArray2.length; i += 3) {
                    value.put(ChunkCoordinate.fromChunkCoords(Integer.parseInt(stringArray2[i]), Integer.parseInt(stringArray2[i + 2])), Integer.parseInt(stringArray2[i + 1]));
                }
            }
            chunksByGroup.put(key, value);
        }
        spawnedStructuresByGroup.clear();
        spawnedStructuresByGroup.putAll(chunksByGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static void saveStructuresFile(Map<ChunkCoordinate, CustomStructure> structures, LocalWorld world) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.StructureDataFileName);
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        if (structures.size() > 0) {
            stringbuilder.append("[");
            for (Map.Entry<ChunkCoordinate, CustomStructure> entry : structures.entrySet()) {
                ChunkCoordinate key;
                boolean added;
                ChunkCoordinate chunkCoord = entry.getKey();
                CustomStructure structure = entry.getValue();
                if (stringbuilder.length() > 1) {
                    stringbuilder.append(" ");
                }
                if (structure.start != null) {
                    stringbuilder.append("[" + entry.getKey().getChunkX() + "," + entry.getKey().getChunkZ() + "][" + structure.start.bo3Name + "," + structure.start.rotation.toString() + "," + structure.start.getX() + "," + structure.start.getY() + "," + structure.start.getZ() + "]");
                } else {
                    stringbuilder.append("[" + entry.getKey().getChunkX() + "," + entry.getKey().getChunkZ() + "][Null structure]");
                }
                stringbuilder.append("[");
                if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).objectsToSpawn.entrySet().size() > 0 && chunkCoord.getChunkX() == ((BO4CustomStructureCoordinate)structure.start).getChunkX() && chunkCoord.getChunkZ() == ((BO4CustomStructureCoordinate)structure.start).getChunkZ()) {
                    added = false;
                    for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> entry2 : ((BO4CustomStructure)structure).objectsToSpawn.entrySet()) {
                        if (added) {
                            stringbuilder.append(";");
                        }
                        key = entry2.getKey();
                        stringbuilder.append(key.getChunkX() + "," + key.getChunkZ());
                        added = true;
                        Stack<BO4CustomStructureCoordinate> coords = entry2.getValue();
                        for (CustomStructureCoordinate customStructureCoordinate : coords) {
                            stringbuilder.append("," + customStructureCoordinate.bo3Name + "," + customStructureCoordinate.rotation.toString() + "," + customStructureCoordinate.getX() + "," + customStructureCoordinate.getY() + "," + customStructureCoordinate.getZ());
                        }
                    }
                }
                stringbuilder.append("][");
                if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).smoothingAreasToSpawn.entrySet().size() > 0 && chunkCoord.getChunkX() == ((BO4CustomStructureCoordinate)structure.start).getChunkX() && chunkCoord.getChunkZ() == ((BO4CustomStructureCoordinate)structure.start).getChunkZ()) {
                    added = false;
                    for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> entry3 : ((BO4CustomStructure)structure).smoothingAreasToSpawn.entrySet()) {
                        if (added) {
                            stringbuilder.append(";");
                        }
                        key = entry3.getKey();
                        stringbuilder.append(key.getChunkX() + "," + key.getChunkZ());
                        added = true;
                        ArrayList<SmoothingAreaLine> coords2 = entry3.getValue();
                        for (SmoothingAreaLine coord : coords2) {
                            void var11_35;
                            String string13 = ":";
                            string13 = string13 + coord.beginPointX;
                            string13 = string13 + "," + coord.beginPointY;
                            string13 = string13 + "," + coord.beginPointZ;
                            string13 = string13 + "," + coord.endPointX;
                            string13 = string13 + "," + coord.endPointY;
                            string13 = string13 + "," + coord.endPointZ;
                            string13 = string13 + "," + coord.originPointX;
                            string13 = string13 + "," + coord.originPointY;
                            string13 = string13 + "," + coord.originPointZ;
                            string13 = string13 + "," + coord.finalDestinationPointX;
                            string13 = string13 + "," + coord.finalDestinationPointY;
                            string13 = string13 + "," + coord.finalDestinationPointZ;
                            if (coord instanceof SmoothingAreaLineDiagonal) {
                                String string19 = string13 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineOriginPointX;
                                string19 = string19 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineoriginPointY;
                                string19 = string19 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineOriginPointZ;
                                string19 = string19 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineFinalDestinationPointX;
                                string19 = string19 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineFinalDestinationPointY;
                                string19 = string19 + "," + ((SmoothingAreaLineDiagonal)coord).diagonalLineFinalDestinationPointZ;
                            }
                            stringbuilder.append((String)var11_35);
                        }
                    }
                }
                stringbuilder.append("][");
                if (structure.modDataManager.modData.size() > 0 && chunkCoord.getChunkX() == structure.start.getChunkX() && chunkCoord.getChunkZ() == structure.start.getChunkZ()) {
                    added = false;
                    for (ModDataFunction modDataFunction : structure.modDataManager.modData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(modDataFunction.x + "," + modDataFunction.y + "," + modDataFunction.z + "," + modDataFunction.modId.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + modDataFunction.modData.replace(":", "&#58;").replace(" ", "&nbsp;"));
                        added = true;
                    }
                }
                stringbuilder.append("][");
                if (structure.spawnerManager.spawnerData.size() > 0 && chunkCoord.getChunkX() == structure.start.getChunkX() && chunkCoord.getChunkZ() == structure.start.getChunkZ()) {
                    added = false;
                    for (SpawnerFunction spawnerFunction : structure.spawnerManager.spawnerData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(spawnerFunction.x + "," + spawnerFunction.y + "," + spawnerFunction.z + "," + spawnerFunction.mobName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerFunction.originalnbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerFunction.nbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerFunction.groupSize + "," + spawnerFunction.interval + "," + spawnerFunction.spawnChance + "," + spawnerFunction.maxCount + "," + spawnerFunction.despawnTime + "," + spawnerFunction.velocityX + "," + spawnerFunction.velocityY + "," + spawnerFunction.velocityZ + "," + spawnerFunction.velocityXSet + "," + spawnerFunction.velocityYSet + "," + spawnerFunction.velocityZSet + "," + spawnerFunction.yaw + "," + spawnerFunction.pitch);
                        added = true;
                    }
                }
                stringbuilder.append("][");
                if (structure.particlesManager.particleData.size() > 0 && chunkCoord.getChunkX() == structure.start.getChunkX() && chunkCoord.getChunkZ() == structure.start.getChunkZ()) {
                    added = false;
                    for (ParticleFunction particleFunction : structure.particlesManager.particleData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(particleFunction.x + "," + particleFunction.y + "," + particleFunction.z + "," + particleFunction.particleName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + particleFunction.interval + "," + particleFunction.velocityX + "," + particleFunction.velocityY + "," + particleFunction.velocityZ + "," + particleFunction.velocityXSet + "," + particleFunction.velocityYSet + "," + particleFunction.velocityZSet);
                        added = true;
                    }
                }
                stringbuilder.append("]");
            }
            stringbuilder.append("]");
            BufferedWriter writer = null;
            try {
                if (occupiedChunksFile.exists()) {
                    occupiedChunksFile.delete();
                }
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

