/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo3;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.structures.Branch;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class BO3CustomStructure
extends CustomStructure {
    private StructurePartSpawnHeight height;
    private int maxBranchDepth;

    public BO3CustomStructure(BO3CustomStructureCoordinate start) {
        this.start = start;
    }

    public BO3CustomStructure(LocalWorld world, BO3CustomStructureCoordinate start) {
        StructuredCustomObject object = start.getObject();
        this.start = start;
        this.height = object.getStructurePartSpawnHeight();
        this.maxBranchDepth = object.getMaxBranchDepth();
        this.random = RandomHelper.getRandomForCoords(start.getX(), start.getY(), start.getZ(), world.getSeed());
        this.objectsToSpawn = new LinkedHashMap();
        this.addToSpawnList(start, object);
        this.addBranches(start, 1, world);
    }

    private void addBranches(BO3CustomStructureCoordinate coordObject, int depth, LocalWorld world) {
        StructuredCustomObject object = coordObject.getObject();
        if (object != null) {
            for (Branch branch : this.getBranches(object, coordObject.getRotation())) {
                BO3CustomStructureCoordinate childCoordObject = (BO3CustomStructureCoordinate)branch.toCustomObjectCoordinate(world, this.random, coordObject.getRotation(), coordObject.getX(), coordObject.getY(), coordObject.getZ(), null);
                if (childCoordObject == null) continue;
                this.addToSpawnList(childCoordObject, object);
                if (depth >= this.maxBranchDepth) continue;
                this.addBranches(childCoordObject, depth + 1, world);
            }
        }
    }

    private Branch[] getBranches(CustomObject customObject, Rotation rotation) {
        return ((BO3)customObject).getBranches(rotation);
    }

    private void addToSpawnList(BO3CustomStructureCoordinate coordObject, CustomObject parent) {
        ChunkCoordinate chunkCoordinate = coordObject.getPopulatingChunk();
        if (chunkCoordinate != null) {
            LinkedHashSet<BO3CustomStructureCoordinate> objectsInChunk = (LinkedHashSet<BO3CustomStructureCoordinate>)this.objectsToSpawn.get(chunkCoordinate);
            if (objectsInChunk == null) {
                objectsInChunk = new LinkedHashSet<BO3CustomStructureCoordinate>();
                this.objectsToSpawn.put(chunkCoordinate, objectsInChunk);
            }
            objectsInChunk.add(coordObject);
        } else if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "Error reading branch in BO3 " + parent.getName() + " Could not find BO3: " + coordObject.bo3Name, new Object[0]);
        }
    }

    public void spawnForChunk(ChunkCoordinate chunkCoordinate, LocalWorld world) {
        Set objectsInChunk = (Set)this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            for (CustomStructureCoordinate coordObject : objectsInChunk) {
                coordObject.spawnWithChecks(this, world, this.height, this.random);
            }
        }
    }
}

