/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.OTG;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.util.ForgeLogger;
import com.pg85.otg.forge.util.ForgeMaterialData;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.forge.world.WorldLoader;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class ForgeEngine
extends OTGEngine {
    public static LinkedHashMap<String, DimensionConfigGui> Presets = new LinkedHashMap();
    private ForgeBiomeRegistryManager biomeRegistryManager;
    private WorldLoader worldLoader;
    private long lastPregeneratorStatusUpdateTime = System.currentTimeMillis();

    public ForgeEngine() {
        super(new ForgeLogger());
        this.worldLoader = new WorldLoader(new File(Loader.instance().getConfigDir(), "OpenTerrainGenerator"));
        this.biomeRegistryManager = new ForgeBiomeRegistryManager();
    }

    public WorldLoader getWorldLoader() {
        return this.worldLoader;
    }

    public ForgeBiomeRegistryManager getBiomeRegistryManager() {
        return this.biomeRegistryManager;
    }

    public void onSave(World world) {
        ForgeWorld forgeWorld = this.worldLoader.getWorld(world);
        if (forgeWorld != null && forgeWorld.getObjectSpawner().saveRequired && !forgeWorld.getWorldSession().getPreGeneratorIsRunning()) {
            forgeWorld.getStructureCache().saveToDisk();
        }
    }

    public WorldConfig loadWorldConfigFromDisk(File worldDir) {
        File worldConfigFile = new File(worldDir, "WorldConfig.ini");
        if (!worldConfigFile.exists()) {
            return null;
        }
        SettingsMap settingsMap = FileSettingsReader.read(worldDir.getName(), worldConfigFile);
        return new WorldConfig(worldDir, settingsMap, null, null);
    }

    public void processPregeneratorTick() {
        for (LocalWorld world : this.getAllWorlds()) {
            ((ForgeWorldSession)world.getWorldSession()).getPregenerator().processTick();
        }
        if (System.currentTimeMillis() - this.lastPregeneratorStatusUpdateTime > 1000L) {
            this.lastPregeneratorStatusUpdateTime = System.currentTimeMillis();
            ServerPacketManager.sendPregeneratorStatusPacketToAllPlayers(FMLCommonHandler.instance().getMinecraftServerInstance());
        }
    }

    @Override
    public File getOTGRootFolder() {
        return this.worldLoader.getConfigsFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getOTGRootFolder(), "GlobalObjects");
    }

    @Override
    public File getWorldsDirectory() {
        return new File(this.getOTGRootFolder(), "worlds");
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.worldLoader.getWorld(name);
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return this.worldLoader.getUnloadedWorld(name);
    }

    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        return this.worldLoader.getUnloadedWorlds();
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        return this.worldLoader.getAllWorlds();
    }

    public ForgeWorld getOverWorld() {
        return this.worldLoader.getOverWorld();
    }

    public ForgeWorld getWorld(World world) {
        return this.worldLoader.getWorld(world);
    }

    public ForgeWorld getWorldByDimId(int dimensionId) {
        return this.worldLoader.getWorldByDimId(dimensionId);
    }

    public ForgeWorld getUnloadedWorldByDimId(int dimensionId) {
        return this.worldLoader.getUnloadedWorldByDimId(dimensionId);
    }

    @Override
    public String getPresetName(String worldName) {
        if (worldName.equals("overworld") || worldName.equals(OTG.getDimensionsConfig().WorldName)) {
            return OTG.getDimensionsConfig().Overworld.PresetName;
        }
        return worldName;
    }

    public static void loadPresets() {
        Presets.clear();
        ArrayList<String> worldNames = new ArrayList<String>();
        File OTGWorldsDirectory = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds");
        if (OTGWorldsDirectory.exists() && OTGWorldsDirectory.isDirectory()) {
            block0: for (File worldDir : OTGWorldsDirectory.listFiles()) {
                if (!worldDir.isDirectory() || worldDir.getName().toLowerCase().trim().startsWith("dim-")) continue;
                for (File file : worldDir.listFiles()) {
                    if (!file.getName().equals("WorldConfig.ini")) continue;
                    worldNames.add(worldDir.getName());
                    WorldConfig worldConfig = ((ForgeEngine)OTG.getEngine()).loadWorldConfigFromDisk(worldDir);
                    Presets.put(worldDir.getName(), new DimensionConfigGui(worldDir.getName(), worldConfig));
                    continue block0;
                }
            }
        }
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        return ForgeMaterialData.ofString(input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }

    @Override
    public boolean fireReplaceBiomeBlocksEvent(int x, int z, ChunkBuffer chunkBuffer, LocalWorld localWorld) {
        return ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)((ForgeWorld)localWorld).getChunkGenerator(), (int)x, (int)z, (ChunkPrimer)((ForgeChunkBuffer)chunkBuffer).getChunkPrimer(), (World)((ForgeWorld)localWorld).getWorld());
    }
}

