/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.forge.world.OTGWorldType;
import com.pg85.otg.logging.LogMarker;
import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldEvent.Load event) {
        ForgeWorld overworld;
        World world = event.getWorld();
        int dimension = world.field_73011_w.getDimension();
        if (dimension == 0 && (overworld = ((ForgeEngine)OTG.getEngine()).getOverWorld()) != null) {
            WorldListener.overrideWorldProvider(world);
        }
    }

    private static void overrideWorldProvider(World world) {
        String newClassName = OTGWorldProvider.class.getName();
        Class<OTGWorldProvider> newProviderClass = OTGWorldProvider.class;
        if (newProviderClass != null && newProviderClass != world.field_73011_w.getClass()) {
            int dim = world.field_73011_w.getDimension();
            try {
                Constructor constructor = newProviderClass.getConstructor(new Class[0]);
                WorldProvider newProvider = (WorldProvider)constructor.newInstance(new Object[0]);
                try {
                    WorldProvider oldProvider = world.field_73011_w;
                    world.field_73011_w = newProvider;
                    ((OTGWorldProvider)world.field_73011_w).isSPServerOverworld = !world.field_72995_K;
                    world.field_73011_w.func_76558_a(world);
                    world.field_73011_w.setDimension(dim);
                    if (!world.field_72995_K) {
                        ((OTGWorldProvider)world.field_73011_w).init(oldProvider.func_177499_m());
                        world.field_175728_M = ((OTGWorldProvider)world.field_73011_w).func_177501_r();
                    }
                }
                catch (Exception e) {
                    OTG.log(LogMarker.ERROR, "WorldUtils.overrideWorldProvider: Failed to override the WorldProvider of dimension {}", dim);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OTG.log(LogMarker.WARN, "WorldUtils.overrideWorldProvider: Failed to create a WorldProvider from name '{}', or it was already that type", newClassName);
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onWorldLoadServer(WorldEvent.Load event) {
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (forgeWorld != null) {
            ServerPacketManager.sendDimensionLoadUnloadPacketToAllPlayers(true, forgeWorld.getName(), event.getWorld().func_73046_m());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldLoadClient(WorldEvent.Load event) {
        for (LocalWorld localWorld : ((ForgeEngine)OTG.getEngine()).getAllWorlds()) {
            ForgeWorld forgeWorld = (ForgeWorld)localWorld;
            if (forgeWorld.getWorld() != null || forgeWorld.clientDimensionId != event.getWorld().field_73011_w.getDimension()) continue;
            forgeWorld.provideClientWorld(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null) {
            ((ForgeWorldSession)world.getWorldSession()).getPregenerator().savePregeneratorData();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            boolean serverStopping;
            World mcWorld = event.getWorld();
            MinecraftServer mcServer = mcWorld.func_73046_m();
            if (mcServer == null) {
                mcServer = this.getClientServer();
            }
            boolean bl = serverStopping = !mcServer.func_71278_l();
            if (event.getWorld().func_175624_G() instanceof OTGWorldType) {
                int dimId = event.getWorld().field_73011_w.getDimension();
                ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
                if (forgeWorld == null) {
                    return;
                }
                if (dimId != -1 && dimId != 1) {
                    if (((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld()) != null) {
                        ((ForgeEngine)OTG.getEngine()).getWorldLoader().unloadWorld(event.getWorld(), false);
                    }
                    if (serverStopping) {
                        OTGDimensionManager.UnloadCustomDimensionData(mcWorld.field_73011_w.getDimension());
                        forgeWorld.unRegisterBiomes();
                        ((ForgeWorldSession)forgeWorld.getWorldSession()).getPregenerator().shutDown();
                    }
                }
            }
            if (serverStopping) {
                for (ForgeWorld unloadedWorld : ((ForgeEngine)OTG.getEngine()).getUnloadedWorlds()) {
                    if (unloadedWorld.getWorld() == mcWorld) continue;
                    OTGDimensionManager.UnloadCustomDimensionData(unloadedWorld.getWorld().field_73011_w.getDimension());
                    unloadedWorld.unRegisterBiomes();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MinecraftServer getClientServer() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @SubscribeEvent
    public void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null && (world.getWorldSession().getWorldBorderRadius() > 0 || world.getConfigs().getWorldConfig().bo3AtSpawn != null && world.getConfigs().getWorldConfig().bo3AtSpawn.trim().length() > 0)) {
            event.setCanceled(true);
        }
    }
}

