/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.dimensions;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class OTGGuiSlot {
    private final Minecraft mc;
    int width;
    int height;
    int top;
    int bottom;
    int right;
    int left;
    final int slotHeight;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    private int mouseX;
    private int mouseY;
    private int initialClickY = -2;
    private float scrollMultiplier;
    protected float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked;
    private boolean visible = true;
    private boolean showSelectionBox = true;
    private boolean hasListHeader;
    int headerPadding;
    private boolean enabled = true;

    OTGGuiSlot(Minecraft mcIn, int left, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.mc = mcIn;
        this.width = width;
        this.height = height;
        this.top = topIn;
        this.bottom = bottomIn;
        this.slotHeight = slotHeightIn;
        this.left = left;
        this.right = left + width;
    }

    public void setShowSelectionBox(boolean showSelectionBoxIn) {
        this.showSelectionBox = showSelectionBoxIn;
    }

    protected void setHasListHeader(boolean hasListHeaderIn, int headerPaddingIn) {
        this.hasListHeader = hasListHeaderIn;
        this.headerPadding = headerPaddingIn;
        if (!hasListHeaderIn) {
            this.headerPadding = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2, int var3, int var4);

    protected abstract boolean isSelected(int var1);

    private int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerPadding;
    }

    int getSlotIndexFromScreenCoords(int posX, int posY) {
        int i = this.left + this.width / 2 - this.getListWidth() / 2;
        int j = this.left + this.width / 2 + this.getListWidth() / 2;
        int k = posY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
        int l = k / this.slotHeight;
        return posX < this.getScrollBarX() && posX >= i && posX <= j && l >= 0 && k >= 0 && l < this.getSize() ? l : -1;
    }

    public void registerScrollButtons(int scrollUpButtonIDIn, int scrollDownButtonIDIn) {
        this.scrollUpButtonID = scrollUpButtonIDIn;
        this.scrollDownButtonID = scrollDownButtonIDIn;
    }

    private void bindAmountScrolled() {
        this.amountScrolled = MathHelper.func_76131_a((float)this.amountScrolled, (float)0.0f, (float)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.bottom - this.top - 4));
    }

    public int getAmountScrolled() {
        return (int)this.amountScrolled;
    }

    public float getAmountScrolledFloat() {
        return this.amountScrolled;
    }

    boolean isMouseYWithinSlotBounds(int p_148141_1_) {
        return p_148141_1_ >= this.top && p_148141_1_ <= this.bottom && this.mouseX >= this.left && this.mouseX <= this.right;
    }

    void scrollBy(int amount) {
        this.amountScrolled += (float)amount;
        this.bindAmountScrolled();
        this.initialClickY = -2;
    }

    protected void updateItemPos(int entryID, int insideLeft, int yPos, float partialTicks) {
    }

    public void setEnabled(boolean enabledIn) {
        this.enabled = enabledIn;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getListWidth() {
        return this.width;
    }

    private int getScrollBarX() {
        return this.left + this.width - 6;
    }

    public void setSlotXBoundsFromLeft(int leftIn) {
        this.left = leftIn;
        this.right = leftIn + this.width;
    }

    public int getSlotHeight() {
        return this.slotHeight;
    }

    protected abstract void drawBackground();

    void drawScreen(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.visible) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            int i = this.getScrollBarX();
            int j = i + 6;
            this.bindAmountScrolled();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            ScaledResolution res = new ScaledResolution(this.mc);
            double scaleW = (double)this.mc.field_71443_c / res.func_78327_c();
            double scaleH = (double)this.mc.field_71440_d / res.func_78324_d();
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.mc.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.width * scaleW)), (int)((int)((double)(this.height - this.top) * scaleH)));
            if (this.mc.field_71441_e != null) {
                GuiUtils.drawGradientRect((int)0, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)-1072689136, (int)-804253680);
            } else {
                boolean startY = false;
                int endY = this.top;
                GlStateManager.func_179140_f();
                GlStateManager.func_179106_n();
                this.mc.field_71446_o.func_110577_a(Gui.field_110325_k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float scale = 32.0f;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)this.left, (double)endY, 0.0).func_187315_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.left + this.width), (double)endY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.left + this.width), (double)startY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)this.left, (double)startY, 0.0).func_187315_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            if (this.mc.field_71441_e == null) {
                this.drawContainerBackground(tessellator);
            }
            int left = this.left;
            int top = this.top + 4 - (int)this.amountScrolled;
            if (this.hasListHeader) {
                this.drawListHeader(left, top, tessellator);
            }
            this.drawSelectionBox(left, top, mouseXIn, mouseYIn, partialTicks);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
                int l1 = (int)this.amountScrolled * (this.bottom - this.top - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.bottom - this.top - 8)))) / j1 + this.top;
                if (l1 < this.top) {
                    l1 = this.top;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)(l1 + k1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GL11.glDisable((int)3089);
        }
    }

    private void drawSelectionBox(int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int i = this.getSize();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int xPos = insideTop + j * this.slotHeight + this.headerPadding;
            int yPos = this.slotHeight - 4;
            if (xPos > this.bottom || xPos + yPos < this.top) {
                this.updateItemPos(j, insideLeft, xPos, partialTicks);
            }
            if (this.showSelectionBox && this.isSelected(j)) {
                int i1 = this.left + (this.width / 2 - this.getListWidth() / 2);
                int j1 = this.left + this.width / 2 + this.getListWidth() / 2;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i1, (double)(xPos + yPos + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(xPos + yPos + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(xPos - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i1, (double)(xPos - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(xPos + yPos + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(xPos + yPos + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(xPos - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(xPos - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.drawSlot(j, insideLeft, xPos, yPos, mouseXIn, mouseYIn, partialTicks);
        }
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ScaledResolution res = new ScaledResolution(this.mc);
        double scaleW = (double)this.mc.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.mc.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.mc.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.width * scaleW)), (int)((int)((double)this.height * scaleH)));
        if (this.mc.field_71441_e != null) {
            GuiUtils.drawGradientRect((int)0, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)-1072689136, (int)-804253680);
        } else {
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            this.mc.field_71446_o.func_110577_a(Gui.field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)this.left, (double)endY, 0.0).func_187315_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)(this.left + this.width), (double)endY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)(this.left + this.width), (double)startY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.left, (double)startY, 0.0).func_187315_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private void drawContainerBackground(Tessellator tessellator) {
        BufferBuilder buffer = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a((double)((float)this.left / f), (double)((float)(this.bottom + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a((double)((float)this.right / f), (double)((float)(this.bottom + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a((double)((float)this.right / f), (double)((float)(this.top + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a((double)((float)this.left / f), (double)((float)(this.top + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    private void drawListHeader(int insideLeft, int insideTop, Tessellator tessellatorIn) {
    }

    private void renderDecorations(int mouseXIn, int mouseYIn) {
    }

    private void clickedHeader(int p_148132_1_, int p_148132_2_) {
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpButtonID) {
                this.amountScrolled -= (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2;
                this.bindAmountScrolled();
            } else if (button.field_146127_k == this.scrollDownButtonID) {
                this.amountScrolled += (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2;
                this.bindAmountScrolled();
            }
        }
    }

    void handleMouseInput() {
        if (this.isMouseYWithinSlotBounds(this.mouseY)) {
            if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && this.mouseY >= this.top && this.mouseY <= this.bottom) {
                int i = (this.width - this.getListWidth()) / 2;
                int j = (this.width + this.getListWidth()) / 2;
                int k = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
                int l = k / this.slotHeight;
                if (l < this.getSize() && this.mouseX >= i && this.mouseX <= j && l >= 0 && k >= 0) {
                    this.elementClicked(l, false, this.mouseX, this.mouseY);
                    this.selectedElement = l;
                } else if (this.mouseX >= i && this.mouseX <= j && k < 0) {
                    this.clickedHeader(this.mouseX - i, this.mouseY - this.top + (int)this.amountScrolled - 4);
                }
            }
            if (Mouse.isButtonDown((int)0) && this.getEnabled()) {
                if (this.initialClickY == -1) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.top && this.mouseY <= this.bottom) {
                        int j2 = (this.width - this.getListWidth()) / 2;
                        int k2 = (this.width + this.getListWidth()) / 2;
                        int l2 = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
                        int i1 = l2 / this.slotHeight;
                        if (i1 < this.getSize() && this.mouseX >= j2 && this.mouseX <= k2 && i1 >= 0 && l2 >= 0) {
                            boolean flag = i1 == this.selectedElement && Minecraft.func_71386_F() - this.lastClicked < 250L;
                            this.elementClicked(i1, flag, this.mouseX, this.mouseY);
                            this.selectedElement = i1;
                            this.lastClicked = Minecraft.func_71386_F();
                        } else if (this.mouseX >= j2 && this.mouseX <= k2 && l2 < 0) {
                            this.clickedHeader(this.mouseX - j2, this.mouseY - this.top + (int)this.amountScrolled - 4);
                            flag1 = false;
                        }
                        int i3 = this.getScrollBarX();
                        int j1 = i3 + 6;
                        if (this.mouseX >= i3 && this.mouseX <= j1) {
                            this.scrollMultiplier = -1.0f;
                            int k1 = this.getMaxScroll();
                            if (k1 < 1) {
                                k1 = 1;
                            }
                            int l1 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight());
                            l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.bottom - this.top - 8));
                            this.scrollMultiplier /= (float)(this.bottom - this.top - l1) / (float)k1;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.initialClickY = flag1 ? this.mouseY : -2;
                    } else {
                        this.initialClickY = -2;
                    }
                } else if (this.initialClickY >= 0) {
                    this.amountScrolled -= (float)(this.mouseY - this.initialClickY) * this.scrollMultiplier;
                    this.initialClickY = this.mouseY;
                }
            } else {
                this.initialClickY = -1;
            }
            int i2 = Mouse.getEventDWheel();
            if (i2 != 0) {
                if (i2 > 0) {
                    i2 = -1;
                } else if (i2 < 0) {
                    i2 = 1;
                }
                this.amountScrolled += (float)(i2 * this.slotHeight / 2);
            }
        }
    }
}

