/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.mainmenu;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiListWorldSelection;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiListWorldSelectionEntry;
import com.pg85.otg.forge.gui.presets.OTGGuiPresetList;
import com.pg85.otg.forge.util.IOHelper;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class OTGGuiWorldSelection
extends GuiScreen
implements GuiYesNoCallback {
    private String title = "Select world";
    private String worldVersTooltip;
    private OTGGuiListWorldSelection selectionList;
    private GuiButton selectButton;
    private GuiButton deleteButton;

    public void setVersionTooltip(String p_184861_1_) {
        this.worldVersTooltip = p_184861_1_;
    }

    void selectWorld(@Nullable OTGGuiListWorldSelectionEntry entry) {
        boolean flag;
        this.selectButton.field_146124_l = flag = entry != null;
        this.deleteButton.field_146124_l = flag;
    }

    public void func_73866_w_() {
        this.title = I18n.func_135052_a((String)"selectWorld.title", (Object[])new Object[0]);
        this.selectionList = new OTGGuiListWorldSelection(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        this.postInit();
    }

    private void postInit() {
        int margin = 4;
        int marginFromBottom = this.field_146295_m - 54;
        int buttonHeight = 20;
        int uiWidth = 357;
        int marginFromLeft = Math.round((float)(this.field_146294_l - uiWidth) / 2.0f);
        int row1Width = 3;
        int row1ButtonWidth = (int)Math.floor((float)(uiWidth - (row1Width - 1) * margin) / (float)row1Width);
        int row1LeftOver = uiWidth - (row1ButtonWidth * row1Width + margin * (row1Width - 1));
        int row2Width = 2;
        int row2ButtonWidth = (int)Math.floor((float)(uiWidth - (row2Width - 1) * margin) / (float)row2Width);
        int row2LeftOver = uiWidth - (row2ButtonWidth * row2Width + margin * (row2Width - 1));
        this.selectButton = this.func_189646_b(new GuiButton(1, marginFromLeft, marginFromBottom, row1ButtonWidth, buttonHeight, I18n.func_135052_a((String)"selectWorld.select", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(4, marginFromLeft + row1ButtonWidth + margin, marginFromBottom, row1ButtonWidth, buttonHeight, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(3, marginFromLeft + row1ButtonWidth + margin + row1ButtonWidth + margin, marginFromBottom, row1ButtonWidth + row1LeftOver, buttonHeight, "Create OTG World"));
        this.deleteButton = this.func_189646_b(new GuiButton(2, marginFromLeft, marginFromBottom + buttonHeight + margin, row2ButtonWidth, buttonHeight, I18n.func_135052_a((String)"selectWorld.delete", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(0, marginFromLeft + row2ButtonWidth + margin, marginFromBottom + buttonHeight + margin, row2ButtonWidth + row2LeftOver, buttonHeight, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.selectButton.field_146124_l = false;
        this.deleteButton.field_146124_l = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.worldVersTooltip = null;
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.worldVersTooltip != null) {
            this.func_146283_a(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.worldVersTooltip)), mouseX, mouseY);
        }
    }

    public void func_73878_a(boolean ok, int worldId) {
        File worldDir;
        File[] fileArray;
        int n;
        int n2;
        OTGGuiListWorldSelectionEntry selectedWorld = this.selectionList.getSelectedWorld();
        String worldName = selectedWorld.getSelectedWorldName();
        super.func_73878_a(ok, worldId);
        File OTGWorldsDirectory = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds");
        if (OTGWorldsDirectory.exists() && OTGWorldsDirectory.isDirectory() && (n2 = 0) < (n = (fileArray = OTGWorldsDirectory.listFiles()).length) && (worldDir = fileArray[n2]).isDirectory() && worldDir.getName().equals(worldName)) {
            File pregeneratedChunksFile;
            File chunkProviderPopulatedChunksFile;
            File spawnedStructuresFile;
            File nullChunksFile;
            File structureDataFile;
            File dimensionsDataFile;
            File StructureDataDirectory = new File(worldDir.getAbsolutePath() + File.separator + "StructureData");
            if (StructureDataDirectory.exists()) {
                IOHelper.deleteRecursive(StructureDataDirectory);
            }
            if ((dimensionsDataFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.DimensionsDataFileName)).exists()) {
                IOHelper.deleteRecursive(dimensionsDataFile);
            }
            if ((structureDataFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.StructureDataFileName)).exists()) {
                IOHelper.deleteRecursive(structureDataFile);
            }
            if ((nullChunksFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.NullChunksFileName)).exists()) {
                IOHelper.deleteRecursive(nullChunksFile);
            }
            if ((spawnedStructuresFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.SpawnedStructuresFileName)).exists()) {
                IOHelper.deleteRecursive(spawnedStructuresFile);
            }
            if ((chunkProviderPopulatedChunksFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.ChunkProviderPopulatedChunksFileName)).exists()) {
                IOHelper.deleteRecursive(chunkProviderPopulatedChunksFile);
            }
            if ((pregeneratedChunksFile = new File(worldDir.getAbsolutePath() + File.separator + WorldStandardValues.PregeneratedChunksFileName)).exists()) {
                IOHelper.deleteRecursive(pregeneratedChunksFile);
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)new GuiMainMenu()));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            OTGGuiListWorldSelectionEntry guilistworldselectionentry = this.selectionList.getSelectedWorld();
            if (button.field_146127_k == 2) {
                if (guilistworldselectionentry != null) {
                    guilistworldselectionentry.deleteWorld();
                }
            } else if (button.field_146127_k == 1) {
                if (guilistworldselectionentry != null) {
                    guilistworldselectionentry.joinWorld();
                }
            } else if (button.field_146127_k == 3) {
                this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiPresetList(this));
            } else if (button.field_146127_k == 4) {
                OTG.setDimensionsConfig(null);
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCreateWorld((GuiScreen)this));
            } else if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.selectionList.func_178039_p();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selectionList.func_148179_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.selectionList.func_148181_b(mouseX, mouseY, state);
    }
}

