/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.presets;

import com.pg85.otg.forge.gui.OTGGuiScrollingList;
import com.pg85.otg.forge.gui.presets.OTGGuiPresetList;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;

class OTGGuiScrollingListInfo
extends OTGGuiScrollingList {
    private final OTGGuiPresetList otgGuiPresetList;
    @Nullable
    private ResourceLocation logoPath;
    private Dimension logoDims;
    private List<ITextComponent> lines = null;

    public OTGGuiScrollingListInfo(OTGGuiPresetList otgGuiPresetList, List<String> lines, @Nullable ResourceLocation logoPath, Dimension logoDims) {
        super(otgGuiPresetList.getMinecraftInstance(), otgGuiPresetList.field_146294_l - otgGuiPresetList.listWidth - otgGuiPresetList.margin - otgGuiPresetList.rightMargin, otgGuiPresetList.field_146295_m, otgGuiPresetList.topMargin, otgGuiPresetList.field_146295_m - otgGuiPresetList.bottomMargin, otgGuiPresetList.listWidth + otgGuiPresetList.margin, 60, otgGuiPresetList.field_146294_l, otgGuiPresetList.field_146295_m);
        this.otgGuiPresetList = otgGuiPresetList;
        this.lines = this.resizeContent(lines);
        this.logoPath = logoPath;
        this.logoDims = logoDims;
        this.setHeaderInfo(true, this.getHeaderHeight());
    }

    @Override
    protected int getSize() {
        return 0;
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
    }

    @Override
    protected boolean isSelected(int index) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
    }

    private List<ITextComponent> resizeContent(List<String> lines) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        if (lines != null) {
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)this.otgGuiPresetList.getFontRenderer(), (boolean)false, (boolean)true));
            }
        }
        return ret;
    }

    private int getHeaderHeight() {
        int height = 0;
        if (this.logoPath != null) {
            double scaleX = (double)this.logoDims.width / 200.0;
            double scaleY = (double)this.logoDims.height / 65.0;
            double scale = 1.0;
            if (scaleX > 1.0 || scaleY > 1.0) {
                scale = 1.0 / Math.max(scaleX, scaleY);
            }
            this.logoDims.width = (int)((double)this.logoDims.width * scale);
            this.logoDims.height = (int)((double)this.logoDims.height * scale);
            height += this.logoDims.height;
            height += 10;
        }
        if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    @Override
    protected void drawHeader(int entryRight, int relativeY, Tessellator tess, float zLevel) {
        int top = relativeY;
        if (this.logoPath != null) {
            GlStateManager.func_179147_l();
            this.otgGuiPresetList.field_146297_k.field_71446_o.func_110577_a(this.logoPath);
            BufferBuilder wr = tess.func_178180_c();
            int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b((double)offset, (double)(top + this.logoDims.height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
            wr.func_181662_b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
            wr.func_181662_b((double)(offset + this.logoDims.width), (double)top, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
            wr.func_181662_b((double)offset, (double)top, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179084_k();
            top += this.logoDims.height + 10;
        }
        for (ITextComponent line : this.lines) {
            if (line != null) {
                GlStateManager.func_179147_l();
                this.otgGuiPresetList.getFontRenderer().func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
            }
            top += 10;
        }
    }

    @Override
    protected void clickHeader(int x, int y) {
        int offset = y;
        if (this.logoPath != null) {
            offset -= this.logoDims.height + 10;
        }
        if (offset <= 0) {
            return;
        }
        int lineIdx = offset / 10;
        if (lineIdx >= this.lines.size()) {
            return;
        }
        ITextComponent line = this.lines.get(lineIdx);
        if (line != null) {
            int k = -4;
            for (ITextComponent part : line) {
                if (!(part instanceof TextComponentString) || (k += this.otgGuiPresetList.getFontRenderer().func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                this.otgGuiPresetList.func_175276_a(part);
                break;
            }
        }
    }
}

