/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.client.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.network.AbstractServerMessageHandler;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.StringUtils;

public class CreateDeleteDimensionPacket
extends OTGPacket {
    public CreateDeleteDimensionPacket() {
    }

    public CreateDeleteDimensionPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeCreatePacketToStream(DimensionConfig dimensionConfig, DataOutput stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(0);
        StreamHelper.writeStringToStream(stream, dimensionConfig.toYamlString());
    }

    public static void writeDeletePacketToStream(String dimensionName, DataOutput stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(1);
        StreamHelper.writeStringToStream(stream, dimensionName);
    }

    public static class Handler
    extends AbstractServerMessageHandler<CreateDeleteDimensionPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, CreateDeleteDimensionPacket message, MessageContext ctx) {
            try {
                int packetType = message.getStream().readInt();
                if (packetType == 0) {
                    String dimConfigYaml = StreamHelper.readStringFromStream(message.getStream());
                    final DimensionConfig dimConfig = DimensionConfig.fromYamlString(dimConfigYaml);
                    WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                    mainThread.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            for (DimensionConfig existingDimConfig : OTG.getDimensionsConfig().Dimensions) {
                                if (!existingDimConfig.PresetName.equals(dimConfig.PresetName)) continue;
                                return;
                            }
                            OTG.getDimensionsConfig().Dimensions.add(dimConfig);
                            long seed = new Random().nextLong();
                            String sSeed = dimConfig.Seed;
                            if (sSeed != null && !StringUtils.isEmpty((CharSequence)sSeed)) {
                                try {
                                    long j = Long.parseLong(sSeed);
                                    if (j != 0L) {
                                        seed = j;
                                    }
                                }
                                catch (NumberFormatException var7) {
                                    seed = sSeed.hashCode();
                                }
                            }
                            OTG.IsNewWorldBeingCreated = true;
                            OTGDimensionManager.createDimension(seed, dimConfig.PresetName, false, true, true);
                            OTG.IsNewWorldBeingCreated = false;
                            ForgeWorld createdWorld = (ForgeWorld)OTG.getWorld(dimConfig.PresetName);
                            if (dimConfig.Settings.CanDropChunk) {
                                DimensionManager.unloadWorld((int)createdWorld.getWorld().field_73011_w.getDimension());
                            }
                            ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                        }
                    });
                    IMessage iMessage = null;
                    return iMessage;
                }
                if (packetType == 1) {
                    final String worldName = StreamHelper.readStringFromStream(message.getStream());
                    WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                    mainThread.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            OTGDimensionManager.DeleteDimensionServer(worldName, player.func_184102_h());
                        }
                    });
                    IMessage iMessage = null;
                    return iMessage;
                }
                try {
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
            }
            finally {
                message.getData().release();
            }
            return null;
        }
    }
}

