/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinMesaBlocks;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinOctaves;
import com.pg85.otg.generator.terrain.CavesGen;
import com.pg85.otg.generator.terrain.RavinesGen;
import com.pg85.otg.generator.terrain.TerrainGenBase;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.Random;

public class ChunkProviderOTG {
    private static final int NOISE_MAX_X = 5;
    private static final int NOISE_MAX_Z = 5;
    private final LocalMaterialData air = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
    private final Random random;
    private final NoiseGeneratorPerlinOctaves vol1NoiseGen;
    private final NoiseGeneratorPerlinOctaves vol2NoiseGen;
    private final NoiseGeneratorPerlinOctaves volNoiseGen;
    private final NoiseGeneratorPerlinMesaBlocks biomeBlocksNoiseGen;
    private final NoiseGeneratorPerlinOctaves oldTerrainGeneratorNoiseGen;
    private final NoiseGeneratorPerlinOctaves noiseHeightNoiseGen;
    private double[] rawTerrain;
    private double[] biomeBlocksNoise = new double[256];
    private double[] volNoise;
    private double[] vol1Noise;
    private double[] vol2Noise;
    private double[] oldTerrainGeneratorNoise;
    private double[] noiseHeightNoise;
    private float[] nearBiomeWeightArray;
    private double riverVol;
    private double riverHeight;
    private boolean riverFound = false;
    private final LocalWorld localWorld;
    private double volatilityFactor;
    private double heightFactor;
    private final ConfigProvider configProvider;
    private final TerrainGenBase caveGen;
    private final TerrainGenBase canyonGen;
    private int[] biomeArray;
    private int[] riverArray;
    private final byte[] waterLevelRaw = new byte[25];
    private final byte[] waterLevel = new byte[256];
    private final int heightScale;
    private final int heightCap;
    private final int maxSmoothDiameter;
    private final int maxSmoothRadius;
    private BiomeConfig[] biomes = new BiomeConfig[1024];

    public ChunkProviderOTG(ConfigProvider configs, LocalWorld world) {
        this.configProvider = configs;
        this.localWorld = world;
        this.heightCap = world.getHeightCap();
        this.heightScale = world.getHeightScale();
        this.random = new Random(world.getSeed());
        this.vol1NoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.vol2NoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.volNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 8);
        this.biomeBlocksNoiseGen = new NoiseGeneratorPerlinMesaBlocks(this.random, 4);
        this.oldTerrainGeneratorNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 10);
        this.noiseHeightNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.caveGen = new CavesGen(configs.getWorldConfig(), this.localWorld);
        this.canyonGen = new RavinesGen(configs.getWorldConfig(), this.localWorld);
        WorldConfig worldConfig = configs.getWorldConfig();
        this.maxSmoothDiameter = worldConfig.maxSmoothRadius * 2 + 1;
        this.maxSmoothRadius = worldConfig.maxSmoothRadius;
        this.nearBiomeWeightArray = new float[this.maxSmoothDiameter * this.maxSmoothDiameter];
        for (int x = -this.maxSmoothRadius; x <= this.maxSmoothRadius; ++x) {
            for (int z = -this.maxSmoothRadius; z <= this.maxSmoothRadius; ++z) {
                float f1;
                this.nearBiomeWeightArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * this.maxSmoothDiameter] = f1 = 10.0f / MathHelper.sqrt((float)(x * x + z * z) + 0.2f);
            }
        }
    }

    public void generate(ChunkBuffer chunkBuffer) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int x = chunkCoord.getChunkX();
        int z = chunkCoord.getChunkZ();
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.generateTerrainA(chunkBuffer);
        boolean dry = false;
        if (OTG.fireReplaceBiomeBlocksEvent(x, z, chunkBuffer, this.localWorld)) {
            dry = this.addBiomeBlocksAndCheckWater(chunkBuffer);
        }
        if (!this.localWorld.generateModdedCaveGen(x, z, chunkBuffer)) {
            this.caveGen.generate(chunkBuffer);
        }
        this.canyonGen.generate(chunkBuffer);
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        if (worldConfig.modeTerrain == WorldConfig.TerrainMode.Normal) {
            this.localWorld.prepareDefaultStructures(x, z, dry);
        }
    }

    private void generateTerrain(ChunkBuffer chunkBuffer) {
    }

    private void generateTerrainA(ChunkBuffer chunkBuffer) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        int four = 4;
        int oneEightOfHeight = this.heightCap / 8;
        int maxYSections = this.heightCap / 8 + 1;
        int usedYSections = this.heightScale / 8 + 1;
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        BiomeGenerator biomeGenerator = this.localWorld.getBiomeGenerator();
        if (worldConfig.improvedRivers) {
            this.riverArray = biomeGenerator.getBiomesUnZoomed(this.riverArray, chunkX * 4 - this.maxSmoothRadius, chunkZ * 4 - this.maxSmoothRadius, 5 + this.maxSmoothDiameter, 5 + this.maxSmoothDiameter, OutputType.ONLY_RIVERS);
        }
        this.biomeArray = biomeGenerator.canGenerateUnZoomed() ? biomeGenerator.getBiomesUnZoomed(this.biomeArray, chunkX * 4 - this.maxSmoothRadius, chunkZ * 4 - this.maxSmoothRadius, 5 + this.maxSmoothDiameter, 5 + this.maxSmoothDiameter, OutputType.DEFAULT_FOR_WORLD) : biomeGenerator.getBiomes(this.biomeArray, chunkX * 16, chunkZ * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        this.generateTerrainNoise(chunkX * 4, 0, chunkZ * 4, maxYSections, usedYSections);
        if (biomeGenerator.canGenerateUnZoomed()) {
            this.biomeArray = biomeGenerator.getBiomes(this.biomeArray, chunkX * 16, chunkZ * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        }
        double oneEight = 0.125;
        double oneFourth = 0.25;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                double waterLevel_x0z0 = this.waterLevelRaw[(x + 0) * 5 + (z + 0)] & 0xFF;
                double waterLevel_x0z1 = this.waterLevelRaw[(x + 0) * 5 + (z + 1)] & 0xFF;
                double waterLevel_x1z0 = ((double)(this.waterLevelRaw[(x + 1) * 5 + (z + 0)] & 0xFF) - waterLevel_x0z0) * 0.25;
                double waterLevel_x1z1 = ((double)(this.waterLevelRaw[(x + 1) * 5 + (z + 1)] & 0xFF) - waterLevel_x0z1) * 0.25;
                for (int piece_x = 0; piece_x < 4; ++piece_x) {
                    double waterLevelForArray = waterLevel_x0z0;
                    double d17_1 = (waterLevel_x0z1 - waterLevel_x0z0) * 0.25;
                    for (int piece_z = 0; piece_z < 4; ++piece_z) {
                        this.waterLevel[(z * 4 + piece_z) * 16 + (piece_x + x * 4)] = (byte)waterLevelForArray;
                        waterLevelForArray += d17_1;
                    }
                    waterLevel_x0z0 += waterLevel_x1z0;
                    waterLevel_x0z1 += waterLevel_x1z1;
                }
                for (int y = 0; y < oneEightOfHeight; ++y) {
                    double x0z0 = this.rawTerrain[((x + 0) * 5 + (z + 0)) * maxYSections + (y + 0)];
                    double x0z1 = this.rawTerrain[((x + 0) * 5 + (z + 1)) * maxYSections + (y + 0)];
                    double x1z0 = this.rawTerrain[((x + 1) * 5 + (z + 0)) * maxYSections + (y + 0)];
                    double x1z1 = this.rawTerrain[((x + 1) * 5 + (z + 1)) * maxYSections + (y + 0)];
                    double x0z0y1 = (this.rawTerrain[((x + 0) * 5 + (z + 0)) * maxYSections + (y + 1)] - x0z0) * 0.125;
                    double x0z1y1 = (this.rawTerrain[((x + 0) * 5 + (z + 1)) * maxYSections + (y + 1)] - x0z1) * 0.125;
                    double x1z0y1 = (this.rawTerrain[((x + 1) * 5 + (z + 0)) * maxYSections + (y + 1)] - x1z0) * 0.125;
                    double x1z1y1 = (this.rawTerrain[((x + 1) * 5 + (z + 1)) * maxYSections + (y + 1)] - x1z1) * 0.125;
                    for (int piece_y = 0; piece_y < 8; ++piece_y) {
                        double d11 = x0z0;
                        double d12 = x0z1;
                        double d13 = (x1z0 - x0z0) * 0.25;
                        double d14 = (x1z1 - x0z1) * 0.25;
                        for (int piece_x = 0; piece_x < 4; ++piece_x) {
                            double d16 = d11;
                            double d17 = (d12 - d11) * 0.25;
                            for (int piece_z = 0; piece_z < 4; ++piece_z) {
                                BiomeConfig biomeConfig = this.toBiomeConfig(this.biomeArray[(z * 4 + piece_z) * 16 + (piece_x + x * 4)]);
                                int waterLevelMax = this.waterLevel[(z * 4 + piece_z) * 16 + (piece_x + x * 4)] & 0xFF;
                                LocalMaterialData block = this.air;
                                if (y * 8 + piece_y < waterLevelMax && y * 8 + piece_y > biomeConfig.waterLevelMin) {
                                    block = biomeConfig.waterBlock;
                                }
                                if (d16 > 0.0) {
                                    block = biomeConfig.stoneBlock;
                                }
                                chunkBuffer.setBlock(piece_x + x * 4, y * 8 + piece_y, z * 4 + piece_z, block);
                                d16 += d17;
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        x0z0 += x0z0y1;
                        x0z1 += x0z1y1;
                        x1z0 += x1z0y1;
                        x1z1 += x1z1y1;
                    }
                }
            }
        }
    }

    private boolean addBiomeBlocksAndCheckWater(ChunkBuffer chunkBuffer) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int dryBlocksOnSurface = 256;
        double d1 = 0.03125;
        this.biomeBlocksNoise = this.biomeBlocksNoiseGen.getRegion(this.biomeBlocksNoise, chunkCoord.getBlockX(), chunkCoord.getBlockZ(), 16, 16, 0.0625, 0.0625, 1.0);
        GeneratingChunk generatingChunk = new GeneratingChunk(this.random, this.waterLevel, this.biomeBlocksNoise, this.heightCap);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeConfig biomeConfig = this.toBiomeConfig(this.biomeArray[x + z * 16]);
                biomeConfig.surfaceAndGroundControl.spawn(this.localWorld.getSeed(), generatingChunk, chunkBuffer, biomeConfig, chunkCoord.getBlockX() + x, chunkCoord.getBlockZ() + z);
                if (!chunkBuffer.getBlock(x, biomeConfig.waterLevelMax, z).equals(biomeConfig.waterBlock)) continue;
                --dryBlocksOnSurface;
            }
        }
        return dryBlocksOnSurface > 250;
    }

    private void generateTerrainNoise(int xOffset, int yOffset, int zOffset, int maxYSections, int usedYSections) {
        if (this.rawTerrain == null || this.rawTerrain.length != 5 * maxYSections * 5) {
            this.rawTerrain = new double[5 * maxYSections * 5];
        }
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        double xzScale = 684.412 * worldConfig.getFractureHorizontal();
        double yScale = 684.412 * worldConfig.getFractureVertical();
        if (worldConfig.oldTerrainGenerator) {
            this.oldTerrainGeneratorNoise = this.oldTerrainGeneratorNoiseGen.Noise2D(this.oldTerrainGeneratorNoise, xOffset, zOffset, 5, 5, 1.121, 1.121);
        }
        this.noiseHeightNoise = this.noiseHeightNoiseGen.Noise2D(this.noiseHeightNoise, xOffset, zOffset, 5, 5, 200.0, 200.0);
        this.volNoise = this.volNoiseGen.Noise3D(this.volNoise, xOffset, yOffset, zOffset, 5, maxYSections, 5, xzScale / 80.0, yScale / 160.0, xzScale / 80.0);
        this.vol1Noise = this.vol1NoiseGen.Noise3D(this.vol1Noise, xOffset, yOffset, zOffset, 5, maxYSections, 5, xzScale, yScale, xzScale);
        this.vol2Noise = this.vol2NoiseGen.Noise3D(this.vol2Noise, xOffset, yOffset, zOffset, 5, maxYSections, 5, xzScale, yScale, xzScale);
        int i3D = 0;
        int i2D = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                int biomeId = this.biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)];
                BiomeConfig biomeConfig = this.toBiomeConfig(biomeId);
                double noiseHeight = this.noiseHeightNoise[i2D] / 8000.0;
                if (noiseHeight < 0.0) {
                    noiseHeight = -noiseHeight * 0.3;
                }
                if ((noiseHeight = noiseHeight * 3.0 - 2.0) < 0.0) {
                    if ((noiseHeight /= 2.0) < -1.0) {
                        noiseHeight = -1.0;
                    }
                    noiseHeight -= biomeConfig.maxAverageDepth;
                    noiseHeight /= 1.4;
                    noiseHeight /= 2.0;
                } else {
                    if (noiseHeight > 1.0) {
                        noiseHeight = 1.0;
                    }
                    noiseHeight += biomeConfig.maxAverageHeight;
                    noiseHeight /= 8.0;
                }
                if (!worldConfig.oldTerrainGenerator) {
                    if (worldConfig.improvedRivers) {
                        this.biomeFactorWithRivers(x, z, usedYSections, noiseHeight);
                    } else {
                        this.biomeFactor(x, z, usedYSections, noiseHeight);
                    }
                } else {
                    this.oldBiomeFactor(x, z, i2D, usedYSections, noiseHeight);
                }
                ++i2D;
                for (int y = 0; y < maxYSections; ++y) {
                    double d8 = this.riverFound ? (this.riverHeight - (double)y) * 12.0 * 128.0 / (double)this.heightCap / this.riverVol : (this.heightFactor - (double)y) * 12.0 * 128.0 / (double)this.heightCap / this.volatilityFactor;
                    if (d8 > 0.0) {
                        d8 *= 4.0;
                    }
                    double vol1 = this.vol1Noise[i3D] / 512.0 * biomeConfig.volatility1;
                    double vol2 = this.vol2Noise[i3D] / 512.0 * biomeConfig.volatility2;
                    double noise = (this.volNoise[i3D] / 10.0 + 1.0) / 2.0;
                    double output = noise < biomeConfig.volatilityWeight1 ? vol1 : (noise > biomeConfig.volatilityWeight2 ? vol2 : vol1 + (vol2 - vol1) * noise);
                    if (!biomeConfig.disableNotchHeightControl) {
                        output += d8;
                        if (y > maxYSections - 4) {
                            double d12 = (float)(y - (maxYSections - 4)) / 3.0f;
                            output = output * (1.0 - d12) + -10.0 * d12;
                        }
                    }
                    output = this.riverFound ? (output += biomeConfig.riverHeightMatrix[Math.min(biomeConfig.riverHeightMatrix.length - 1, y)]) : (output += biomeConfig.heightMatrix[Math.min(biomeConfig.heightMatrix.length - 1, y)]);
                    this.rawTerrain[i3D] = output;
                    ++i3D;
                }
            }
        }
    }

    private void oldBiomeFactor(int x, int z, int i4, int ySections, double noiseHeight) {
        BiomeConfig biomeConfig = this.toBiomeConfig(this.biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        this.volatilityFactor = 1.0 - (double)(Math.min(1.0f, biomeConfig.biomeTemperature) * biomeConfig.biomeWetness);
        this.volatilityFactor *= this.volatilityFactor;
        this.volatilityFactor = 1.0 - this.volatilityFactor * this.volatilityFactor;
        this.volatilityFactor = (this.volNoise[i4] + 256.0) / 512.0 * this.volatilityFactor;
        if (this.volatilityFactor > 1.0) {
            this.volatilityFactor = 1.0;
        }
        if (this.volatilityFactor < 0.0 || noiseHeight < 0.0) {
            this.volatilityFactor = 0.0;
        }
        this.volatilityFactor += 0.5;
        this.heightFactor = (double)ySections * (2.0 + noiseHeight) / 4.0;
    }

    private void biomeFactor(int x, int z, int ySections, double noiseHeight) {
        float volatilitySum = 0.0f;
        double heightSum = 0.0;
        float biomeWeightSum = 0.0f;
        BiomeConfig centerBiomeConfig = this.toBiomeConfig(this.biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = centerBiomeConfig.smoothRadius;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                BiomeConfig nextBiomeConfig = this.toBiomeConfig(this.biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                float nextBiomeHeight = nextBiomeConfig.biomeHeight;
                float biomeWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextBiomeHeight + 2.0f);
                biomeWeight = Math.abs(biomeWeight);
                volatilitySum += nextBiomeConfig.biomeVolatility * biomeWeight;
                heightSum += (double)(nextBiomeHeight * biomeWeight);
                biomeWeightSum += biomeWeight;
            }
        }
        volatilitySum /= biomeWeightSum;
        heightSum /= (double)biomeWeightSum;
        this.waterLevelRaw[x * 5 + z] = (byte)centerBiomeConfig.waterLevelMax;
        volatilitySum = volatilitySum * 0.9f + 0.1f;
        heightSum = (heightSum * 4.0 - 1.0) / 8.0;
        this.volatilityFactor = volatilitySum;
        this.heightFactor = (double)ySections * (2.0 + heightSum + noiseHeight * 0.2) / 4.0;
    }

    private void biomeFactorWithRivers(int x, int z, int ySections, double noiseHeight) {
        float volatilitySum = 0.0f;
        float heightSum = 0.0f;
        float WeightSum = 0.0f;
        float riverVolatilitySum = 0.0f;
        float riverHeightSum = 0.0f;
        float riverWeightSum = 0.0f;
        BiomeConfig biomeConfig = this.toBiomeConfig(this.biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = biomeConfig.smoothRadius;
        this.riverFound = this.riverArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)] == 1;
        float riverCenterHeight = this.riverFound ? biomeConfig.riverHeight : biomeConfig.biomeHeight;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                BiomeConfig nextBiomeConfig = this.toBiomeConfig(this.biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                float nextBiomeHeight = nextBiomeConfig.biomeHeight;
                float biomeWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextBiomeHeight + 2.0f);
                biomeWeight = Math.abs(biomeWeight);
                volatilitySum += nextBiomeConfig.biomeVolatility * biomeWeight;
                heightSum += nextBiomeHeight * biomeWeight;
                WeightSum += biomeWeight;
                boolean isRiver = false;
                if (this.riverArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)] == 1) {
                    this.riverFound = true;
                    isRiver = true;
                }
                float nextRiverHeight = isRiver ? nextBiomeConfig.riverHeight : nextBiomeHeight;
                float riverWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextRiverHeight + 2.0f);
                riverWeight = Math.abs(riverWeight);
                if (nextRiverHeight > riverCenterHeight) {
                    nextRiverHeight = riverCenterHeight;
                }
                riverVolatilitySum += (isRiver ? nextBiomeConfig.riverVolatility : nextBiomeConfig.biomeVolatility) * riverWeight;
                riverHeightSum += nextRiverHeight * riverWeight;
                riverWeightSum += riverWeight;
            }
        }
        volatilitySum /= WeightSum;
        heightSum /= WeightSum;
        riverVolatilitySum /= riverWeightSum;
        riverHeightSum /= riverWeightSum;
        int waterLevelSum = this.riverFound ? biomeConfig.riverWaterLevel : biomeConfig.waterLevelMax;
        this.waterLevelRaw[x * 5 + z] = (byte)waterLevelSum;
        volatilitySum = volatilitySum * 0.9f + 0.1f;
        heightSum = (heightSum * 4.0f - 1.0f) / 8.0f;
        this.volatilityFactor = volatilitySum;
        this.heightFactor = (double)ySections * (2.0 + (double)heightSum + noiseHeight * 0.2) / 4.0;
        riverVolatilitySum = riverVolatilitySum * 0.9f + 0.1f;
        riverHeightSum = (riverHeightSum * 4.0f - 1.0f) / 8.0f;
        this.riverVol = riverVolatilitySum;
        this.riverHeight = (double)ySections * (2.0 + (double)riverHeightSum + noiseHeight * 0.2) / 4.0;
    }

    private BiomeConfig toBiomeConfig(int id) {
        BiomeConfig biomeConfig = this.biomes[id];
        if (biomeConfig == null) {
            LocalBiome biome = this.configProvider.getBiomeByOTGIdOrNull(id);
            this.biomes[id] = biomeConfig = biome.getBiomeConfig();
        }
        return biomeConfig;
    }
}

