/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.configuration.world.WorldConfig;
import java.util.Random;

public final class GeneratingChunk {
    private static final int BEDROCK_LAYER_HEIGHT = 5;
    public final int heightCap;
    public final Random random;
    private final byte[] waterLevel;
    private final double[] surfaceNoise;

    GeneratingChunk(Random random, byte[] waterLevel, double[] surfaceNoise, int heightCap) {
        this.random = random;
        this.waterLevel = waterLevel;
        this.surfaceNoise = surfaceNoise;
        this.heightCap = heightCap;
    }

    public double getNoise(int x, int z) {
        return this.surfaceNoise[x + z * 16];
    }

    public int getWaterLevel(int x, int z) {
        return this.waterLevel[z + x * 16] & 0xFF;
    }

    public boolean mustCreateBedrockAt(WorldConfig worldConfig, int y) {
        if (worldConfig.flatBedrock) {
            if (!worldConfig.disableBedrock && y == 0) {
                return true;
            }
            return worldConfig.ceilingBedrock && y >= this.heightCap - 2;
        }
        if (!worldConfig.disableBedrock && y < 5) {
            return y <= this.random.nextInt(5);
        }
        if (worldConfig.ceilingBedrock) {
            int amountBelowHeightCap = this.heightCap - y - 2;
            if (amountBelowHeightCap < 0 || amountBelowHeightCap > 5) {
                return false;
            }
            return amountBelowHeightCap <= this.random.nextInt(5);
        }
        return false;
    }

    public long getSeed() {
        return 0L;
    }
}

