/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;

public class LayerMixWithRiver
extends Layer {
    private int defaultFrozenOceanId;
    private ConfigProvider configs;
    private int[] riverBiomes;
    private Layer riverLayer;

    LayerMixWithRiver(long seed, Layer childLayer, Layer riverLayer, ConfigProvider configs, LocalWorld world, int defaultOceanId, int defaultFrozenOceanId) {
        super(seed, defaultOceanId);
        this.defaultFrozenOceanId = defaultFrozenOceanId;
        this.child = childLayer;
        this.configs = configs;
        this.riverLayer = riverLayer;
        this.riverBiomes = new int[world.getMaxBiomesCount()];
        for (int id = 0; id < this.riverBiomes.length; ++id) {
            LocalBiome biome = configs.getBiomeByOTGIdOrNull(id);
            this.riverBiomes[id] = -1;
            if (biome == null || biome.getBiomeConfig().riverBiome.isEmpty()) continue;
            LocalBiome riverBiome = world.getBiomeByNameOrNull(biome.getBiomeConfig().riverBiome);
            if (riverBiome != null) {
                this.riverBiomes[id] = riverBiome.getIds().getOTGBiomeId();
                continue;
            }
            OTG.log(LogMarker.WARN, "River biome \"" + biome.getBiomeConfig().riverBiome + "\" for biome " + biome.getBiomeConfig().getName() + " could not be found.", new Object[0]);
        }
    }

    @Override
    public void initWorldGenSeed(long worldSeed) {
        super.initWorldGenSeed(worldSeed);
        this.riverLayer.initWorldGenSeed(worldSeed + 31337L);
    }

    @Override
    public int[] getInts(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        switch (cache.outputType) {
            case FULL: {
                return this.getFull(world, cache, x, z, xSize, zSize);
            }
            case WITHOUT_RIVERS: {
                return this.getWithoutRivers(world, cache, x, z, xSize, zSize);
            }
            case ONLY_RIVERS: {
                return this.getOnlyRivers(world, cache, x, z, xSize, zSize);
            }
        }
        throw new UnsupportedOperationException("Unknown/invalid output type: " + (Object)((Object)cache.outputType));
    }

    private int[] getFull(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x, z, xSize, zSize);
        int[] riverInts = this.riverLayer.getInts(world, cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int currentRiver = riverInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? ((currentPiece & 0x400000) != 0 ? currentPiece & 0x3FF : this.defaultOceanId) : (worldConfig.frozenOcean && (currentPiece & 0x1000) != 0 ? this.defaultFrozenOceanId : this.defaultOceanId);
                LocalBiome biome = this.configs.getBiomeByOTGIdOrNull(cachedId);
                currentPiece = worldConfig.riversEnabled && (currentRiver & 0x300000) != 0 && !biome.getBiomeConfig().riverBiome.isEmpty() ? this.riverBiomes[cachedId] : cachedId;
                thisInts[xi + zi * xSize] = currentPiece;
            }
        }
        return thisInts;
    }

    private int[] getWithoutRivers(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? ((currentPiece & 0x400000) != 0 ? currentPiece & 0x3FF : this.defaultOceanId) : (worldConfig.frozenOcean && (currentPiece & 0x1000) != 0 ? this.defaultFrozenOceanId : this.defaultOceanId);
                thisInts[xi + zi * xSize] = currentPiece = cachedId;
            }
        }
        return thisInts;
    }

    private int[] getOnlyRivers(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x, z, xSize, zSize);
        int[] riverInts = this.riverLayer.getInts(world, cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        WorldConfig worldConfig = this.configs.getWorldConfig();
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int currentPiece = childInts[xi + zi * xSize];
                int currentRiver = riverInts[xi + zi * xSize];
                int cachedId = (currentPiece & 0x400) != 0 ? ((currentPiece & 0x400000) != 0 ? currentPiece & 0x3FF : this.defaultOceanId) : (worldConfig.frozenOcean && (currentPiece & 0x1000) != 0 ? this.defaultFrozenOceanId : this.defaultOceanId);
                LocalBiome biome = this.configs.getBiomeByOTGIdOrNull(cachedId);
                currentPiece = worldConfig.riversEnabled && (currentRiver & 0x300000) != 0 && !biome.getBiomeConfig().riverBiome.isEmpty() ? 1 : 0;
                thisInts[xi + zi * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

