/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class OreGen
extends Resource {
    private final int maxAltitude;
    private final int maxSize;
    private final int minAltitude;
    private final MaterialSet sourceBlocks;

    public OreGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(7, args);
        this.material = this.readMaterial(args.get(0));
        this.maxSize = this.readInt(args.get(1), 1, 128);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 256);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 6);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        OreGen compare = (OreGen)other;
        return this.maxSize == compare.maxSize && this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + super.hashCode();
        hash = 11 * hash + this.minAltitude;
        hash = 11 * hash + this.maxAltitude;
        hash = 11 * hash + this.maxSize;
        hash = 11 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "Ore(" + this.material + "," + this.maxSize + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        float f = rand.nextFloat() * (float)Math.PI;
        double d1 = (float)(x + 8) + MathHelper.sin(f) * (float)this.maxSize / 8.0f;
        double d2 = (float)(x + 8) - MathHelper.sin(f) * (float)this.maxSize / 8.0f;
        double d3 = (float)(z + 8) + MathHelper.cos(f) * (float)this.maxSize / 8.0f;
        double d4 = (float)(z + 8) - MathHelper.cos(f) * (float)this.maxSize / 8.0f;
        double d5 = y + rand.nextInt(3) - 2;
        double d6 = y + rand.nextInt(3) - 2;
        for (int i = 0; i < this.maxSize; ++i) {
            float iFactor = (float)i / (float)this.maxSize;
            double d7 = d1 + (d2 - d1) * (double)iFactor;
            double d8 = d5 + (d6 - d5) * (double)iFactor;
            double d9 = d3 + (d4 - d3) * (double)iFactor;
            double d10 = rand.nextDouble() * (double)this.maxSize / 16.0;
            double d11 = ((double)MathHelper.sin((float)Math.PI * iFactor) + 1.0) * d10 + 1.0;
            double d12 = ((double)MathHelper.sin((float)Math.PI * iFactor) + 1.0) * d10 + 1.0;
            int j = MathHelper.floor(d7 - d11 / 2.0);
            int k = MathHelper.floor(d8 - d12 / 2.0);
            int m = MathHelper.floor(d9 - d11 / 2.0);
            int n = MathHelper.floor(d7 + d11 / 2.0);
            int i1 = MathHelper.floor(d8 + d12 / 2.0);
            int i2 = MathHelper.floor(d9 + d11 / 2.0);
            for (int i3 = j; i3 <= n; ++i3) {
                double d13 = ((double)i3 + 0.5 - d7) / (d11 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int i4 = k; i4 <= i1; ++i4) {
                    double d14 = ((double)i4 + 0.5 - d8) / (d12 / 2.0);
                    if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                    for (int i5 = m; i5 <= i2; ++i5) {
                        double d15 = ((double)i5 + 0.5 - d9) / (d11 / 2.0);
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0) || !this.sourceBlocks.contains(world.getMaterial(i3, i4, i5, false))) continue;
                        world.setBlock(i3, i4, i5, this.material, null, false);
                    }
                }
            }
        }
    }
}

