/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.List;
import java.util.Random;

public class UndergroundLakeGen
extends Resource {
    private final int maxAltitude;
    private final int maxSize;
    private final int minAltitude;
    private final int minSize;

    public UndergroundLakeGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.material = MaterialHelper.toLocalMaterialData(DefaultMaterial.STATIONARY_WATER, 0);
        this.assureSize(6, args);
        this.minSize = this.readInt(args.get(0), 1, 25);
        this.maxSize = this.readInt(args.get(1), this.minSize, 60);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 256);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 256);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        UndergroundLakeGen compare = (UndergroundLakeGen)other;
        return this.maxAltitude == compare.maxAltitude && this.minAltitude == compare.minAltitude && this.minSize == compare.minSize && this.maxSize == compare.maxSize;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + super.hashCode();
        hash = 29 * hash + this.minSize;
        hash = 29 * hash + this.maxSize;
        hash = 29 * hash + this.minAltitude;
        hash = 29 * hash + this.maxAltitude;
        return hash;
    }

    @Override
    public String toString() {
        return "UnderGroundLake(" + this.minSize + "," + this.maxSize + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        if (y >= world.getHighestBlockYAt(x, z)) {
            return;
        }
        int size = RandomHelper.numberInRange(rand, this.minSize, this.maxSize);
        float mPi = rand.nextFloat() * 3.141593f;
        double x1 = (float)(x + 8) + MathHelper.sin(mPi) * (float)size / 8.0f;
        double x2 = (float)(x + 8) - MathHelper.sin(mPi) * (float)size / 8.0f;
        double z1 = (float)(z + 8) + MathHelper.cos(mPi) * (float)size / 8.0f;
        double z2 = (float)(z + 8) - MathHelper.cos(mPi) * (float)size / 8.0f;
        double y1 = y + rand.nextInt(3) + 2;
        double y2 = y + rand.nextInt(3) + 2;
        for (int i = 0; i <= size; ++i) {
            double xAdjusted = x1 + (x2 - x1) * (double)i / (double)size;
            double yAdjusted = y1 + (y2 - y1) * (double)i / (double)size;
            double zAdjusted = z1 + (z2 - z1) * (double)i / (double)size;
            double horizontalSizeMultiplier = rand.nextDouble() * (double)size / 16.0;
            double verticalSizeMultiplier = rand.nextDouble() * (double)size / 32.0;
            double horizontalSize = (double)(MathHelper.sin((float)i * 3.141593f / (float)size) + 1.0f) * horizontalSizeMultiplier + 1.0;
            double verticalSize = (double)(MathHelper.sin((float)i * 3.141593f / (float)size) + 1.0f) * verticalSizeMultiplier + 1.0;
            for (int xLake = (int)(xAdjusted - horizontalSize / 2.0); xLake <= (int)(xAdjusted + horizontalSize / 2.0); ++xLake) {
                for (int yLake = (int)(yAdjusted - verticalSize / 2.0); yLake <= (int)(yAdjusted + verticalSize / 2.0); ++yLake) {
                    for (int zLake = (int)(zAdjusted - horizontalSize / 2.0); zLake <= (int)(zAdjusted + horizontalSize / 2.0); ++zLake) {
                        double zBounds;
                        double yBounds;
                        double xBounds;
                        LocalMaterialData material = world.getMaterial(xLake, yLake, zLake, false);
                        if (material == null || material.isAir() || material.isMaterial(DefaultMaterial.BEDROCK) || (xBounds = ((double)xLake + 0.5 - xAdjusted) / (horizontalSize / 2.0)) * xBounds + (yBounds = ((double)yLake + 0.5 - yAdjusted) / (verticalSize / 2.0)) * yBounds + (zBounds = ((double)zLake + 0.5 - zAdjusted) / (horizontalSize / 2.0)) * zBounds >= 1.0) continue;
                        LocalMaterialData materialBelow = world.getMaterial(xLake, yLake - 1, zLake, false);
                        if (materialBelow != null && materialBelow.isAir()) {
                            world.setBlock(xLake, yLake, zLake, materialBelow, null, false);
                            continue;
                        }
                        world.setBlock(xLake, yLake, zLake, material, null, false);
                    }
                }
            }
        }
    }
}

