/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.network;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.helpers.StreamHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public final class ConfigToNetworkSender {
    public static void writeConfigsToStream(ConfigProvider configProvider, DataOutput stream, boolean isSinglePlayer) throws IOException {
        WorldConfig worldConfig = configProvider.getWorldConfig();
        LocalBiome[] biomes = configProvider.getBiomeArrayByOTGId();
        StreamHelper.writeStringToStream(stream, worldConfig.getName());
        stream.writeInt(worldConfig.worldFog);
        stream.writeInt(worldConfig.worldNightFog);
        stream.writeInt(worldConfig.waterLevelMax);
        StreamHelper.writeStringToStream(stream, worldConfig.defaultOceanBiome);
        StreamHelper.writeStringToStream(stream, worldConfig.defaultFrozenOceanBiome);
        ArrayList<LocalBiome> nonVirtualBiomes = new ArrayList<LocalBiome>();
        ArrayList<LocalBiome> nonVirtualCustomBiomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : biomes) {
            if (biome == null || biome.getIds().isVirtual()) continue;
            nonVirtualBiomes.add(biome);
            if (!biome.isCustom()) continue;
            nonVirtualCustomBiomes.add(biome);
        }
        stream.writeInt(nonVirtualBiomes.size());
        for (LocalBiome biome : nonVirtualBiomes) {
            if (biome == null) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            stream.writeInt(biome.getIds().getOTGBiomeId());
            stream.writeInt(biome.getIds().getSavedId());
            biome.getBiomeConfig().writeToStream(stream, isSinglePlayer);
        }
    }
}

