/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.attributes.common.skills.magic.adaptation;

import codersafterdark.attributes.Attributes;
import codersafterdark.attributes.common.skills.magic.adaptation.TraitAdaptation;
import codersafterdark.attributes.common.skills.magic.adaptation.keys.EntityAdaptationLockKey;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotionEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.attributes.AdaptationTweaker")
@ZenRegister
public class AdaptationTweaker {
    @ZenMethod
    public static void addAdaptation(IEntityDefinition definition, IPotionEffect ... effects) {
        Attributes.LATE_ADDITIONS.add(new AddAdaptation(definition, effects));
    }

    private static boolean checkValidIEntityDefinition(IEntityDefinition entity) {
        if (entity == null) {
            CraftTweakerAPI.logError((String)"IEntityDefinition was found to be null");
            return false;
        }
        return true;
    }

    private static boolean checkValidIPotionEffect(IPotionEffect effect) {
        Collection potions = ForgeRegistries.POTIONS.getValuesCollection();
        if (effect == null) {
            CraftTweakerAPI.logError((String)"IPotionEffect was found to be null");
        }
        for (Potion potion : potions) {
            if (potion == null || !Objects.equals(effect != null ? effect.getEffectName() : null, potion.func_76393_a())) continue;
            return true;
        }
        CraftTweakerAPI.logError((String)"No Valid Potion found for the provided Potion Effect");
        return false;
    }

    public static class AddAdaptation
    implements IAction {
        private final IEntityDefinition definition;
        private final IPotionEffect[] effects;

        private AddAdaptation(IEntityDefinition entityDefinition, IPotionEffect ... effects) {
            this.definition = entityDefinition;
            this.effects = effects;
        }

        public void apply() {
            ArrayList<PotionEffect> trueEffects = new ArrayList<PotionEffect>();
            for (IPotionEffect effect : this.effects) {
                if (!AdaptationTweaker.checkValidIPotionEffect(effect)) continue;
                trueEffects.add(CraftTweakerMC.getPotionEffect((IPotionEffect)effect));
            }
            if (AdaptationTweaker.checkValidIEntityDefinition(this.definition)) {
                TraitAdaptation.addAdaption(new EntityAdaptationLockKey(this.definition.getId()), trueEffects);
            }
        }

        public String describe() {
            StringBuilder string = new StringBuilder(" With Effect(s): ");
            for (IPotionEffect effect : this.effects) {
                string.append(effect.getEffectName()).append(" With Duration: ").append(effect.getDuration()).append(" With Amplifier: ").append(effect.getAmplifier());
            }
            return "Added Adaptation for Entity: " + this.definition.getName() + string;
        }
    }
}

