/*
 * Decompiled with CFR 0.152.
 */
package brightspark.extraskills;

import brightspark.extraskills.BasicSkill;
import brightspark.extraskills.SkillDto;
import codersafterdark.reskillable.api.skill.Skill;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="extraskills", name="ExtraSkills", version="1.0.2", dependencies="required:reskillable", acceptedMinecraftVersions="[1.12.2]")
public class ExtraSkills {
    static final String MODID = "extraskills";
    static final String NAME = "ExtraSkills";
    static final String VERSION = "1.0.2";
    static final String DEPENDENCIES = "required:reskillable";
    private static Logger LOGGER;
    private static File MOD_CONFIG_DIR;
    private static Set<SkillDto> SKILLS_DTO;
    private static Set<Skill> SKILLS;
    private static Gson GSON;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        MOD_CONFIG_DIR = new File(event.getModConfigurationDirectory(), MODID);
        File jsonFile = new File(MOD_CONFIG_DIR, "skills.json");
        if (MOD_CONFIG_DIR.mkdirs()) {
            LOGGER.info("Created mod config directory");
        }
        if (!jsonFile.exists()) {
            LOGGER.warn("No skills.json found! Generating default file...");
            SkillDto skill2 = new SkillDto("example", "Example", "stone");
            try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(jsonFile));){
                writer.jsonValue(GSON.toJson((Object)ImmutableSet.of((Object)skill2)));
            }
            catch (IOException e) {
                LOGGER.error("Error creating default skills JSON file!");
                e.printStackTrace();
            }
        } else {
            try {
                Type type = new TypeToken<Set<SkillDto>>(){}.getType();
                SKILLS_DTO = (Set)GSON.fromJson(new JsonReader((Reader)new FileReader(jsonFile)), type);
            }
            catch (JsonParseException | FileNotFoundException e) {
                LOGGER.error("Error reading skills JSON file!");
                e.printStackTrace();
            }
            if (SKILLS_DTO == null || SKILLS_DTO.size() == 0) {
                LOGGER.warn("No skills read from JSON file!");
            } else {
                SKILLS_DTO.removeIf(skill -> skill.name == null || skill.name.equalsIgnoreCase("example"));
                LOGGER.info("Read " + SKILLS_DTO.size() + " extra skills from JSON file");
                SKILLS_DTO.forEach(skillDto -> {
                    BasicSkill skill;
                    if (skillDto.localName == null) {
                        LOGGER.warn("The extra skill %s has no localName! Falling back to the name.", (Object)skillDto.name);
                        skillDto.localName = skillDto.name;
                    }
                    if (skillDto.background == null) {
                        LOGGER.warn("The extra skill %s has no background! Falling back to \"stone\".", (Object)skillDto.name);
                        skillDto.background = "stone";
                    }
                    if (SKILLS.add(skill = new BasicSkill(skillDto.name, skillDto.localName, skillDto.background))) {
                        LOGGER.info("Added new skill: " + (Object)((Object)skill));
                    } else {
                        LOGGER.warn("Duplicate skill not added: " + (Object)((Object)skill));
                    }
                });
                LOGGER.info("Created " + SKILLS.size() + " skills successfully");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        if (!event.getSide().isClient()) {
            return;
        }
        Object[] iconsNames = MOD_CONFIG_DIR.list((dir, name) -> name.endsWith(".png"));
        if (iconsNames != null && iconsNames.length > 0) {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            HashSet icons = Sets.newHashSet((Object[])iconsNames);
            SKILLS.forEach(skill -> {
                ResourceLocation icon = skill.getSpriteLocation();
                String[] path = icon.func_110623_a().split("/");
                String fileName = path[path.length - 1];
                if (icons.contains(fileName)) {
                    try {
                        textureManager.func_110579_a(icon, (ITextureObject)new DynamicTexture(ImageIO.read(new File(MOD_CONFIG_DIR, fileName))));
                    }
                    catch (IOException e) {
                        LOGGER.warn("Couldn't load icon " + icon + "!");
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    static {
        SKILLS_DTO = null;
        SKILLS = new HashSet<Skill>();
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    @Mod.EventBusSubscriber(modid="extraskills")
    public static class RegistryHandler {
        @SubscribeEvent
        public static void regSkills(RegistryEvent.Register<Skill> event) {
            IForgeRegistry registry = event.getRegistry();
            if (SKILLS != null) {
                SKILLS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
            }
        }
    }
}

