/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.caps.abilities;

import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.api.caps.abilities.EquipmentSlot;
import com.sofodev.armorplus.api.caps.abilities.MaterialType;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemArmorV2;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class ImplementedAbilities {
    public static IForgeRegistry<AbilityData> ABILITY_REGISTRY;
    public static final AbilityData NONE;
    public static final AbilityData NIGHT_VISION;
    public static final AbilityData WATER_BREATHING;
    public static final AbilityData RESISTANCE;
    public static final AbilityData FIRE_RESISTANCE;
    public static final AbilityData HASTE;
    public static final AbilityData SPEED;
    public static final AbilityData JUMP_BOOST;
    public static final AbilityData REGENERATION;
    public static final AbilityData STRENGTH;
    public static final AbilityData INVISIBILITY;
    public static final AbilityData ABSORPTION;
    public static final AbilityData WITHER_PROOF;
    public static final AbilityData FLIGHT;
    public static final AbilityData STEP_ASSIST;
    public static final AbilityData BONUS_XP_ON_KILL;
    public static final AbilityData WALK_ON_LAVA;
    public static final AbilityData SWIMMING_SPEED;

    static {
        NONE = new AbilityData("armorplus:empty", "ability.armorplus.empty.name", new EquipmentSlot(EntityEquipmentSlot.values()), MaterialType.NONE);
        NIGHT_VISION = new AbilityData("minecraft:night_vision", "ability.armorplus.night_vision.name", EntityEquipmentSlot.HEAD, MaterialType.COAL, MaterialType.INFUSED_LAVA, MaterialType.GUARDIAN).setPotion(true);
        WATER_BREATHING = new AbilityData("minecraft:water_breathing", "ability.armorplus.water_breathing.name", EntityEquipmentSlot.HEAD, MaterialType.LAPIS, MaterialType.GUARDIAN).setPotion(true);
        RESISTANCE = new AbilityData("minecraft:resistance", "ability.armorplus.resistance.name", EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET, MaterialType.OBSIDIAN, MaterialType.INFUSED_LAVA).setPotion(true);
        FIRE_RESISTANCE = new AbilityData("minecraft:fire_resistance", "ability.armorplus.fire_resistance.name", EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET, MaterialType.OBSIDIAN, MaterialType.INFUSED_LAVA).setPotion(true);
        HASTE = new AbilityData("minecraft:haste", "ability.armorplus.haste.name", EntityEquipmentSlot.CHEST, MaterialType.REDSTONE, MaterialType.EMERALD).setPotion(true);
        SPEED = new AbilityData("minecraft:speed", "ability.armorplus.speed.name", EntityEquipmentSlot.FEET, MaterialType.REDSTONE, MaterialType.EMERALD, MaterialType.GUARDIAN).setPotion(true);
        JUMP_BOOST = new AbilityData("minecraft:jump_boost", "ability.armorplus.jump_boost.name", EntityEquipmentSlot.FEET, MaterialType.SLIME).setPotion(true);
        REGENERATION = new AbilityData("minecraft:regeneration", "ability.armorplus.regeneration.name", EntityEquipmentSlot.CHEST, MaterialType.SUPER_STAR, MaterialType.ULTIMATE).setPotion(true);
        STRENGTH = new AbilityData("minecraft:strength", "ability.armorplus.strength.name", EntityEquipmentSlot.CHEST, MaterialType.MANYULLYN).setPotion(true);
        INVISIBILITY = new AbilityData("minecraft:invisibility", "ability.armorplus.invisibility.name", EntityEquipmentSlot.CHEST, MaterialType.ULTIMATE).setPotion(true);
        ABSORPTION = new AbilityData("minecraft:absorption", "ability.armorplus.absorption.name", EntityEquipmentSlot.CHEST, MaterialType.INFUSED_LAVA).setPotion(true);
        WITHER_PROOF = new AbilityData("armorplus:wither_proof", "ability.armorplus.wither_proof.name", EntityEquipmentSlot.CHEST, new MaterialType[]{MaterialType.SUPER_STAR, MaterialType.ENDER_DRAGON, MaterialType.ULTIMATE}){

            @Override
            public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
                PotionEffect effect = player.func_70660_b(MobEffects.field_82731_v);
                if (effect != null) {
                    player.func_184589_d(MobEffects.field_82731_v);
                }
            }
        };
        FLIGHT = new AbilityData("armorplus:flight", "ability.armorplus.flight.name", EntityEquipmentSlot.CHEST, new MaterialType[]{MaterialType.ENDER_DRAGON, MaterialType.ULTIMATE}){

            @Override
            public void onSpecialArmorTick(ItemStack stack, World world, EntityPlayer player) {
                if (stack.func_77973_b() instanceof ItemArmorV2) {
                    ItemArmorV2 armor = (ItemArmorV2)stack.func_77973_b();
                    EntityEquipmentSlot slot = armor.func_185083_B_();
                    boolean contains = 2.contains(AbilityDataHandler.getHandler(stack), this);
                    ItemStack chestPlate = (ItemStack)player.field_71071_by.field_70460_b.get(2);
                    if (slot == EntityEquipmentSlot.CHEST && 2.canProvide(stack, this) && contains || player.field_71075_bZ.field_75098_d || player.func_175149_v()) {
                        player.field_71075_bZ.field_75101_c = true;
                    } else if (!contains || chestPlate.func_190926_b()) {
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75101_c = false;
                    }
                }
            }
        };
        STEP_ASSIST = new AbilityData("armorplus:step_assist", "ability.armorplus.step_assist.name", EntityEquipmentSlot.LEGS, MaterialType.REDSTONE, MaterialType.SUPER_STAR);
        BONUS_XP_ON_KILL = new AbilityData("armorplus:bonus_xp_on_kill", "ability.armorplus.bonus_xp_on_kill.name", EntityEquipmentSlot.CHEST, new MaterialType[]{MaterialType.COAL, MaterialType.LAPIS, MaterialType.EMERALD}){

            @Override
            public void onPlayerKillEntity(ItemStack stack, LivingDeathEvent event) {
                Entity entity = event.getEntity();
                entity.field_70170_p.func_72838_d((Entity)new EntityXPOrb(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, 1 + entity.field_70170_p.field_73012_v.nextInt(4)));
            }
        };
        WALK_ON_LAVA = new AbilityData("armorplus:walk_on_lava", "ability.armorplus.walk_on_lava.name", EntityEquipmentSlot.FEET, new MaterialType[]{MaterialType.INFUSED_LAVA}){

            @Override
            public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
                if (player.field_70122_E) {
                    player.func_70066_B();
                    float area = Math.min(16, 1);
                    BlockPos.MutableBlockPos firstPos = new BlockPos.MutableBlockPos(0, 0, 0);
                    BlockPos pos = new BlockPos((Entity)player);
                    for (BlockPos.MutableBlockPos posB : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-area), -1.0, (double)(-area)), (BlockPos)pos.func_177963_a((double)area, -1.0, (double)area))) {
                        IBlockState secondaryState;
                        if (!(posB.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= (double)(area * area))) continue;
                        firstPos.func_181079_c(posB.func_177958_n(), posB.func_177956_o() + 1, posB.func_177952_p());
                        IBlockState firstState = world.func_180495_p((BlockPos)firstPos);
                        if (firstState.func_185904_a() != Material.field_151579_a || (secondaryState = world.func_180495_p((BlockPos)posB)).func_185904_a() != Material.field_151587_i || secondaryState.func_177230_c() != Blocks.field_150353_l && secondaryState.func_177230_c() != Blocks.field_150356_k || (Integer)secondaryState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !world.func_190527_a((Block)ModBlocks.blockMeltingObsidian, (BlockPos)posB, false, EnumFacing.DOWN, null)) continue;
                        world.func_175656_a((BlockPos)posB, ModBlocks.blockMeltingObsidian.func_176223_P());
                        world.func_175684_a(posB.func_185334_h(), (Block)ModBlocks.blockMeltingObsidian, MathHelper.func_76136_a((Random)player.func_70681_au(), (int)60, (int)120));
                    }
                }
            }
        };
        SWIMMING_SPEED = new AbilityData("armorplus:swimming_speed", "ability.armorplus.swimming_speed.name", EntityEquipmentSlot.FEET, new MaterialType[]{MaterialType.GUARDIAN}){
            private static final double MULTIPLIER = 1.2;
            private static final double MAX_SPEED = 1.3;

            @Override
            public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
                if (player.func_70055_a(Material.field_151586_h)) {
                    double motionX = player.field_70159_w * 1.2;
                    double motionY = player.field_70181_x * 1.2;
                    double motionZ = player.field_70179_y * 1.2;
                    boolean flying = player.field_71075_bZ.field_75100_b;
                    if (!flying) {
                        if (Math.abs(motionX) < 1.3) {
                            player.field_70159_w = motionX;
                        }
                        if (Math.abs(motionY) < 1.3) {
                            player.field_70181_x = motionY;
                        }
                        if (Math.abs(motionZ) < 1.3) {
                            player.field_70179_y = motionZ;
                        }
                    }
                }
            }
        };
    }
}

