/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import wanion.unidict.common.Reference;

public final class Config {
    public static final Config INSTANCE = new Config();
    public final boolean libraryMode;
    public final boolean keepOneEntry;
    public final boolean registerNewCraftingIngredientsAsItemStacks;
    public final Set<String> keepOneEntryModBlackSet;
    public final Set<String> keepOneEntryKindBlackSet;
    public final Set<String> keepOneEntryEntryBlackSet;
    public final List<String> itemStacksNamesToIgnore;
    public final List<ItemStack> itemStacksToIgnore = new ArrayList<ItemStack>();
    public final boolean keepOneEntryBlackListsAsWhiteLists;
    public final boolean autoHideInJEI;
    public final Set<String> hideInJEIKindBlackSet;
    public final Set<String> hideInJEIEntryBlackSet;
    public final boolean kindsDump;
    public final boolean entriesDump;
    public final boolean unifiedEntriesDump;
    public final boolean inputReplacementFurnace;
    public final boolean inputReplacementMekanism;
    public final boolean enableSpecificKindSort;
    public final boolean enableSpecificEntrySort;
    public final TObjectIntMap<String> ownerOfEveryThing;
    public final Set<String> metalsToUnify;
    public final Set<String> childrenOfMetals;
    public final List<String> resourceBlackList;
    public final Set<ResourceLocation> recipesToIgnore;
    public final List<String> furnaceInputsToIgnore;
    public final List<String> furnaceOutputsToIgnore;
    public final List<ResourceLocation> recipesToRemove;
    public final Set<String> ignoreModIdRecipes;
    public final Map<String, Set<String>> customUnifiedResources;
    public final boolean ieIntegrationDuplicateRemoval;
    public final List<String> userOreDictEntries;
    public final boolean integrationModule;
    private final Configuration config;
    private final String resources = "resources";

    private Config() {
        boolean deleted = false;
        this.config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "UniDict" + ".cfg"), "1.12.2-2.9.6");
        try {
            int separator;
            if (!this.config.getDefinedConfigVersion().equals(this.config.getLoadedConfigVersion())) {
                deleted = this.config.getConfigFile().delete();
            }
            String general = "general";
            this.libraryMode = this.config.getBoolean("libraryMode", "general", false, "Enable this if you have mods that depends on UniDict but you don't like the unification.");
            this.keepOneEntry = this.config.getBoolean("keepOneEntry", "general", false, "keep only one entry per ore dict entry?");
            this.keepOneEntryModBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryModBlackList", "general", new String[0], "mods listed here will be blacklisted in keepOneEntry.\nmust be the exact modID."))));
            this.keepOneEntryKindBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryKindBlackList", "general", new String[0], "kinds listed here will be blacklisted in keepOneEntry.\nmust be the exact kind name."))));
            this.keepOneEntryEntryBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryEntryBlackList", "general", new String[0], "entries listed here will be blacklisted in keepOneEntry.\nmust be the exact entry name."))));
            this.keepOneEntryBlackListsAsWhiteLists = this.config.getBoolean("keepOneEntryBlackListsAsWhiteLists", "general", false, "enable this if you want the keepOneEntry blacklists to became whitelists.\nNote: this doesn't applies for \"S:keepOneEntryModBlackSet\"");
            this.itemStacksNamesToIgnore = Arrays.asList(this.config.getStringList("itemStacksNamesToIgnore", "general", new String[0], "Put here itemstacks that you want to ignore/not unify.\nExample Format: minecraft:iron_ingot#0"));
            this.registerNewCraftingIngredientsAsItemStacks = this.config.getBoolean("registerNewCraftingIngredientsAsItemStacks", "general", false, "If Enabled, the ingredients of all the new recipes created by Crafting Integration will be registered as ItemStacks.\nEnable this if you don't like the cycling through the possibilities of JEI.");
            this.autoHideInJEI = this.config.getBoolean("autoHideInJEI", "general", true, "auto hide items in JEI?") && Loader.isModLoaded((String)"jei");
            this.hideInJEIKindBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIKindBlackList", "general", new String[]{"ore"}, "put here kinds that you don't want to hide in JEI.\nonly works if keepOneEntry is false."))));
            this.hideInJEIEntryBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIEntryBlackList", "general", new String[0], "put here entries that you don't want to hide in JEI.\nonly works if keepOneEntry is false."))));
            this.kindsDump = this.config.getBoolean("kindsDump", "dump", false, "Enable this to keep track of all the kinds.\nthe output file will be saved on \"config\\unidict\\dump\" folder.\nonce the file is generated, you must delete it to re-generate.");
            this.entriesDump = this.config.getBoolean("entriesDump", "dump", false, "Enable this to keep track of all the entries.\nthe output file will be saved on \"config\\unidict\\dump\"  folder.\nonce the file is generated, you must delete it to re-generate.");
            this.unifiedEntriesDump = this.config.getBoolean("unifiedEntriesDump", "dump", false, "Enable this to keep track of all the unificated entries.\nthe output file will be saved on \"config\\unidict\\dump\" folder.\nonce the file is generated, you must delete it to re-generate.");
            this.inputReplacementFurnace = this.config.getBoolean("furnace", "inputReplacement", false, "Enabling this will remove all non-standard items as input of the Furnace.");
            this.inputReplacementMekanism = this.config.getBoolean("mekanism", "inputReplacement", false, "Enabling this will remove all non-standard items as input of Mekanism Machine Recipes.");
            this.enableSpecificKindSort = this.config.getBoolean("enableSpecificKindSort", "resources", false, "enabling this allow you to specify the \"owner\" of each kind.\nit also will make \"S:ownerOfEveryThing\" be ignored for this kind.\nexample: \"ore\"\n");
            this.enableSpecificEntrySort = this.config.getBoolean("enableSpecificEntrySort", "resources", false, "enabling this allow you to specify the \"owner\" of each entry.\nit also will make \"S:ownerOfEveryThing\" be ignored for this entry.\nexample: \"ingotIron\"\n");
            this.ownerOfEveryThing = new TObjectIntHashMap(this.getOwnerOfEveryThingMap());
            this.metalsToUnify = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("metalsToUnify", "resources", new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Zinc", "Aluminium", "Aluminum", "Alumina", "Chromium", "Chrome", "Uranium", "Iridium", "Osmium", "Bronze", "Steel", "Brass", "Invar", "Electrum", "Cupronickel", "Constantan"}, "List of Metals to unify.\nNote 1: this will only work for \"metals\"\nNote 2: if your \"metal\" doesn't have an ingot form, check the \"S:customUnifiedResources\" config option.\n"))));
            this.childrenOfMetals = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("childrenOfMetals", "resources", new String[]{"ore", "dustTiny", "dustSmall", "chunk", "dust", "nugget", "ingot", "block", "plate", "gear", "rod"}, "what kind of child do you want to make a standard?\n"))));
            this.resourceBlackList = Arrays.asList(this.config.getStringList("resourceBlackList", "resources", new String[]{"Aluminium", "Alumina", "Chrome", "Redstone"}, "resources to be black-listed.\nthis exists to avoid duplicates.\nthis affect the API."));
            this.recipesToIgnore = new HashSet<ResourceLocation>();
            for (String recipeToIgnore : this.config.getStringList("recipeToIgnoreList", "resources", new String[]{"minecraft:iron_nugget", "minecraft:iron_block", "minecraft:iron_ingot_from_block", "minecraft:iron_ingot_from_nuggets", "minecraft:gold_nugget", "minecraft:gold_ingot_from_block", "minecraft:gold_ingot_from_nuggets", "minecraft:gold_block"}, "add here recipes (names) that you don't want the Crafting Integration to mess with.")) {
                separator = recipeToIgnore.indexOf(58);
                if (separator <= 0) continue;
                this.recipesToIgnore.add(new ResourceLocation(recipeToIgnore.substring(0, separator), recipeToIgnore.substring(separator + 1, recipeToIgnore.length())));
            }
            this.furnaceInputsToIgnore = Arrays.asList(this.config.getStringList("furnaceInputsToIgnore", "resources", new String[]{""}, "Add here input ItemStack's (item registry names) that you don't want the Furnace Integration to mess with.\nFormat:\nminecraft:iron_ingot#0"));
            this.furnaceOutputsToIgnore = Arrays.asList(this.config.getStringList("furnaceOutputsToIgnore", "resources", new String[]{""}, "Add here output ItemStack's (item registry names) that you don't want the Furnace Integration to mess with.\nFormat:\nminecraft:iron_ingot#0"));
            this.ieIntegrationDuplicateRemoval = this.config.getBoolean("ieIntegrationDuplicateRemoval", "integrations", true, "this controls if duplicate check & removal of duplicates on Immersive Engineering Integration.");
            this.recipesToRemove = new ArrayList<ResourceLocation>();
            for (String recipeToRemove : this.config.getStringList("recipeToRemoveList", "resources", new String[0], "add here recipes (names) that you want to be removed.\nnote: this will be executed after Crafting Integration.\nnote 2: if there is a space on the end of the recipe, then the recipe name must stay in \"recipename\", this is ONLY required when there is a space on the end \" \"")) {
                separator = (recipeToRemove = recipeToRemove.replace("\"", "")).indexOf(58);
                if (separator <= 0) continue;
                this.recipesToRemove.add(new ResourceLocation(recipeToRemove.substring(0, separator), recipeToRemove.substring(separator + 1, recipeToRemove.length())));
            }
            this.ignoreModIdRecipes = new LinkedHashSet<String>(Arrays.asList(this.config.getStringList("ignoreModIdRecipes", "resources", new String[]{"oreshrubs"}, "Crafting Integration will ignore recipes created by the ModId's listed below.\n")));
            this.customUnifiedResources = Collections.unmodifiableMap(this.getCustomUnifiedResourcesMap());
            this.userOreDictEntries = Arrays.asList(this.config.getStringList("userOreDictEntries", "general", new String[0], "This allows to the user add/remove entries before the Unification happen.\nthis is mainly useful to avoid trying to unify certain things.\n\nFormat to Add entries to the OreDictionary:\nweirdStone+minecraft:stone#1\nThe example above will register Granite as weirdStone.\n\nFormat to Remove entries from the OreDictionary:\nweirdStone-minecraft:stone#1\nThe example above will remove Granite from weirdStone."));
            this.integrationModule = this.config.getBoolean("integration", "modules", true, "Integration Module.\nif false all the Integrations will be disabled.\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong on " + this.config.getConfigFile() + " loading. " + e);
        }
        if (this.config.hasChanged() || deleted) {
            this.config.save();
        }
    }

    public void saveIfHasChanged() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private TObjectIntMap<String> getOwnerOfEveryThingMap() {
        String[] ownerOfEveryThing = this.config.getStringList("ownerOfEveryThing", "resources", new String[]{"minecraft", "thermalfoundation", "substratum", "ic2", "mekanism", "immersiveengineering", "techreborn"}, "all the entries will be sorted according to the modID list below\nmust be the exact modID.\n");
        TObjectIntHashMap ownerOfEveryThingMap = new TObjectIntHashMap(10, 1.0f, Integer.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryThing.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryThing[i], i);
        }
        return ownerOfEveryThingMap;
    }

    private Map<String, Set<String>> getCustomUnifiedResourcesMap() {
        THashMap customUnifiedResources = new THashMap();
        Pattern splitPattern = Pattern.compile("\\|");
        for (String customUnifiedResource : this.config.getStringList("customUnifiedResources", "resources", new String[]{"Obsidian:dustTiny|dust", "Stone:dust", "Obsidian:dust|dustSmall", "Coal:dust|dustSmall", "Sulfur:dust|dustSmall", "Salt:dust"}, "Here you can put a list to custom unify them.\nmust be in this format \"ResourceName:kind1|kind2|...\".")) {
            HashSet kindSet;
            int baseSeparatorIndex = customUnifiedResource.indexOf(58);
            if (baseSeparatorIndex == -1 || (kindSet = Sets.newHashSet(Arrays.asList(splitPattern.split(customUnifiedResource.substring(baseSeparatorIndex + 1, customUnifiedResource.length()))))).isEmpty()) continue;
            customUnifiedResources.put(customUnifiedResource.substring(0, baseSeparatorIndex), kindSet);
        }
        return customUnifiedResources;
    }
}

