/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive.gui;

import com.creativemd.creativecore.CreativeCore;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiProgressBar;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.playerrevive.PlayerRevive;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.client.ReviveEventClient;
import com.creativemd.playerrevive.gui.SubContainerRevive;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public class SubGuiRevive
extends SubGui {
    public GuiProgressBar bar;
    public GuiLabel label;

    public SubGuiRevive() {
        super(200, 140);
        this.setStyle(Style.emptyStyle);
    }

    public void createControls() {
        IRevival revive = ((SubContainerRevive)this.container).revive;
        this.bar = (GuiProgressBar)new GuiProgressBar("progress", 50, 0, 94, 13, (double)PlayerRevive.CONFIG.playerReviveTime, (double)revive.getProgress()).setStyle(defaultStyle);
        this.controls.add(this.bar);
        this.label = new GuiLabel(I18n.func_74837_a((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(revive.getTimeLeft())}), 50, 20);
        this.controls.add(this.label);
        if (!((SubContainerRevive)this.container).isHelping) {
            if (!PlayerRevive.CONFIG.disableGiveUp) {
                this.controls.add(new GuiButton(I18n.func_74838_a((String)"playerrevive.gui.button.give_up"), 80, 80){

                    public void onClicked(int x, int y, int button) {
                        SubGuiRevive.this.openYesNoDialog(I18n.func_74838_a((String)"playerrevive.gui.popup.give_up"));
                    }
                });
            }
            if (!PlayerRevive.CONFIG.disableDisconnect) {
                this.controls.add(new GuiButton(I18n.func_74838_a((String)"playerrevive.gui.button.disconnect"), 70, 100){

                    public void onClicked(int x, int y, int button) {
                        SubGuiRevive.this.openYesNoDialog(I18n.func_74838_a((String)"playerrevive.gui.popup.disconnect"));
                    }
                });
            }
            GuiTextfield chat = new GuiTextfield("chat", "", 0, 120, 160, 10);
            chat.maxLength = 256;
            this.controls.add(chat.setStyle(Style.liteStyle));
            this.controls.add(new GuiButton(I18n.func_74838_a((String)"playerrevive.gui.button.send"), 170, 120, 23, 10){

                public void onClicked(int x, int y, int button) {
                    GuiTextfield chat = (GuiTextfield)SubGuiRevive.this.get("chat");
                    if (!chat.text.equals("")) {
                        SubGuiRevive.this.gui.sendChatMessage(chat.text);
                        chat.setSelectionPos(0);
                        chat.selEnd = 0;
                        chat.cursorPosition = 0;
                        chat.text = "";
                    }
                }
            }.setStyle(Style.liteStyle));
            if (!PlayerRevive.CONFIG.disableMusic) {
                this.controls.add(new GuiAnalogeSlider("volume", 160, 0, 40, 10, (double)PlayerRevive.CONFIG.volumeModifier, 0.0, 1.0).setStyle(Style.liteStyle));
            }
        }
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
        if (clicked.equals("Yes")) {
            if (text.equals(I18n.func_74838_a((String)"playerrevive.gui.popup.give_up"))) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("giveup", true);
                this.sendPacketToServer(nbt);
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71441_e.func_72882_A();
                mc.func_71403_a((WorldClient)null);
                mc.func_147108_a((GuiScreen)new GuiMainMenu());
            }
        }
    }

    public boolean onKeyPressed(char character, int key) {
        if (!((SubContainerRevive)this.container).isHelping && key == 28) {
            GuiTextfield chat = (GuiTextfield)this.get("chat");
            if (!chat.text.equals("")) {
                this.gui.sendChatMessage(chat.text);
                chat.setSelectionPos(0);
                chat.selEnd = 0;
                chat.cursorPosition = 0;
                chat.text = "";
            }
            return true;
        }
        return super.onKeyPressed(character, key);
    }

    public String formatTime(int timeLeft) {
        int lengthOfMinute = 1200;
        int lengthOfHour = lengthOfMinute * 60;
        int hours = timeLeft / lengthOfHour;
        int minutes = (timeLeft -= hours * lengthOfHour) / lengthOfMinute;
        int seconds = (timeLeft -= minutes * lengthOfMinute) / 20;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @CustomEventSubscribe
    public void controlChanged(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"volume"})) {
            PlayerRevive.CONFIG.volumeModifier = (float)((GuiAnalogeSlider)event.source).value;
            if (ReviveEventClient.sound != null) {
                ReviveEventClient.sound.volume = PlayerRevive.CONFIG.volumeModifier;
            }
        }
    }

    public void onClosed() {
        CreativeCore.configHandler.save("playerrevive", Side.CLIENT);
    }

    public void onTick() {
        double timer = 1.0E7;
        IRevival revive = ((SubContainerRevive)this.container).revive;
        if (revive != null && revive.getTimeLeft() < 400) {
            timer = 1000000.0;
        }
        double value = Math.cos(Math.toRadians((double)System.nanoTime() / timer)) * 0.5 + 0.5;
        this.label.color = ColorUtils.VecToInt((Vec3d)new Vec3d(1.0, value, value));
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        IRevival revive = ((SubContainerRevive)this.container).revive;
        if (revive != null) {
            revive.deserializeNBT((NBTBase)nbt);
            this.bar.pos = revive.getProgress();
            this.label.caption = I18n.func_74837_a((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(revive.getTimeLeft())});
        }
    }

    public void closeGui() {
        if (((SubContainerRevive)this.container).isHelping) {
            super.closeGui();
        }
    }

    public boolean hasGrayBackground() {
        return false;
    }
}

