/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive.server;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.playerrevive.PlayerRevive;
import com.creativemd.playerrevive.api.CombatTrackerClone;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.api.capability.CapaRevive;
import com.creativemd.playerrevive.api.event.PlayerKilledEvent;
import com.creativemd.playerrevive.api.event.PlayerRevivedEvent;
import com.creativemd.playerrevive.packet.ReviveUpdatePacket;
import com.creativemd.playerrevive.server.ReviveEventServer;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerReviveServer {
    public static boolean isPlayerBleeding(EntityPlayer player) {
        return !((IRevival)player.getCapability(CapaRevive.reviveCapa, null)).isHealty();
    }

    public static void sendUpdatePacket(EntityPlayer player) {
        ReviveUpdatePacket packet = new ReviveUpdatePacket(player);
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)packet, (EntityPlayerMP)((EntityPlayerMP)player));
        PacketHandler.sendPacketToPlayer((CreativeCorePacket)packet, (EntityPlayerMP)((EntityPlayerMP)player));
    }

    public static void startBleeding(EntityPlayer player, DamageSource source) {
        PlayerReviveServer.getRevival(player).startBleeding(player, source);
        PlayerReviveServer.sendUpdatePacket(player);
    }

    private static void resetPlayer(EntityPlayer player, IRevival revive) {
        player.field_71075_bZ.field_75102_a = player.field_71075_bZ.field_75098_d;
        player.func_184224_h(false);
        for (int i = 0; i < revive.getRevivingPlayers().size(); ++i) {
            revive.getRevivingPlayers().get(i).func_71053_j();
        }
    }

    public static void revive(EntityPlayer player) {
        IRevival revive = PlayerReviveServer.getRevival(player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerRevivedEvent(player, revive));
        revive.stopBleeding();
        PlayerReviveServer.resetPlayer(player, revive);
        if (!PlayerRevive.CONFIG.disableSounds) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), PlayerRevive.revivedSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void kill(EntityPlayer player) {
        IRevival revive = PlayerReviveServer.getRevival(player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerKilledEvent(player, revive));
        DamageSource source = revive.getSource();
        CombatTrackerClone trackerClone = revive.getTrackerClone();
        trackerClone.overwriteTracker(player.func_110142_aN());
        revive.kill();
        player.func_70606_j(0.0f);
        player.func_70645_a(source);
        PlayerReviveServer.resetPlayer(player, revive);
        if (!PlayerRevive.CONFIG.disableSounds) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), PlayerRevive.deathSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (PlayerRevive.CONFIG.banPlayerAfterDeath) {
            GameProfile profile = null;
            profile = player.func_146103_bH();
            player.func_184102_h().func_184103_al().func_152608_h().func_152687_a((UserListEntry)new UserListBansEntry(player.func_146103_bH()));
            try {
                player.func_184102_h().func_184103_al().func_152608_h().func_152678_f();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static IRevival getRevival(EntityPlayer player) {
        return (IRevival)player.getCapability(CapaRevive.reviveCapa, null);
    }

    public static void removePlayerAsHelper(EntityPlayer player) {
        for (EntityPlayerMP member : ReviveEventServer.getMinecraftServer().func_184103_al().func_181057_v()) {
            IRevival revive = PlayerReviveServer.getRevival((EntityPlayer)member);
            revive.getRevivingPlayers().remove(player);
        }
    }

    public void loadSide() {
    }
}

