/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.block;

import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.block.IBABlock;
import arcaratus.bloodarsenal.tile.TileBloodCapacitor;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBloodCapacitor
extends Block
implements IVariantProvider,
IBABlock {
    public BlockBloodCapacitor(String name) {
        super(Material.field_151573_f);
        this.func_149663_c("bloodarsenal." + name);
        this.setRegistryName(name);
        this.func_149647_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.func_149711_c(5.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodCapacitor) {
            TileBloodCapacitor capacitor = (TileBloodCapacitor)tile;
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.energy", (Object[])new Object[]{capacitor.getEnergyStored()})), true);
            }
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState blockState) {
        return new TileBloodCapacitor();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        TileBloodCapacitor capacitor = (TileBloodCapacitor)world.func_175625_s(pos);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            capacitor.amountRecv = tag.func_74762_e("Recv");
            capacitor.amountSend = tag.func_74762_e("Send");
            capacitor.setEnergyStored(tag.func_74762_e("Stored"));
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(worldIn, pos, state, 0);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodCapacitor) {
            TileBloodCapacitor capacitor = (TileBloodCapacitor)tile;
            ItemStack drop = new ItemStack((Block)this);
            NBTTagCompound energyTag = new NBTTagCompound();
            energyTag.func_74768_a("Recv", capacitor.amountRecv);
            energyTag.func_74768_a("Send", capacitor.amountSend);
            energyTag.func_74768_a("Stored", capacitor.getEnergyStored());
            drop.func_77982_d(energyTag);
            drops.add((Object)drop);
        }
    }
}

