/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.compat.jei.infusion;

import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.compat.jei.BloodArsenalPlugin;
import arcaratus.bloodarsenal.recipe.RecipeSanguineInfusion;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class SanguineInfusionRecipeJEI
implements IRecipeWrapper {
    private RecipeSanguineInfusion recipe;
    private final String[] infoString;
    private int level = 0;

    public SanguineInfusionRecipeJEI(RecipeSanguineInfusion recipe) {
        this.recipe = recipe;
        this.infoString = recipe.isModifier() ? new String[]{"jei.bloodarsenal.recipe.required_LP", TextHelper.localize((String)recipe.getModifier().getUnlocalizedName(), (Object[])new Object[0]), "jei.bloodarsenal.recipe.modifier_level"} : new String[]{TextHelper.localize((String)"jei.bloodarsenal.recipe.required_LP", (Object[])new Object[]{recipe.getLpCost()})};
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        List expandedInputs = BloodArsenalPlugin.jeiHelper.getStackHelper().expandRecipeItemStackInputs(this.recipe.getItemStackInputs(0));
        if (this.recipe.isModifier()) {
            expandedInputs.add(BloodArsenalPlugin.modifiables);
        } else {
            expandedInputs.add(0, Lists.newArrayList((Object[])new ItemStack[]{this.recipe.getInfuse()}));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, expandedInputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput());
    }

    public RecipeSanguineInfusion getRecipe() {
        return this.recipe;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.recipe.isModifier()) {
            minecraft.field_71466_p.func_78276_b(TextHelper.localize((String)this.infoString[0], (Object[])new Object[]{(this.level + 1) * this.recipe.getLpCost()}), 110 - minecraft.field_71466_p.func_78256_a(TextHelper.localize((String)this.infoString[0], (Object[])new Object[]{(this.level + 1) * this.recipe.getLpCost()})) / 2, 40, Color.gray.getRGB());
            minecraft.field_71466_p.func_78276_b(this.infoString[1], 10 - minecraft.field_71466_p.func_78256_a(this.infoString[1]) / 2, 4, Color.gray.getRGB());
            minecraft.field_71466_p.func_78276_b(TextHelper.localize((String)this.infoString[2], (Object[])new Object[]{this.level == -1 ? 1 : this.level + 1}), 10 - minecraft.field_71466_p.func_78256_a(TextHelper.localize((String)this.infoString[2], (Object[])new Object[]{this.level + 1})) / 2, 14, Color.gray.getRGB());
        } else {
            minecraft.field_71466_p.func_78276_b(this.infoString[0], 110 - minecraft.field_71466_p.func_78256_a(this.infoString[0]) / 2, 40, Color.gray.getRGB());
        }
    }
}

