/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.compat.tconstruct;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.iface.ISentientSwordEffectProvider;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDemonWill;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import arcaratus.bloodarsenal.compat.tconstruct.TConstructPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ModifierSentience
extends ModifierTrait {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0};
    public static double[] destructiveDamageAdded = new double[]{1.5, 2.25, 3.0, 3.75, 4.5, 5.25, 6.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] defaultDigSpeedAdded = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.25};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600, 700, 800};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100, 120, 150};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};

    public ModifierSentience() {
        super("sentience", 7075582, 2, 1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private int getLevel(ItemStack tool) {
        return ModifierNBT.readInteger((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)tool, (String)this.getModifierIdentifier())).level;
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer) {
            double drain;
            EntityPlayer player = (EntityPlayer)entity;
            EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType((EntityPlayer)player);
            double will = PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (EntityPlayer)player);
            this.setCurrentType(tool, will > 0.0 ? type : EnumDemonWillType.DEFAULT);
            int willBracket = this.getWillLevel(will);
            double d = drain = willBracket >= 0 ? soulDrainPerSwing[willBracket] : 0.0;
            if (this.getLevel(tool) > 1) {
                ToolNBT toolData = TagUtil.getOriginalToolStats((NBTTagCompound)tool.func_77978_p());
                float attack = toolData.attack;
                NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)tool.func_77978_p());
                attack = (float)((double)attack + this.getExtraDamage(type, willBracket));
                tag.func_74776_a("Attack", attack);
            }
            this.setDrainOfActivatedSword(tool, drain);
            this.setStaticDropOfActivatedSword(tool, willBracket >= 0 ? staticDrop[willBracket] : 1.0);
            this.setDropOfActivatedSword(tool, willBracket >= 0 ? soulDrop[willBracket] : 0.0);
        }
    }

    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        if (this.getLevel(tool) > 1 && player instanceof EntityPlayer) {
            ISentientSwordEffectProvider provider;
            EntityPlayer attackerPlayer = (EntityPlayer)player;
            EnumDemonWillType type = this.getCurrentType(tool);
            double will = PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (EntityPlayer)attackerPlayer);
            int willBracket = this.getWillLevel(will);
            this.applyEffectToEntity(type, willBracket, target, (EntityLivingBase)attackerPlayer);
            ItemStack offStack = attackerPlayer.func_184582_a(EntityEquipmentSlot.OFFHAND);
            if (offStack.func_77973_b() instanceof ISentientSwordEffectProvider && (provider = (ISentientSwordEffectProvider)offStack.func_77973_b()).providesEffectForWill(type)) {
                provider.applyOnHitEffect(type, tool, offStack, target, target);
            }
        }
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (this.getLevel(tool) > 1 && player instanceof EntityPlayer) {
            EnumDemonWillType type;
            double soulsRemaining;
            EntityPlayer actualPlayer = (EntityPlayer)player;
            double drain = this.getDrainOfActivatedSword(tool);
            if (drain > 0.0 && drain <= (soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)(type = this.getCurrentType(tool)), (EntityPlayer)actualPlayer))) {
                PlayerDemonWillHandler.consumeDemonWill((EnumDemonWillType)type, (EntityPlayer)actualPlayer, (double)drain);
            }
        }
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (this.getLevel(tool) > 1) {
            float speed = ToolHelper.getActualMiningSpeed((ItemStack)tool);
            EnumDemonWillType type = this.getCurrentType(tool);
            double will = PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (EntityPlayer)event.getEntityPlayer());
            int willBracket = this.getWillLevel(will);
            speed = (float)((double)speed + defaultDigSpeedAdded[willBracket]);
            event.setNewSpeed(speed);
        }
    }

    private int getWillLevel(double soulsRemaining) {
        int lvl = 0;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, EntityLivingBase target, EntityLivingBase attacker) {
        switch (type) {
            case CORROSIVE: {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.func_70089_S()) break;
                float absorption = attacker.func_110139_bj();
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76444_x, absorptionTime[willBracket], 127));
                attacker.func_110149_m((float)Math.min((double)(absorption + target.func_110138_aP() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public List<ItemStack> getRandomDemonWillDrop(EntityLivingBase killedEntity, EntityLivingBase attackingEntity, ItemStack stack, int looting) {
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && !(killedEntity instanceof IMob)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof EntitySlime ? 0.67 : 1.0;
        IDemonWill soul = (IDemonWill)RegistrarBloodMagicItems.MONSTER_SOUL;
        EnumDemonWillType type = this.getCurrentType(stack);
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.func_130014_f_().field_73012_v.nextDouble() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(type.ordinal(), willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.func_130014_f_().field_73012_v.nextDouble() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.func_110138_aP() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf((String)tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDrop", drop);
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        List<ItemStack> droppedSouls;
        EntityPlayer player;
        ItemStack heldStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && TinkerUtil.getModifiers((ItemStack)(heldStack = (player = (EntityPlayer)entity).func_184614_ca())).contains((Object)TConstructPlugin.MODIFIER_SENTIENCE) && !player.func_130014_f_().field_72995_K && !(droppedSouls = this.getRandomDemonWillDrop(attackedEntity, (EntityLivingBase)player, heldStack, event.getLootingLevel())).isEmpty()) {
            for (ItemStack willStack : droppedSouls) {
                ItemStack remainder = PlayerDemonWillHandler.addDemonWill((EntityPlayer)player, (ItemStack)willStack);
                if (remainder.func_190926_b()) continue;
                EnumDemonWillType pickupType = ((IDemonWill)remainder.func_77973_b()).getType(remainder);
                if (!(((IDemonWill)remainder.func_77973_b()).getWill(pickupType, remainder) >= 1.0E-4)) continue;
                event.getDrops().add(new EntityItem(attackedEntity.func_130014_f_(), attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, remainder));
            }
            player.field_71069_bz.func_75142_b();
        }
    }
}

