/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.entity.projectile;

import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import arcaratus.bloodarsenal.util.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityWarpBlade
extends EntityThrowable
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    public EntityPlayer player;
    protected int field_70195_i = 0;
    protected int maxTicksInAir = 40;
    private ItemStack stack = ItemStack.field_190927_a;

    public EntityWarpBlade(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.0f);
    }

    public EntityWarpBlade(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityWarpBlade(World world, EntityPlayer player, ItemStack stack) {
        super(world, (EntityLivingBase)player);
        this.player = player;
        this.stack = stack;
        this.func_70105_a(0.6f, 1.0f);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && (this.player == null || this.player.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        RayTraceResult look = BloodArsenalUtils.rayTrace(this.func_130014_f_(), this.player, true);
        Vector3 playerLook = look == null ? new Vector3(this.player.func_70040_Z()).multiply(64.0).add(Vector3.fromEntity((Entity)this.player)) : new Vector3((double)look.func_178782_a().func_177958_n() + 0.5, (double)look.func_178782_a().func_177956_o() + 0.5, (double)look.func_178782_a().func_177952_p() + 0.5);
        Vector3 thisVec = Vector3.fromEntityCenter((Entity)this);
        Vector3 motionVec = playerLook.subtract(thisVec).normalize().multiply(1.5);
        this.field_70159_w = motionVec.x;
        this.field_70181_x = motionVec.y;
        this.field_70179_y = motionVec.z;
        if (!ItemStack.func_185132_d((ItemStack)this.getStack(), (ItemStack)this.player.func_184614_ca()) || this.field_70173_aa > this.maxTicksInAir) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (mop.field_72308_g != this.player) {
            if (mop.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)mop.field_72308_g).func_70604_c((EntityLivingBase)this.player);
                this.player.func_71059_n(mop.field_72308_g);
                this.player.func_184595_k(mop.field_72308_g.field_70165_t, mop.field_72308_g.field_70163_u + (double)(mop.field_72308_g.field_70131_O / 2.0f), mop.field_72308_g.field_70161_v);
            } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.player.func_184595_k((double)mop.func_178782_a().func_177958_n(), (double)(mop.func_178782_a().func_177956_o() + 2), (double)mop.func_178782_a().func_177952_p());
            }
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.field_70195_i);
    }

    public void readSpawnData(ByteBuf data) {
        this.field_70195_i = data.readByte();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("projectileTicksInAir", this.field_70195_i);
        nbt.func_74768_a("projectileMaxTicksInAir", this.maxTicksInAir);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70195_i = nbt.func_74762_e("projectileTicksInAir");
        this.maxTicksInAir = nbt.func_74762_e("projectileMaxTicksInAir");
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.player = (EntityPlayer)entity;
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

