/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier;

import WayofTime.bloodmagic.iface.IActivatable;
import WayofTime.bloodmagic.util.Utils;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import arcaratus.bloodarsenal.registry.BloodArsenalSounds;
import arcaratus.bloodarsenal.registry.ModModifiers;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bloodarsenal")
public class TrackerHandler {
    private static Random rand = new Random();

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack modifiableStack;
        DamageSource source = event.getSource();
        Entity sourceEntity = source.func_76364_f();
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (sourceEntity instanceof EntityPlayer && (modifiableStack = (player = (EntityPlayer)sourceEntity).func_184614_ca()).func_77973_b() instanceof IActivatable && ((IActivatable)modifiableStack.func_77973_b()).getActivated(modifiableStack) && !modifiableStack.func_190926_b() && modifiableStack.func_77973_b() instanceof IModifiableItem) {
            float reducedAmount;
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(modifiableStack);
            float amount = Math.min(Utils.getModifiedDamage((EntityLivingBase)attackedEntity, (DamageSource)event.getSource(), (float)event.getAmount()), attackedEntity.func_110143_aJ());
            modifiable.checkAndIncrementTracker(modifiableStack, ModModifiers.MODIFIER_FLAME);
            if (modifiable.hasModifier(ModModifiers.MODIFIER_CRIT_STRIKER)) {
                int level = modifiable.getTrackerForModifier(ModModifiers.MODIFIER_CRIT_STRIKER).getLevel() + 1;
                if (rand.nextInt(10) < level) {
                    modifiable.incrementModifierTracker(modifiableStack, ModModifiers.MODIFIER_CRIT_STRIKER);
                    event.setAmount(amount * (1.0f + (float)level / 2.0f));
                    BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.crit", true);
                    player.func_184185_a(BloodArsenalSounds.SOUND_CRIT, 0.2f, 1.0f);
                }
            }
            if (modifiable.hasModifier(ModModifiers.MODIFIER_VAMPIRIC) && modifiable.checkAndIncrementTracker(modifiableStack, ModModifiers.MODIFIER_VAMPIRIC, reducedAmount = 1.0f + amount * ((float)modifiable.getTrackerForModifier(ModModifiers.MODIFIER_VAMPIRIC).getLevel() + 1.0f) / 10.0f)) {
                player.func_70691_i(reducedAmount);
            }
            reducedAmount = amount / 4.0f;
            modifiable.checkAndIncrementTracker(modifiableStack, ModModifiers.MODIFIER_BLOODLUST, reducedAmount);
            modifiable.checkAndIncrementTracker(modifiableStack, ModModifiers.MODIFIER_SHARPNESS, reducedAmount);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack modifiableStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (event.getLootingLevel() >= 1 && attackedEntity.func_94060_bK() instanceof EntityPlayer && !(modifiableStack = (player = (EntityPlayer)attackedEntity.func_94060_bK()).func_184614_ca()).func_190926_b() && modifiableStack.func_77973_b() instanceof IActivatable && ((IActivatable)modifiableStack.func_77973_b()).getActivated(modifiableStack) && modifiableStack.func_77973_b() instanceof IModifiableItem) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(modifiableStack);
            modifiable.checkAndIncrementTracker(modifiableStack, ModModifiers.MODIFIER_LOOTING);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingXPDrop(LivingExperienceDropEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getAttackingPlayer() != null && !(itemStack = (player = event.getAttackingPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IActivatable && ((IActivatable)itemStack.func_77973_b()).getActivated(itemStack) && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(itemStack)).hasModifier(ModModifiers.MODIFIER_XPERIENCED)) {
            ModifierTracker xpTracker = modifiable.getTrackerForModifier(ModModifiers.MODIFIER_XPERIENCED);
            event.setDroppedExperience(event.getOriginalExperience() * (rand.nextInt(xpTracker.getLevel() + 2) + 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onXPPickup(PlayerPickupXpEvent event) {
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getEntityPlayer() != null && !(itemStack = (player = event.getEntityPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IActivatable && ((IActivatable)itemStack.func_77973_b()).getActivated(itemStack) && itemStack.func_77973_b() instanceof IModifiableItem) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            modifiable.checkAndIncrementTracker(itemStack, ModModifiers.MODIFIER_XPERIENCED, (double)event.getOrb().func_70526_d() / 4.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getPlayer() != null && !(itemStack = (player = event.getPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IActivatable && ((IActivatable)itemStack.func_77973_b()).getActivated(itemStack) && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(itemStack)).hasModifier(ModModifiers.MODIFIER_XPERIENCED) && event.getExpToDrop() > 0) {
            ModifierTracker xpTracker = modifiable.getTrackerForModifier(ModModifiers.MODIFIER_XPERIENCED);
            event.setExpToDrop(event.getExpToDrop() * (rand.nextInt(xpTracker.getLevel() + 2) + 1));
        }
    }
}

