/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier.modifiers;

import arcaratus.bloodarsenal.modifier.EnumModifierType;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import arcaratus.bloodarsenal.registry.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;

public class ModifierBadPotion
extends Modifier {
    public ModifierBadPotion() {
        super("bad_potion", Constants.Modifiers.BAD_POTION_COUNTER.length, EnumModifierType.HEAD);
        this.setAltName();
    }

    @Override
    public String getAlternateName(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p().func_74779_i("itemStackName") : "\u4f55\u3060\u3088!";
    }

    @Override
    public void hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker, int level) {
        if (random.nextInt(level + 1) >= random.nextInt(this.getMaxLevel()) && itemStack.func_77942_o()) {
            NBTTagCompound data = itemStack.func_77978_p().func_74775_l("itemStack");
            Potion potion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)new ItemStack(data)).get(0)).func_188419_a();
            if (potion.func_76403_b()) {
                potion.func_180793_a((Entity)attacker, (Entity)attacker, target, level, 1.0);
            } else {
                target.func_70690_d(new PotionEffect(potion, 20 + 40 * (level + 1), level));
            }
            StasisModifiable.getModifiableFromStack(itemStack).incrementModifierTracker(itemStack, this);
        }
    }

    @Override
    public void writeSpecialNBT(ItemStack itemStack, ItemStack extra, int level) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagCompound potionTag = new NBTTagCompound();
        String potionName = "";
        if (!extra.func_190926_b() && extra.func_77973_b() instanceof ItemPotion) {
            extra.func_77955_b(potionTag);
            potionName = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)extra).get(0)).func_188419_a().func_76393_a();
        }
        tag.func_74782_a("itemStack", (NBTBase)potionTag);
        tag.func_74778_a("itemStackName", potionName);
    }

    @Override
    public NBTTagCompound getSpecialNBT(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagCompound specialTag = new NBTTagCompound();
        specialTag.func_74782_a("itemStack", tag.func_74781_a("itemStack"));
        specialTag.func_74778_a("itemStackName", tag.func_74779_i("itemStackName"));
        return specialTag;
    }

    @Override
    public void removeSpecialNBT(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o("itemStack");
            tag.func_82580_o("itemStackName");
        }
    }
}

