/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.ritual;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileBloodTank;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.block.BlockStasisPlate;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalBlocks;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalItems;
import arcaratus.bloodarsenal.item.types.EnumBaseTypes;
import arcaratus.bloodarsenal.ritual.RitualBloodArsenal;
import arcaratus.bloodarsenal.tile.TileStasisPlate;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import arcaratus.bloodarsenal.util.TriFunction;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@RitualRegister(value="blood_burner")
public class RitualBloodBurner
extends RitualBloodArsenal {
    public static Set<Item> IGNITERS = Sets.newHashSet((Object[])new Item[]{Items.field_151033_d});
    public static Set<Fluid> ACCEPTABLE_FLUIDS = Sets.newHashSet((Object[])new Fluid[]{FluidRegistry.LAVA, FluidRegistry.getFluid((String)"lifeEssence")});
    private static final Set<BlockPos> FIRE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, -1)});
    private static final Set<BlockPos> GLOWSTONE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(2, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(0, 1, 2), new BlockPos(0, 1, -2), new BlockPos(2, 1, 1), new BlockPos(2, 1, -1), new BlockPos(-2, 1, 1), new BlockPos(-2, 1, -1), new BlockPos(1, 1, 2), new BlockPos(1, 1, -2), new BlockPos(-1, 1, 2), new BlockPos(-1, 1, -2), new BlockPos(2, 1, 2), new BlockPos(2, 1, -2), new BlockPos(-2, 1, 2), new BlockPos(-2, 1, -2)});
    private static final Set<BlockPos> LAVA_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(3, 1, 1), new BlockPos(3, 1, -1), new BlockPos(-3, 1, 1), new BlockPos(-3, 1, -1), new BlockPos(3, 1, 2), new BlockPos(-3, 1, 2), new BlockPos(3, 1, -2), new BlockPos(-3, 1, -2), new BlockPos(1, 1, 3), new BlockPos(-1, 1, 3), new BlockPos(1, 1, -3), new BlockPos(-1, 1, -3), new BlockPos(2, 1, 3), new BlockPos(-2, 1, 3), new BlockPos(2, 1, -3), new BlockPos(-2, 1, -3)});
    private static final Set<BlockPos> LIFE_ESSENCE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(4, 1, 0), new BlockPos(-4, 1, 0), new BlockPos(0, 1, 4), new BlockPos(0, 1, -4), new BlockPos(4, 1, 2), new BlockPos(-4, 1, 2), new BlockPos(4, 1, -2), new BlockPos(-4, 1, -2), new BlockPos(2, 1, 4), new BlockPos(-2, 1, 4), new BlockPos(2, 1, -4), new BlockPos(-2, 1, -4), new BlockPos(4, 1, 4), new BlockPos(-4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, -4)});
    private static final Set<BlockPos> FIRING_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(6, 6, 6), new BlockPos(-6, 6, 6), new BlockPos(6, 6, -6), new BlockPos(-6, 6, -6), new BlockPos(5, 5, 6), new BlockPos(-5, 5, 6), new BlockPos(5, 5, -6), new BlockPos(-5, 5, -6), new BlockPos(6, 5, 5), new BlockPos(6, 5, -5), new BlockPos(-6, 5, 5), new BlockPos(-6, 5, -5), new BlockPos(5, 3, 6), new BlockPos(-5, 3, 6), new BlockPos(5, 3, -6), new BlockPos(-5, 3, -6), new BlockPos(6, 3, 5), new BlockPos(6, 3, -5), new BlockPos(-6, 3, 5), new BlockPos(-6, 3, -5), new BlockPos(5, 1, 6), new BlockPos(-5, 1, 6), new BlockPos(5, 1, -6), new BlockPos(-5, 1, -6), new BlockPos(6, 1, 5), new BlockPos(6, 1, -5), new BlockPos(-6, 1, 5), new BlockPos(-6, 1, -5)});
    private static final BiFunction<Integer, Integer, BiFunction<Integer, Integer, Integer>> TOTAL_RF = (a, g) -> (u, l) -> (int)((double)u.intValue() * 0.5 * (Math.pow(a.intValue(), 1.5) / 100.0 * ((double)g.intValue() + 1.0) + (double)(2 * l) - 2000.0));
    private static final TriFunction<Integer, Integer, Integer, Integer> TIME = (a, g, l) -> (int)(400.0 * ((double)(a * g) + 2.0 * Math.pow(a.intValue(), 1.1)) / (132.0 * Math.pow(l.intValue(), 1.3)));
    private boolean active = false;
    private int secondsLeft = 0;
    private int rateRF = 0;

    public RitualBloodBurner() {
        super("blood_burner", 0, ConfigHandler.rituals.bloodBurnerRitualActivationCost, 1, ConfigHandler.rituals.bloodBurnerRitualRefreshCost);
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (!this.checkStructure(world, pos)) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.configuration", true);
            return false;
        }
        List<TileBloodTank> lavaTanks = this.getTanks(world, pos, LAVA_POS);
        int lavaAmount = this.getFluidNumber(lavaTanks, true);
        if (lavaAmount < 1000) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.not_enough_lava", true);
            return false;
        }
        List<TileBloodTank> lifeEssenceTanks = this.getTanks(world, pos, LIFE_ESSENCE_POS);
        int lifeEssenceAmount = this.getFluidNumber(lifeEssenceTanks, false);
        if (lifeEssenceAmount < 1000) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.not_enough_life_essence", true);
            return false;
        }
        List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
        if (stasisPlates.stream().noneMatch(stasisPlate -> {
            ItemStack plateStack = stasisPlate.func_70301_a(0);
            return !plateStack.func_190926_b() && (ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)new ItemStack(Items.field_151114_aO)) || ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)EnumBaseTypes.BLOOD_INFUSED_GLOWSTONE_DUST.getStack()));
        })) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.no_glowstone", true);
            return false;
        }
        ItemStack igniter = ((TileStasisPlate)world.func_175625_s(pos.func_177982_a(0, 1, 0))).func_70301_a(0);
        if (igniter.func_190926_b() || IGNITERS.stream().noneMatch(item -> ItemStack.func_179545_c((ItemStack)igniter, (ItemStack)new ItemStack(item)))) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.no_igniter", true);
            return false;
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (this.checkStructure(world, pos)) {
            List<TileBloodTank> lavaTanks = this.getTanks(world, pos, LAVA_POS);
            List<TileBloodTank> lifeEssenceTanks = this.getTanks(world, pos, LIFE_ESSENCE_POS);
            int lavaAmount = this.getFluidNumber(lavaTanks, true);
            int lifeEssenceAmount = this.getFluidNumber(lifeEssenceTanks, false);
            int dustAmount = this.getTotalDustAmount(this.getStasisPlates(world, pos));
            if (this.active) {
                if (this.secondsLeft > 0 && this.rateRF > 0) {
                    TileEntity energyHandler = world.func_175625_s(pos.func_177982_a(0, 2, 0));
                    if (energyHandler != null && energyHandler.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) {
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 4.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{0});
                        ((IEnergyStorage)energyHandler.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)).receiveEnergy(this.rateRF, false);
                        --this.secondsLeft;
                        if (world.func_72820_D() % 4L == 0L) {
                            network.syphon(SoulTicket.block((World)world, (BlockPos)pos, (int)((int)((double)ConfigHandler.rituals.bloodBurnerRitualNetworkCost * Math.log10(this.rateRF)))));
                            if (world instanceof WorldServer) {
                                WorldServer server = (WorldServer)world;
                                server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 5, 0.2, 0.0, 0.2, 0.2, new int[0]);
                                server.func_175739_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 10, 0.2, 0.0, 0.2, 0.2, new int[0]);
                            }
                        }
                    }
                    for (BlockPos firingPos : FIRING_POS) {
                        firingPos = pos.func_177971_a((Vec3i)firingPos);
                        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)firingPos.func_177958_n(), (double)firingPos.func_177956_o(), (double)firingPos.func_177952_p(), false));
                        if (world.func_180495_p(firingPos) != Blocks.field_150350_a) continue;
                        world.func_180501_a(firingPos, Blocks.field_150480_ab.func_176223_P(), 11);
                    }
                } else if (this.secondsLeft <= 0) {
                    if (lifeEssenceAmount >= 1000 && lavaAmount >= 1000 && dustAmount > 0) {
                        this.startBurn(world, pos, lavaAmount, lifeEssenceAmount, lavaTanks, lifeEssenceTanks);
                    } else {
                        this.endRitual(world, pos, masterRitualStone);
                    }
                }
            } else if (lifeEssenceAmount >= 1000 && lavaAmount >= 1000 && dustAmount > 0) {
                this.startBurn(world, pos, lavaAmount, lifeEssenceAmount, lavaTanks, lifeEssenceTanks);
            } else {
                this.endRitual(world, pos, masterRitualStone);
            }
        } else {
            this.endRitual(world, pos, masterRitualStone);
        }
    }

    private void startBurn(World world, BlockPos pos, int lavaAmount, int lifeEssenceAmount, List<TileBloodTank> lavaTanks, List<TileBloodTank> lifeEssenceTanks) {
        TileStasisPlate stasisPlate = (TileStasisPlate)world.func_175625_s(pos.func_177982_a(0, 1, 0));
        ItemStack igniter = stasisPlate.func_70301_a(0);
        int u = ItemStack.func_179545_c((ItemStack)igniter, (ItemStack)new ItemStack(RegistrarBloodArsenalItems.BOUND_IGNITER)) ? 2 : 1;
        int g = (int)Math.pow(this.getTotalDustAmount(this.getStasisPlates(world, pos)), 2.0);
        int time = TIME.apply(lifeEssenceAmount, g, lavaAmount);
        int totalRF = TOTAL_RF.apply(lifeEssenceAmount, g).apply(u, lavaAmount);
        int rate = totalRF / time;
        this.active = true;
        this.secondsLeft = time;
        this.rateRF = rate;
        for (TileStasisPlate plate : this.getStasisPlates(world, pos)) {
            plate.setStasis(true);
        }
        this.shrinkInputs(world, pos, lifeEssenceTanks, lavaTanks);
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() + 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() - 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() + 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() - 6), false));
    }

    private void endRitual(World world, BlockPos pos, IMasterRitualStone mrs) {
        world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0f, false);
        for (TileStasisPlate plate : this.getStasisPlates(world, pos)) {
            plate.setStasis(false);
        }
        this.active = false;
        this.secondsLeft = 0;
        this.rateRF = 0;
        mrs.setActive(false);
    }

    private boolean checkStructure(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos.func_177982_a(0, 2, 0));
        if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) {
            return false;
        }
        tile = world.func_175625_s(pos.func_177982_a(0, 1, 0));
        if (!(tile instanceof TileStasisPlate)) {
            return false;
        }
        for (BlockPos firePos : FIRE_POS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)firePos)).func_177230_c() instanceof BlockFire) continue;
            return false;
        }
        for (BlockPos glowstonePos : GLOWSTONE_POS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)glowstonePos)).func_177230_c() instanceof BlockStasisPlate) continue;
            return false;
        }
        return true;
    }

    private List<TileBloodTank> getTanks(World world, BlockPos pos, Collection<BlockPos> tankPositions) {
        ArrayList<TileBloodTank> tanks = new ArrayList<TileBloodTank>();
        for (BlockPos tankPos : tankPositions) {
            BlockPos actualPos = pos.func_177971_a((Vec3i)tankPos);
            TileEntity tank = world.func_175625_s(actualPos);
            if (!(tank instanceof TileBloodTank)) continue;
            world.markAndNotifyBlock(actualPos, world.func_175726_f(actualPos), world.func_180495_p(actualPos), world.func_180495_p(actualPos), 3);
            if (((TileBloodTank)tank).getTank().getFluidAmount() <= 0 || !ACCEPTABLE_FLUIDS.contains(((TileBloodTank)tank).getTank().getFluid().getFluid())) continue;
            tanks.add((TileBloodTank)tank);
        }
        return tanks;
    }

    private int getFluidNumber(List<TileBloodTank> tanks, boolean lava) {
        if (lava) {
            return 1000 * tanks.stream().mapToInt(t -> Math.min(t.getTank().getFluidAmount(), 1000) / 1000).sum();
        }
        return tanks.stream().mapToInt(t -> (t.getTank().getFluid().getFluid() == RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE ? 4 : 1) * Math.min(t.getTank().getFluidAmount(), 1000)).sum();
    }

    private List<TileStasisPlate> getStasisPlates(World world, BlockPos pos) {
        ArrayList<TileStasisPlate> plates = new ArrayList<TileStasisPlate>();
        for (BlockPos platePos : GLOWSTONE_POS) {
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)platePos)) instanceof TileStasisPlate)) continue;
            plates.add((TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)platePos)));
        }
        return plates;
    }

    private int getTotalDustAmount(List<TileStasisPlate> stasisPlates) {
        int amount = 0;
        for (TileStasisPlate stasisPlate : stasisPlates) {
            if (stasisPlate.func_70301_a(0).func_190926_b()) continue;
            if (stasisPlate.func_70301_a(0).func_77973_b() == Items.field_151114_aO) {
                ++amount;
                continue;
            }
            if (stasisPlate.func_70301_a(0).func_77973_b() != EnumBaseTypes.BLOOD_INFUSED_GLOWSTONE_DUST.getItem()) continue;
            amount += 2;
        }
        return amount;
    }

    private void shrinkInputs(World world, BlockPos pos, List<TileBloodTank> lifeEssenceTanks, List<TileBloodTank> lavaTanks) {
        for (TileBloodTank tank : Iterables.concat(lifeEssenceTanks, lavaTanks)) {
            tank.getTank().drain(tank.getTank().getFluid().getFluid() == RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE ? 250 : 1000, true);
        }
        for (TileStasisPlate stasisPlate : this.getStasisPlates(world, pos)) {
            ItemStack plateStack = stasisPlate.func_70301_a(0);
            if (plateStack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)new ItemStack(Items.field_151114_aO)) && !ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)EnumBaseTypes.BLOOD_INFUSED_GLOWSTONE_DUST.getStack())) continue;
            plateStack.func_190918_g(1);
            stasisPlate.func_70299_a(0, plateStack);
        }
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, -1, 0, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.BLANK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 2, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 3, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 1, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 4, 2, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 6, 5, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 6, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 5, -1, EnumRuneType.DUSK);
        for (int y = 0; y < 6; ++y) {
            if (y % 2 == 0) {
                this.addOffsetRunes(components, 6, 5, y, EnumRuneType.FIRE);
            }
            this.addCornerRunes(components, 6, y, EnumRuneType.FIRE);
        }
    }

    public Ritual getNewCopy() {
        return new RitualBloodBurner();
    }
}

