/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.ritual;

import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.block.BlockStasisPlate;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierHandler;
import arcaratus.bloodarsenal.modifier.ModifierHelper;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import arcaratus.bloodarsenal.recipe.RecipeSanguineInfusion;
import arcaratus.bloodarsenal.recipe.SanguineInfusionRecipeRegistry;
import arcaratus.bloodarsenal.ritual.RitualBloodArsenal;
import arcaratus.bloodarsenal.tile.TileStasisPlate;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

@RitualRegister(value="infusion")
public class RitualInfusion
extends RitualBloodArsenal {
    private static final Set<BlockPos> STASIS_PLATE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(1, 1, 3), new BlockPos(-1, 1, 3), new BlockPos(1, 1, -3), new BlockPos(-1, 1, -3), new BlockPos(3, 1, 1), new BlockPos(3, 1, -1), new BlockPos(-3, 1, 1), new BlockPos(-3, 1, -1)});
    private int craftingTimer = 0;
    private boolean isCrafting = false;
    private int modifierLevel = 0;
    private boolean trackerFlag = false;
    private RecipeSanguineInfusion recipe = null;
    private ItemStack wildStack = ItemStack.field_190927_a;
    private NBTTagCompound specialNBT = null;

    public RitualInfusion() {
        super("infusion", 0, ConfigHandler.rituals.infusionRitualActivationCost, 1, ConfigHandler.rituals.infusionRitualRefreshCost);
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (!this.checkStructure(world, pos)) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.configuration", true);
            return false;
        }
        IInventory altarInv = (IInventory)world.func_175625_s(pos.func_177982_a(0, 1, 0));
        if (altarInv.func_191420_l()) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.altar_no_item", true);
            return false;
        }
        List<ItemStack> inputStacks = this.getItemStackInputs(world, pos);
        Class wildClass = null;
        block0: for (ItemStack itemStack : inputStacks) {
            for (Class clazz : SanguineInfusionRecipeRegistry.getBlacklistedClasses()) {
                if (!clazz.isInstance(itemStack.func_77973_b())) continue;
                this.wildStack = itemStack;
                wildClass = clazz;
                inputStacks.remove(itemStack);
                break block0;
            }
        }
        System.out.println("EL: " + inputStacks);
        ItemStack input = altarInv.func_70301_a(0);
        this.recipe = SanguineInfusionRecipeRegistry.getRecipeFromInputs(input, inputStacks);
        if (this.recipe == null) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.recipe_error", true);
            return false;
        }
        if (!(this.recipe.getFilter() == null || this.recipe.getFilter().matches(this.wildStack) || wildClass != null && !this.wildStack.func_190926_b() && wildClass.isInstance(this.wildStack.func_77973_b()))) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.recipe_error", true);
            return false;
        }
        if (this.recipe.getModifier() != Modifier.EMPTY_MODIFIER && input.func_77973_b() instanceof IModifiableItem) {
            ItemStack specificStack;
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(input);
            String modifierKey = this.recipe.getModifier().getUniqueIdentifier();
            Modifier modifier = ModifierHandler.getModifierFromKey(modifierKey);
            ModifierTracker trackerOnItem = modifiable.getTrackerForModifier(modifierKey);
            if (!modifiable.hasModifier(modifierKey)) {
                this.modifierLevel = 0;
            } else {
                this.modifierLevel = trackerOnItem.getLevel() + 1;
                this.trackerFlag = true;
            }
            if (!modifiable.canApplyModifier(modifier, this.modifierLevel)) {
                BloodArsenalUtils.sendPlayerMessage(player, TextHelper.localizeEffect((String)"chat.bloodarsenal.ritual.modifier_incompatible", (Object[])new Object[]{TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]), this.modifierLevel, input.func_82833_r()}), true);
                return false;
            }
            Modifier modifierOnItem = modifiable.getModifier(modifierKey);
            if (modifierOnItem.getSpecialNBT(input) != null) {
                this.specialNBT = modifierOnItem.getSpecialNBT(input);
            }
            if (this.specialNBT != null && !this.recipe.matchesWithSpecificity(this.wildStack, specificStack = new ItemStack(this.specialNBT.func_74775_l("itemStack")))) {
                BloodArsenalUtils.sendPlayerMessage(player, TextHelper.localizeEffect((String)"chat.bloodarsenal.ritual.input_specific_error", (Object[])new Object[]{specificStack.func_82833_r()}), true);
                return false;
            }
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (world.field_72995_K) {
            return;
        }
        if (this.checkStructure(world, pos)) {
            List<ItemStack> inputStacks = this.getItemStackInputs(world, pos);
            List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
            IInventory altarInv = (IInventory)world.func_175625_s(pos.func_177982_a(0, 1, 0));
            ItemStack input = altarInv.func_70301_a(0);
            if (this.recipe != null && !altarInv.func_191420_l()) {
                if (this.isCrafting && this.recipe.getModifier() == Modifier.EMPTY_MODIFIER) {
                    this.tickCrafting(world, pos, network);
                    if (this.craftingTimer >= this.recipe.getLpCost() / this.getRefreshCost()) {
                        this.shrinkItemStackInputs(world, pos, this.constructItemStackList(this.recipe, inputStacks, 0), ItemStack.field_190927_a);
                        altarInv.func_70299_a(0, this.recipe.getOutput());
                        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)masterRitualStone.getBlockPos().func_177958_n(), (double)masterRitualStone.getBlockPos().func_177956_o(), (double)masterRitualStone.getBlockPos().func_177952_p(), true));
                        this.endRitual(world, pos, masterRitualStone);
                    }
                } else if (this.recipe.getModifier() != Modifier.EMPTY_MODIFIER && input.func_77973_b() instanceof IModifiableItem) {
                    StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(input);
                    String modifierKey = this.recipe.getModifier().getUniqueIdentifier();
                    Modifier modifier = ModifierHandler.getModifierFromKey(modifierKey);
                    ModifierTracker trackerOnItem = modifiable.getTrackerForModifier(modifierKey);
                    int level = this.getMaxModifierLevel(this.recipe, modifier.getMaxLevel(), inputStacks);
                    if (this.isCrafting && this.modifierLevel <= level) {
                        this.tickCrafting(world, pos, network);
                        if (this.craftingTimer >= this.recipe.getLpCost() * (this.modifierLevel + 1) / this.getRefreshCost()) {
                            modifiable.applyModifier(ModifierHelper.getModifierAndTracker(modifierKey, this.modifierLevel));
                            if (this.trackerFlag) {
                                trackerOnItem.onModifierUpgraded();
                            }
                            ItemStack copyStack = input.func_77946_l();
                            NBTHelper.checkNBT((ItemStack)copyStack);
                            modifier.removeSpecialNBT(copyStack);
                            modifier.writeSpecialNBT(copyStack, this.wildStack, this.modifierLevel);
                            modifiable.setMod(copyStack);
                            this.shrinkItemStackInputs(world, pos, this.constructItemStackList(this.recipe, inputStacks, this.modifierLevel), this.wildStack);
                            altarInv.func_70299_a(0, copyStack);
                            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)masterRitualStone.getBlockPos().func_177958_n(), (double)(masterRitualStone.getBlockPos().func_177956_o() + 1), (double)masterRitualStone.getBlockPos().func_177952_p(), true));
                            world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 3.5, (double)pos.func_177952_p() + 0.5, 0.0f, false);
                            this.endRitual(world, pos, masterRitualStone);
                        }
                    } else if (!this.isCrafting) {
                        this.setStasisPlates(world, stasisPlates, true);
                        this.isCrafting = true;
                    } else {
                        this.endRitual(world, pos, masterRitualStone);
                    }
                } else if (ItemStack.func_179545_c((ItemStack)this.recipe.getInfuse(), (ItemStack)input)) {
                    this.setStasisPlates(world, stasisPlates, true);
                    this.isCrafting = true;
                }
            } else {
                this.endRitual(world, pos, masterRitualStone);
            }
        } else {
            this.endRitual(world, pos, masterRitualStone);
        }
    }

    private void tickCrafting(World world, BlockPos pos, SoulNetwork network) {
        if (!this.isCrafting) {
            return;
        }
        ++this.craftingTimer;
        if (world.func_72820_D() % 4L == 0L) {
            network.syphon(SoulTicket.block((World)world, (BlockPos)pos, (int)ConfigHandler.rituals.infusionRitualRefreshCost));
            if (world instanceof WorldServer) {
                WorldServer server = (WorldServer)world;
                server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 5, 0.2, 0.0, 0.2, 0.2, new int[0]);
                server.func_175739_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 5, 0.2, 0.0, 0.2, 0.1, new int[0]);
            }
        }
    }

    private void endRitual(World world, BlockPos pos, IMasterRitualStone mrs) {
        world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0f, false);
        List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
        this.setStasisPlates(world, stasisPlates, false);
        this.isCrafting = false;
        this.craftingTimer = 0;
        mrs.setActive(false);
    }

    private boolean checkStructure(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos.func_177982_a(0, 1, 0)) instanceof IBloodAltar)) {
            return false;
        }
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)stasisPlatePos)).func_177230_c() instanceof BlockStasisPlate) continue;
            return false;
        }
        return true;
    }

    private List<TileStasisPlate> getStasisPlates(World world, BlockPos pos) {
        ArrayList<TileStasisPlate> stasisPlates = new ArrayList<TileStasisPlate>();
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)) instanceof TileStasisPlate)) continue;
            stasisPlates.add((TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)));
        }
        return stasisPlates;
    }

    private void setStasisPlates(World world, List<TileStasisPlate> stasisPlates, boolean stasis) {
        for (TileStasisPlate plate : stasisPlates) {
            plate.setStasis(stasis);
            world.func_184138_a(plate.func_174877_v(), world.func_180495_p(plate.func_174877_v()), world.func_180495_p(plate.func_174877_v()), 3);
        }
    }

    private int getMaxModifierLevel(RecipeSanguineInfusion recipe, int maxLevel, List<ItemStack> inputStacks) {
        for (int i = maxLevel; i >= 0; --i) {
            if (!recipe.matches(ItemStack.field_190927_a, inputStacks, i)) continue;
            return i;
        }
        return 0;
    }

    private List<ItemStack> getItemStackInputs(World world, BlockPos pos) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            TileStasisPlate plate;
            BlockPos actualPos = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(actualPos) instanceof TileStasisPlate) || (plate = (TileStasisPlate)world.func_175625_s(actualPos)).func_70301_a(0).func_190926_b()) continue;
            stackList.add(plate.func_70301_a(0));
        }
        return stackList;
    }

    private List<ItemStack> constructItemStackList(RecipeSanguineInfusion recipe, List<ItemStack> inputs, int level) {
        List<Pair<Ingredient, Integer>> ingredients = recipe.getInputsForLevel(level);
        ArrayList<ItemStack> dummyList = new ArrayList<ItemStack>();
        block0: for (Pair<Ingredient, Integer> entry : ingredients) {
            Ingredient ingredient = (Ingredient)entry.getKey();
            int count = (Integer)entry.getValue();
            for (ItemStack input : inputs) {
                if (!ingredient.apply(input) || input.func_190916_E() < count) continue;
                dummyList.add(ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)count));
                inputs.remove(input);
                continue block0;
            }
        }
        return dummyList;
    }

    private void shrinkItemStackInputs(World world, BlockPos pos, List<ItemStack> recipeInputs, ItemStack extraStack) {
        block0: for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            TileStasisPlate plate;
            ItemStack plateStack;
            BlockPos platePosition = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(platePosition) instanceof TileStasisPlate) || (plateStack = (plate = (TileStasisPlate)world.func_175625_s(platePosition)).func_70301_a(0)).func_190926_b()) continue;
            if (!extraStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)extraStack, (ItemStack)plateStack)) {
                plateStack.func_190918_g(1);
                plate.func_70299_a(0, plateStack);
            }
            for (ItemStack recipeInput : recipeInputs) {
                if (!ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)plateStack)) continue;
                plateStack.func_190918_g(recipeInput.func_190916_E());
                plate.func_70299_a(0, plateStack);
                recipeInputs.remove(recipeInput);
                continue block0;
            }
        }
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, -1, EnumRuneType.WATER);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, -1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 4, -1, EnumRuneType.WATER);
        this.addParallelRunes(components, 5, -1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 2, 5, 0, EnumRuneType.BLANK);
        this.addOffsetRunes(components, 3, 5, 0, EnumRuneType.BLANK);
        this.addOffsetRunes(components, 4, 5, 0, EnumRuneType.BLANK);
        this.addCornerRunes(components, 4, 1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 2, 5, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 2, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 5, 2, EnumRuneType.FIRE);
        this.addCornerRunes(components, 4, 3, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 2, 5, 3, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 5, 4, EnumRuneType.WATER);
        this.addOffsetRunes(components, 3, 4, 4, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 5, EnumRuneType.AIR);
        this.addCornerRunes(components, 3, 5, EnumRuneType.AIR);
        this.addOffsetRunes(components, 2, 3, 5, EnumRuneType.DUSK);
        this.addParallelRunes(components, 3, 6, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 1, 3, 6, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 6, EnumRuneType.DUSK);
    }

    public Ritual getNewCopy() {
        return new RitualInfusion();
    }
}

