/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.ritual;

import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileBloodTank;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.block.BlockStasisPlate;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalBlocks;
import arcaratus.bloodarsenal.registry.ModRecipes;
import arcaratus.bloodarsenal.ritual.RitualBloodArsenal;
import arcaratus.bloodarsenal.tile.TileStasisPlate;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;

@RitualRegister(value="purification")
public class RitualPurification
extends RitualBloodArsenal {
    private static final Set<BlockPos> STASIS_PLATE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(2, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(0, 1, 2), new BlockPos(0, 1, -2)});
    private static final BlockPos INPUT_TANK_POS = new BlockPos(0, 3, 0);
    private static final BlockPos OUTPUT_TANK_POS = new BlockPos(0, 2, 0);
    private boolean active = false;
    private int fluidLeft = 0;

    public RitualPurification() {
        super("purification", 0, ConfigHandler.rituals.purificationtRitualActivationCost, 1, ConfigHandler.rituals.purificationRitualRefreshCost);
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (!this.checkStructure(world, pos)) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.configuration", true);
            return false;
        }
        TileBloodTank inputTank = (TileBloodTank)world.func_175625_s(pos.func_177971_a((Vec3i)INPUT_TANK_POS));
        TileBloodTank outputTank = (TileBloodTank)world.func_175625_s(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS));
        if (outputTank.getTank().getFluidAmount() != 0 && outputTank.getTank().getFluid().getFluid() != RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.output_tank_wrong", true);
            return false;
        }
        if (inputTank.getTank().getFluidAmount() == 0 || inputTank.getTank().getFluid().getFluid() != BlockLifeEssence.getLifeEssence() || inputTank.getTank().getFluidAmount() < ConfigHandler.rituals.purificationRitualMinLP) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.input_tank_empty", true);
            return false;
        }
        if (!this.hasInputs(world, pos, ModRecipes.PURIFICATION_1)) {
            BloodArsenalUtils.sendPlayerMessage(player, "chat.bloodarsenal.ritual.input_error", true);
            return false;
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (this.active && world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 8.0, (double)pos.func_177956_o() + 1.5 + world.field_73012_v.nextGaussian() / 8.0, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 8.0, 0.0, 0.0, 0.0, new int[]{0});
        }
        if (this.checkStructure(world, pos)) {
            TileBloodTank inputTank = (TileBloodTank)world.func_175625_s(pos.func_177971_a((Vec3i)INPUT_TANK_POS));
            TileBloodTank outputTank = (TileBloodTank)world.func_175625_s(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS));
            if (this.active) {
                if (this.fluidLeft > 0) {
                    this.tickRitual(world, pos, network, inputTank, outputTank);
                } else if (this.hasInputs(world, pos, ModRecipes.PURIFICATION_1) && inputTank.getTank().getFluidAmount() != 0 && inputTank.getTank().getFluid().getFluid() == BlockLifeEssence.getLifeEssence() && inputTank.getTank().getFluidAmount() >= ConfigHandler.rituals.purificationRitualMinLP) {
                    this.fluidLeft = ConfigHandler.rituals.purificationRitualMinLP;
                    this.shrinkItemStackInputs(world, pos, ModRecipes.PURIFICATION_1);
                } else {
                    this.endRitual(world, pos, masterRitualStone);
                }
                return;
            }
            if (outputTank.getTank().getFluidAmount() != 0 && outputTank.getTank().getFluid().getFluid() != RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE) {
                this.endRitual(world, pos, masterRitualStone);
                return;
            }
            if (inputTank.getTank().getFluidAmount() == 0 || inputTank.getTank().getFluid().getFluid() != BlockLifeEssence.getLifeEssence() || inputTank.getTank().getFluidAmount() < ConfigHandler.rituals.purificationRitualMinLP) {
                this.endRitual(world, pos, masterRitualStone);
                return;
            }
            if (!this.hasInputs(world, pos, ModRecipes.PURIFICATION_1)) {
                this.endRitual(world, pos, masterRitualStone);
                return;
            }
            this.shrinkItemStackInputs(world, pos, ModRecipes.PURIFICATION_1);
            this.active = true;
            this.fluidLeft = ConfigHandler.rituals.purificationRitualMinLP;
        } else {
            this.endRitual(world, pos, masterRitualStone);
        }
    }

    private void tickRitual(World world, BlockPos pos, SoulNetwork network, TileBloodTank inputTank, TileBloodTank outputTank) {
        if (!this.active) {
            return;
        }
        int conversion = ConfigHandler.rituals.refinedLifeEssenceConversion;
        inputTank.getTank().drain(conversion, true);
        outputTank.getTank().fill(new FluidStack(RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE, 1), true);
        world.func_184138_a(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS), world.func_180495_p(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS)), world.func_180495_p(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS)), 3);
        world.func_184138_a(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS), world.func_180495_p(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS)), world.func_180495_p(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS)), 3);
        this.fluidLeft -= conversion;
        network.syphon(SoulTicket.block((World)world, (BlockPos)pos, (int)this.getRefreshCost()));
        if (world instanceof WorldServer && world.func_72820_D() % 4L == 0L) {
            WorldServer server = (WorldServer)world;
            for (int i = 0; i < 4; ++i) {
                server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 + (double)i, (double)pos.func_177952_p() + 0.5, 3, 0.2, 0.2, 0.2, 0.1, new int[0]);
            }
        }
    }

    private void endRitual(World world, BlockPos pos, IMasterRitualStone mrs) {
        List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
        this.setStasisPlates(world, stasisPlates, false);
        mrs.setActive(false);
    }

    private boolean checkStructure(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos.func_177971_a((Vec3i)OUTPUT_TANK_POS)) instanceof TileBloodTank) || !(world.func_175625_s(pos.func_177971_a((Vec3i)INPUT_TANK_POS)) instanceof TileBloodTank)) {
            return false;
        }
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)stasisPlatePos)).func_177230_c() instanceof BlockStasisPlate) continue;
            return false;
        }
        return true;
    }

    private List<TileStasisPlate> getStasisPlates(World world, BlockPos pos) {
        ArrayList<TileStasisPlate> stasisPlates = new ArrayList<TileStasisPlate>();
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)) instanceof TileStasisPlate)) continue;
            stasisPlates.add((TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)));
        }
        return stasisPlates;
    }

    private void setStasisPlates(World world, List<TileStasisPlate> stasisPlates, boolean stasis) {
        for (TileStasisPlate plate : stasisPlates) {
            plate.setStasis(stasis);
            world.func_184138_a(plate.func_174877_v(), world.func_180495_p(plate.func_174877_v()), world.func_180495_p(plate.func_174877_v()), 3);
        }
    }

    private List<ItemStack> getItemStackInputs(World world, BlockPos pos) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            TileStasisPlate plate;
            BlockPos actualPos = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(actualPos) instanceof TileStasisPlate) || (plate = (TileStasisPlate)world.func_175625_s(actualPos)).func_70301_a(0).func_190926_b()) continue;
            stackList.add(plate.func_70301_a(0));
        }
        return stackList;
    }

    private boolean hasInputs(World world, BlockPos pos, Collection<ItemStack> ingredients) {
        List<ItemStack> inputs = this.getItemStackInputs(world, pos);
        for (ItemStack ing : ingredients) {
            boolean found = false;
            for (ItemStack inputStack : inputs) {
                if (!ItemStack.func_179545_c((ItemStack)ing, (ItemStack)inputStack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void shrinkItemStackInputs(World world, BlockPos pos, Collection<ItemStack> recipeInputs) {
        for (BlockPos stasisPlatePos : STASIS_PLATE_POS) {
            TileStasisPlate plate;
            ItemStack plateStack;
            BlockPos platePosition = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(platePosition) instanceof TileStasisPlate) || (plateStack = (plate = (TileStasisPlate)world.func_175625_s(platePosition)).func_70301_a(0)).func_190926_b()) continue;
            for (ItemStack recipeInput : recipeInputs) {
                if (!ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)plateStack)) continue;
                plateStack.func_190918_g(recipeInput.func_190916_E());
                plate.func_70299_a(0, plateStack);
            }
        }
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 1, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 0, EnumRuneType.BLANK);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.WATER);
        this.addCornerRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 2, EnumRuneType.FIRE);
        this.addCornerRunes(components, 4, 3, EnumRuneType.FIRE);
        this.addCornerRunes(components, 4, 4, EnumRuneType.DUSK);
    }

    public Ritual getNewCopy() {
        return new RitualPurification();
    }
}

