/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Utils {
    private static final Converter<String, String> UNDRSCR_TO_CML = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);

    private Utils() {
    }

    public static <I extends Item> I name(I item, String registryName) {
        Utils.name(item, registryName, arg_0 -> item.func_77655_b(arg_0));
        return item;
    }

    public static <B extends Block> B name(B block, String registryName) {
        Utils.name(block, registryName, arg_0 -> block.func_149663_c(arg_0));
        return block;
    }

    private static <T extends IForgeRegistryEntry.Impl<T>> T name(T entry, String registryName, Consumer<String> unlocalizedNameSetter) {
        entry.setRegistryName(registryName);
        unlocalizedNameSetter.accept(Utils.underScoreToCamel(registryName));
        return entry;
    }

    public static String underScoreToCamel(String value) {
        return (String)UNDRSCR_TO_CML.convert((Object)value);
    }

    public static Field getFieldOfType(Class<?> clazz, Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            field.setAccessible(true);
            return field;
        }
        throw new ReflectionHelper.UnableToFindFieldException(null, null);
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> clazz, int ordinal) {
        Enum[] values = (Enum[])Objects.requireNonNull(clazz, "clazz").getEnumConstants();
        return (E)values[ordinal < 0 || ordinal >= values.length ? 0 : ordinal];
    }

    public static String formatColored(EnumDyeColor color, String name) {
        return I18n.func_74837_a((String)"format.colored", (Object[])new Object[]{I18n.func_74838_a((String)("color." + color.func_176762_d() + ".name")), name});
    }

    public static String formatRecipeTooltip(String key) {
        return Utils.formatRecipeTooltipValue(I18n.func_74838_a((String)key));
    }

    private static String formatRecipeTooltipValue(String value) {
        return I18n.func_74837_a((String)"recipe.ingredient.tooltip", (Object[])new Object[]{value});
    }

    public static String getEntityName(Entity e) {
        if (e.func_145818_k_()) {
            return e.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)e);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity.fairylights." + s + ".name"));
    }
}

