/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.LootEntryEmpty;
import com.someguyssoftware.gottschcore.loot.LootEntryItem;
import com.someguyssoftware.gottschcore.loot.LootEntryTable;
import com.someguyssoftware.gottschcore.loot.LootTableManager;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public abstract class LootEntry {
    protected final String entryName;
    protected final int weight;
    protected final int quality;
    protected final LootCondition[] conditions;

    protected LootEntry(int weightIn, int qualityIn, LootCondition[] conditionsIn, String entryName) {
        this.weight = weightIn;
        this.quality = qualityIn;
        this.conditions = conditionsIn;
        this.entryName = entryName;
    }

    public int getEffectiveWeight(float luck) {
        return Math.max(MathHelper.func_76141_d((float)((float)this.weight + (float)this.quality * luck)), 0);
    }

    public String getEntryName() {
        return this.entryName;
    }

    public abstract void addLoot(Collection<ItemStack> var1, Random var2, LootContext var3);

    protected abstract void serialize(JsonObject var1, JsonSerializationContext var2);

    public static class Serializer
    implements JsonDeserializer<LootEntry>,
    JsonSerializer<LootEntry> {
        public LootEntry deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            LootCondition[] alootcondition;
            int j;
            int i;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"loot item");
            String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
            LootEntry ret = LootTableManager.deserializeJsonLootEntry(s, jsonobject, i = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"weight", (int)1), j = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"quality", (int)0), alootcondition = jsonobject.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"conditions", (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{});
            if (ret != null) {
                return ret;
            }
            if ("item".equals(s)) {
                return LootEntryItem.deserialize(jsonobject, context, i, j, alootcondition);
            }
            if ("loot_table".equals(s)) {
                return LootEntryTable.deserialize(jsonobject, context, i, j, alootcondition);
            }
            if ("empty".equals(s)) {
                return LootEntryEmpty.deserialize(jsonobject, context, i, j, alootcondition);
            }
            throw new JsonSyntaxException("Unknown loot entry type '" + s + "'");
        }

        public JsonElement serialize(LootEntry lootEntry, Type type, JsonSerializationContext context) {
            String lootEntryType;
            JsonObject jsonobject = new JsonObject();
            if (lootEntry.entryName != null && !lootEntry.entryName.startsWith("custom#")) {
                jsonobject.addProperty("entryName", lootEntry.entryName);
            }
            jsonobject.addProperty("weight", (Number)lootEntry.weight);
            jsonobject.addProperty("quality", (Number)lootEntry.quality);
            if (lootEntry.conditions.length > 0) {
                jsonobject.add("conditions", context.serialize((Object)lootEntry.conditions));
            }
            if ((lootEntryType = LootTableManager.getLootEntryType(lootEntry)) != null) {
                jsonobject.addProperty("type", lootEntryType);
            } else if (lootEntry instanceof LootEntryItem) {
                jsonobject.addProperty("type", "item");
            } else if (lootEntry instanceof LootEntryTable) {
                jsonobject.addProperty("type", "loot_table");
            } else {
                if (!(lootEntry instanceof LootEntryEmpty)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + lootEntry);
                }
                jsonobject.addProperty("type", "empty");
            }
            lootEntry.serialize(jsonobject, context);
            return jsonobject;
        }
    }
}

