/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.random;

import com.someguyssoftware.gottschcore.random.IRandomProbabilityItem;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomProbabilityCollection<T extends IRandomProbabilityItem> {
    private final NavigableMap<Integer, T> map = new TreeMap<Integer, T>();
    private Random random;
    private int total = 0;

    public RandomProbabilityCollection() {
        this.setRandom(new Random());
    }

    public RandomProbabilityCollection(Collection<T> collection) {
        this(new Random(), collection);
    }

    public RandomProbabilityCollection(Random random) {
        this.setRandom(random);
    }

    public RandomProbabilityCollection(Random random, Collection<T> collection) {
        this.setRandom(random);
        this.add(collection);
    }

    public void add(Collection<T> collection) {
        for (IRandomProbabilityItem item : collection) {
            this.add(item.getProbability(), item);
        }
    }

    public void add(int weight, T item) {
        if (weight <= 0) {
            return;
        }
        this.total += weight;
        this.map.put(this.total, item);
    }

    public IRandomProbabilityItem next() {
        if (this.map.isEmpty() || this.total < 1) {
            return null;
        }
        int value = this.getRandom().nextInt(this.total);
        return (IRandomProbabilityItem)this.map.ceilingEntry(value).getValue();
    }

    public void clear() {
        this.map.clear();
        this.setTotal(0);
    }

    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    private int getTotal() {
        return this.total;
    }

    private void setTotal(int total) {
        this.total = total;
    }

    public Map<Integer, T> getMap() {
        return this.map;
    }
}

