/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world.gen.structure;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.property.PropertyHelper;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockInfoContext;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayBlockInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayRule;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayRuleKeyRegistry;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;

public class DecayProcessor
implements IDecayProcessor {
    private static int AIR = -9999;
    private static int UNKNOWN = 9999;
    private static String DEFAULT_DECAY_RULE_NAME = "default";
    private static int NO_DECAY_INDEX = -1;
    private static String NULL_BLOCK_NAME = "null";
    private List<DecayBlockInfo> decayBlockInfoList;
    private int[][][] layout;
    private IDecayRuleSet ruleSet;
    private IMod mod;
    private boolean backFill = true;
    private IBlockState backFillBlockLayer1 = Blocks.field_150346_d.func_176223_P();
    private IBlockState backFillBlockLayer2 = Blocks.field_150348_b.func_176223_P();
    private int decayStartY = 0;

    public DecayProcessor(IMod mod, IDecayRuleSet ruleSet) {
        this.decayBlockInfoList = new ArrayList<DecayBlockInfo>();
        this.mod = mod;
        this.ruleSet = ruleSet;
    }

    @Override
    public void add(ICoords coords, Template.BlockInfo blockInfo, IBlockState state) {
        this.getDecayBlockInfoList().add(new DecayBlockInfo(blockInfo, coords, state));
    }

    @Override
    public List<DecayBlockInfo> process(World world, Random random, ICoords size, Block NULL_BLOCK) {
        int y;
        Comparator<DecayBlockInfo> compareByCoords = Comparator.comparing(BlockInfoContext::getY).thenComparing(BlockInfoContext::getZ).thenComparing(BlockInfoContext::getX);
        Collections.sort(this.decayBlockInfoList, compareByCoords);
        this.layout = new int[size.getY()][size.getZ()][size.getX()];
        ICoords offsetCoords = this.decayBlockInfoList.get(0).getCoords();
        double initialStrength = this.getRuleSet().getInitialBlockStrength();
        int minDistance = 0;
        int distance1 = 0;
        int distance2 = 0;
        int decayBlockInfoListIndex = 0;
        for (DecayBlockInfo decay : this.decayBlockInfoList) {
            int x = decay.getX() - offsetCoords.getX();
            int y2 = decay.getY() - offsetCoords.getY();
            int z = decay.getZ() - offsetCoords.getZ();
            this.layout[y2][z][x] = decayBlockInfoListIndex++;
            if (decay.getState().func_177230_c() == NULL_BLOCK) continue;
            IBlockState supportState = null;
            if (y2 == 0) {
                if (this.isBackFill()) {
                    ICoords fillCoords = decay.getCoords().down(1);
                    IBlockState fillState = world.func_180495_p(fillCoords.toPos());
                    int depth = 1;
                    while (!fillState.func_185904_a().func_76220_a()) {
                        world.func_175656_a(fillCoords.toPos(), depth > 3 ? Blocks.field_150348_b.func_176223_P() : Blocks.field_150346_d.func_176223_P());
                        fillCoords = fillCoords.down(1);
                        fillState = world.func_180495_p(fillCoords.toPos());
                        ++depth;
                    }
                }
                supportState = world.func_180495_p(decay.getCoords().toPos().func_177977_b());
            } else {
                supportState = this.decayBlockInfoList.get(this.layout[y2 - 1][z][x]).getState();
            }
            Object blockRegistryName = null;
            String ruleKey = null;
            DecayRule decayRule = null;
            if (decay.getState().func_177230_c() != Blocks.field_150350_a) {
                ruleKey = decay.getState().func_177230_c().getRegistryName().toString();
                if (DecayRuleKeyRegistry.getInstance().has(ruleKey)) {
                    ruleKey = DecayRuleKeyRegistry.getInstance().get(ruleKey, String.valueOf(decay.getState().func_177230_c().func_176201_c(decay.getState())));
                }
                if ((decayRule = this.ruleSet.getDecayRules().get(ruleKey)) == null) {
                    decayRule = this.ruleSet.getDecayRules().get(DEFAULT_DECAY_RULE_NAME);
                }
                if (decayRule != null) {
                    int decayIndex = this.getDecayIndex(random, decayRule);
                    IBlockState decayState = this.applyDecay(decay.getState(), decayRule, decayIndex, NULL_BLOCK);
                    decay.setState(decayState);
                    decay.setDecayIndex(decayIndex);
                }
            }
            boolean isWall = decay.getY() >= 0 && decay.getState().func_185904_a().func_76220_a() && supportState.func_185904_a().func_76220_a();
            decay.setWall(isWall);
            minDistance = 0;
            if (isWall) {
                decay.setDistance(0);
                continue;
            }
            if (decay.getState().func_177230_c() == Blocks.field_150350_a) {
                minDistance = AIR;
                continue;
            }
            if (x == 0 && z == 0) {
                minDistance = UNKNOWN;
            } else if (z == 0) {
                minDistance = this.decayBlockInfoList.get(this.layout[y2][z][x - 1]).getDistance();
                if (minDistance == AIR) {
                    minDistance = UNKNOWN;
                }
            } else if (x == 0) {
                minDistance = this.decayBlockInfoList.get(this.layout[y2][z - 1][x]).getDistance();
                if (minDistance == AIR) {
                    minDistance = UNKNOWN;
                }
            } else {
                distance1 = this.decayBlockInfoList.get(this.layout[y2][z][x - 1]).getDistance();
                if (distance1 == AIR) {
                    distance1 = UNKNOWN;
                }
                if ((distance2 = this.decayBlockInfoList.get(this.layout[y2][z - 1][x]).getDistance()) == AIR) {
                    distance2 = UNKNOWN;
                }
                minDistance = Math.min(distance1, distance2) + 1;
            }
            this.decayBlockInfoList.get(this.layout[y2][z][x]).setDistance(minDistance);
        }
        if (GottschCore.logger.isDebugEnabled()) {
            this.dump("-pass1", size);
        }
        double threshold = this.getRuleSet().getBlockStrengthThreshold();
        double yStrength = initialStrength;
        DecayBlockInfo decay = null;
        for (y = 0; y < this.layout.length; ++y) {
            for (int z = this.layout[y].length - 1; z >= 0; --z) {
                for (int x = this.layout[y][z].length - 1; x >= 0; --x) {
                    minDistance = 0;
                    distance1 = 0;
                    distance2 = 0;
                    decay = this.decayBlockInfoList.get(this.layout[y][z][x]);
                    if (decay.getState().func_177230_c() == NULL_BLOCK) continue;
                    if (y >= this.getDecayStartY()) {
                        yStrength = initialStrength - (double)(y - this.getDecayStartY()) * RandomHelper.randomDouble(random, this.getRuleSet().getVerticalDecayRate().getMin(), this.getRuleSet().getVerticalDecayRate().getMax());
                        if (y > 0) {
                            yStrength = Math.min(yStrength, this.decayBlockInfoList.get(this.layout[y - 1][z][x]).getStrength());
                        }
                        decay.setStrength(yStrength);
                    }
                    if (decay.isWall()) {
                        decay.setDistance(0);
                    } else {
                        if (decay.getDistance() == AIR) continue;
                        if (x != this.layout[y][z].length - 1 || z != this.layout[y].length - 1) {
                            if (z == this.layout[y].length - 1) {
                                minDistance = this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getDistance();
                                if (minDistance == AIR) {
                                    minDistance = UNKNOWN;
                                }
                            } else if (x == this.layout[y][z].length - 1) {
                                minDistance = this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getDistance();
                                if (minDistance == AIR) {
                                    minDistance = UNKNOWN;
                                }
                            } else {
                                distance1 = this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getDistance();
                                if (distance1 == AIR) {
                                    distance1 = UNKNOWN;
                                }
                                if ((distance2 = this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getDistance()) == AIR) {
                                    distance2 = UNKNOWN;
                                }
                            }
                        }
                        minDistance = Math.min(decay.getDistance(), Math.min(distance1, distance2) + 1);
                        decay.setDistance(minDistance);
                        double strength = yStrength - (double)decay.getDistance() * RandomHelper.randomDouble(random, this.getRuleSet().getBlockStrengthDistanceDecayRate().getMin(), this.getRuleSet().getBlockStrengthDistanceDecayRate().getMax());
                        if (decay.getDecayIndex() > NO_DECAY_INDEX) {
                            double weakenAmount = (double)decay.getDecayIndex() * RandomHelper.randomDouble(random, this.getRuleSet().getBlockStrengthDecayRate().getMin(), this.getRuleSet().getBlockStrengthDecayRate().getMax());
                            strength -= weakenAmount;
                            this.updateNeighbors(y, z, x, weakenAmount);
                        }
                        decay.setStrength(strength);
                    }
                    if (decay.getStrength() <= threshold) {
                        decay.setState(Blocks.field_150350_a.func_176223_P());
                    }
                    if (z + 1 < this.layout[y].length && this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getState().func_177230_c() != Blocks.field_150350_a && this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getState().func_177230_c() != NULL_BLOCK && this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getStrength() <= threshold) {
                        this.decayBlockInfoList.get(this.layout[y][z + 1][x]).setState(Blocks.field_150350_a.func_176223_P());
                    }
                    if (x + 1 >= this.layout[y][z].length || this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getState().func_177230_c() == Blocks.field_150350_a || this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getState().func_177230_c() == NULL_BLOCK || !(this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getStrength() <= threshold)) continue;
                    this.decayBlockInfoList.get(this.layout[y][z][x + 1]).setState(Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        if (GottschCore.logger.isDebugEnabled()) {
            this.dump("-pass2", size);
        }
        for (y = 0; y < this.layout.length; ++y) {
            for (int z = 0; z < this.layout[y].length; ++z) {
                for (int x = 0; x < this.layout[y][z].length; ++x) {
                    decay = this.decayBlockInfoList.get(this.layout[y][z][x]);
                    if (decay.getState().func_177230_c() == Blocks.field_150350_a || decay.getState().func_177230_c() == NULL_BLOCK || this.checkForNeighbors(world, y, z, x)) continue;
                    decay.setState(Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        return this.decayBlockInfoList;
    }

    private boolean checkForNeighbors(World world, int y, int z, int x) {
        IBlockState supportState = null;
        supportState = y == 0 ? world.func_180495_p(this.decayBlockInfoList.get(this.layout[y][z][x]).getCoords().toPos().func_177977_b()) : this.decayBlockInfoList.get(this.layout[y - 1][z][x]).getState();
        if (supportState.func_185904_a().func_76220_a()) {
            return true;
        }
        if (z - 1 > 0 && this.decayBlockInfoList.get(this.layout[y][z - 1][x]).getState().func_185904_a().func_76220_a()) {
            return true;
        }
        if (z + 1 < this.layout[y].length && this.decayBlockInfoList.get(this.layout[y][z + 1][x]).getState().func_185904_a().func_76220_a()) {
            return true;
        }
        if (x - 1 > 0 && this.decayBlockInfoList.get(this.layout[y][z][x - 1]).getState().func_185904_a().func_76220_a()) {
            return true;
        }
        return x + 1 < this.layout[y][z].length && this.decayBlockInfoList.get(this.layout[y][z][x + 1]).getState().func_185904_a().func_76220_a();
    }

    private void updateNeighbors(int y, int z, int x, double weakenAmount) {
        if (z - 1 > 0 && !this.decayBlockInfoList.get(this.layout[y][z - 1][x]).isWall()) {
            this.weakenStrength(this.decayBlockInfoList.get(this.layout[y][z - 1][x]), weakenAmount);
        }
        if (z + 1 < this.layout[y].length && !this.decayBlockInfoList.get(this.layout[y][z + 1][x]).isWall()) {
            this.weakenStrength(this.decayBlockInfoList.get(this.layout[y][z + 1][x]), weakenAmount);
        }
        if (x - 1 > 0 && !this.decayBlockInfoList.get(this.layout[y][z][x - 1]).isWall()) {
            this.weakenStrength(this.decayBlockInfoList.get(this.layout[y][z][x - 1]), weakenAmount);
        }
        if (x + 1 < this.layout[y][z].length && !this.decayBlockInfoList.get(this.layout[y][z][x + 1]).isWall()) {
            this.weakenStrength(this.decayBlockInfoList.get(this.layout[y][z][x + 1]), weakenAmount);
        }
    }

    private void weakenStrength(DecayBlockInfo decay, double weakenAmount) {
        double strength = decay.getStrength();
        decay.setStrength(strength -= weakenAmount);
    }

    private void dump(String filenamePostfix, ICoords size) {
        int x;
        int z;
        int y;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmssZ");
        DecimalFormat df = new DecimalFormat("###.#");
        String filename = String.format("decay-prcoessor-%s-%s.txt", filenamePostfix, formatter.format(new Date()));
        Path path = Paths.get(this.mod.getConfig().getConfigFolder(), this.mod.getId(), "dumps").toAbsolutePath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            GottschCore.logger.error("Couldn't create directories for dump files:", (Throwable)e);
            return;
        }
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        String div = new String(chars) + "\n";
        StringBuilder sb = new StringBuilder();
        String heading = "**  %-67s  **\n";
        sb.append(div).append(String.format("**  %-67s  **\n", "DECAY PROCESSOR")).append(div).append(String.format(heading, "Size: [y][z][x]")).append(div).append(String.format("[%s][%s][%s]\n", size.getY(), size.getZ(), size.getX())).append(div).append(String.format(heading, "Decay BlockInfo List (Sorted): Map[y][z][x] -> DBL[y][z][x]")).append(div);
        for (y = 0; y < this.layout.length; ++y) {
            sb.append(String.format(heading, "Level " + y)).append(div);
            for (z = 0; z < this.layout[y].length; ++z) {
                sb.append(String.format(heading, "Row " + z)).append(div);
                for (x = 0; x < this.layout[y][z].length; ++x) {
                    sb.append(String.format("Map[%s][%s][%s] -> DBL[%s][%s][%s]\n", this.decayBlockInfoList.get(this.layout[y][z][x]).getCoords().getY(), this.decayBlockInfoList.get(this.layout[y][z][x]).getCoords().getZ(), this.decayBlockInfoList.get(this.layout[y][z][x]).getCoords().getX(), y, z, x));
                }
                sb.append(div);
            }
            sb.append("\n").append(div);
        }
        sb.append("\n").append(div).append(String.format(heading, "Wall / Non-wall [1 / 0]")).append(div);
        for (y = 0; y < this.layout.length; ++y) {
            sb.append(String.format(heading, "Level " + y)).append(div);
            for (z = 0; z < this.layout[y].length; ++z) {
                for (x = 0; x < this.layout[y][z].length; ++x) {
                    sb.append(String.format("[%s]", this.decayBlockInfoList.get(this.layout[y][z][x]).isWall() ? 1 : 0));
                }
                sb.append("\n");
            }
            sb.append(div);
        }
        sb.append("\n").append(div);
        sb.append(String.format(heading, "Block / Air [B / A]")).append(div);
        for (y = 0; y < this.layout.length; ++y) {
            sb.append(String.format(heading, "Level " + y));
            for (z = 0; z < this.layout[y].length; ++z) {
                for (x = 0; x < this.layout[y][z].length; ++x) {
                    sb.append(String.format("[%s]", this.decayBlockInfoList.get(this.layout[y][z][x]).getState().func_177230_c() == Blocks.field_150350_a ? "A" : "B"));
                }
                sb.append("\n");
            }
            sb.append(div);
        }
        sb.append("\n");
        sb.append(String.format(heading, "Distance")).append(div);
        for (y = 0; y < this.layout.length; ++y) {
            sb.append(String.format(heading, "Level " + y));
            for (z = 0; z < this.layout[y].length; ++z) {
                for (x = 0; x < this.layout[y][z].length; ++x) {
                    sb.append(String.format("[%s]", this.decayBlockInfoList.get(this.layout[y][z][x]).getDistance()));
                }
                sb.append("\n");
            }
            sb.append(div);
        }
        sb.append("\n");
        sb.append(String.format(heading, "Strength")).append(div);
        for (y = 0; y < this.layout.length; ++y) {
            sb.append(String.format(heading, "Level " + y));
            for (z = 0; z < this.layout[y].length; ++z) {
                for (x = 0; x < this.layout[y][z].length; ++x) {
                    sb.append(String.format("[%s]", df.format(this.decayBlockInfoList.get(this.layout[y][z][x]).getStrength())));
                }
                sb.append("\n");
            }
            sb.append(div);
        }
        try {
            GottschCore.logger.debug("dumping to path: {}", (Object)Paths.get(path.toString(), filename).toAbsolutePath());
            Files.write(Paths.get(path.toString(), filename), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            GottschCore.logger.error("Error writing DecayProcessor to dump file", (Throwable)e);
        }
    }

    public IBlockState applyDecay(IBlockState state, DecayRule decayRule, int decayIndex, Block NULL_BLOCK) {
        String blockValue = "";
        IBlockState blockState = Blocks.field_150350_a.func_176223_P();
        decayIndex = decayIndex < decayRule.getDecayBlocks().size() ? decayIndex : decayRule.getDecayBlocks().size() - 1;
        String string = blockValue = decayIndex > -1 ? decayRule.getDecayBlocks().get(decayIndex) : null;
        if (blockValue == null || blockValue == "") {
            return state;
        }
        if (blockValue.equals(NULL_BLOCK_NAME)) {
            return NULL_BLOCK.func_176223_P();
        }
        String[] blockAndMeta = blockValue.split("@");
        int meta = 0;
        if (blockAndMeta.length > 1) {
            meta = Integer.valueOf(blockAndMeta[1]);
        }
        try {
            blockState = Block.func_149684_b((String)blockAndMeta[0]).func_176203_a(meta);
        }
        catch (Exception e) {
            blockState = null;
        }
        if (blockState == null) {
            GottschCore.logger.warn(String.format("Unable to retrieve blockState; returning original:\nDecay Rule: %s\nBlock: %s\nblockAndMeta[0]: %s\nMeta: %d", decayRule.getName(), blockValue, blockAndMeta[0], meta));
            return state;
        }
        blockState = PropertyHelper.copyProperties(state, blockState);
        return blockState;
    }

    private int getDecayIndex(Random random, DecayRule rule) {
        if (rule.getDecayIterations() <= 0) {
            return -1;
        }
        int decayIndex = -1;
        for (int i = 0; i < rule.getDecayIterations(); ++i) {
            if (!RandomHelper.checkProbability(random, rule.getDecayProbability())) continue;
            ++decayIndex;
        }
        return decayIndex;
    }

    public List<DecayBlockInfo> getDecayBlockInfoList() {
        return this.decayBlockInfoList;
    }

    protected void setDecayBlockInfoList(List<DecayBlockInfo> decayBlockInfoList) {
        this.decayBlockInfoList = decayBlockInfoList;
    }

    public int[][][] getLayout() {
        return this.layout;
    }

    protected void setLayout(int[][][] layout) {
        this.layout = layout;
    }

    @Override
    public IDecayRuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(IDecayRuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @Override
    public boolean isBackFill() {
        return this.backFill;
    }

    @Override
    public void setBackFill(boolean backFill) {
        this.backFill = backFill;
    }

    @Override
    public IBlockState getBackFillBlockLayer1() {
        return this.backFillBlockLayer1;
    }

    @Override
    public void setBackFillBlockLayer1(IBlockState backFillBlockLayer1) {
        this.backFillBlockLayer1 = backFillBlockLayer1;
    }

    @Override
    public IBlockState getBackFillBlockLayer2() {
        return this.backFillBlockLayer2;
    }

    @Override
    public void setBackFillBlockLayer2(IBlockState backFillBlockLayer2) {
        this.backFillBlockLayer2 = backFillBlockLayer2;
    }

    @Override
    public int getDecayStartY() {
        return this.decayStartY;
    }

    @Override
    public void setDecayStartY(int decayStartY) {
        this.decayStartY = decayStartY;
    }
}

